/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.operations;

import ro.sync.ecss.extensions.api.AttributeChangedEvent;
import ro.sync.ecss.extensions.api.AuthorListener;
import ro.sync.ecss.extensions.api.DocumentContentDeletedEvent;
import ro.sync.ecss.extensions.api.DocumentContentInsertedEvent;
import ro.sync.ecss.extensions.api.access.EditingSessionContext;
import ro.sync.ecss.extensions.api.highlights.AuthorPersistentHighlight;
import ro.sync.ecss.extensions.api.highlights.AuthorPersistentHighlightsListener;
import ro.sync.ecss.extensions.api.node.AuthorDocument;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;

public class AuthorDocumentLastModificationTimestampTracker
extends AuthorPersistentHighlightsListener
implements AuthorListener {
    private static final String TIMESTAMP_PROPERTY_NAME = "dif_doc-timestamp";
    private EditingSessionContext editingContext;

    private AuthorDocumentLastModificationTimestampTracker(EditingSessionContext editingContext) {
        this.editingContext = editingContext;
        this.setTimestamp(0L);
    }

    public static long installOnce(AuthorDocumentModel model) {
        EditingSessionContext context = model.getAuthorAccess().getEditorAccess().getEditingContext();
        if (context.getAttribute(TIMESTAMP_PROPERTY_NAME) == null) {
            AuthorDocumentLastModificationTimestampTracker listener = new AuthorDocumentLastModificationTimestampTracker(context);
            model.getAuthorDocumentController().addAuthorListener((AuthorListener)listener);
            model.getAuthorAccess().getReviewController().addAuthorPersistentHighlightListener((AuthorPersistentHighlightsListener)listener);
        }
        return AuthorDocumentLastModificationTimestampTracker.getLastModificationTimestamp(context);
    }

    public long getLastModificationTimestamp() {
        return AuthorDocumentLastModificationTimestampTracker.getLastModificationTimestamp(this.editingContext);
    }

    public static long getLastModificationTimestamp(EditingSessionContext editingContext) {
        return (Long)editingContext.getAttribute(TIMESTAMP_PROPERTY_NAME);
    }

    private void setTimestamp(long timestamp) {
        this.editingContext.setAttribute(TIMESTAMP_PROPERTY_NAME, (Object)timestamp);
    }

    private void incrementTimestamp() {
        this.setTimestamp(AuthorDocumentLastModificationTimestampTracker.getLastModificationTimestamp(this.editingContext) + 1L);
    }

    public void documentChanged(AuthorDocument oldDocument, AuthorDocument newDocument) {
        this.incrementTimestamp();
    }

    public void doctypeChanged() {
        this.incrementTimestamp();
    }

    public void contentInserted(DocumentContentInsertedEvent e) {
        this.incrementTimestamp();
    }

    public void contentDeleted(DocumentContentDeletedEvent e) {
        this.incrementTimestamp();
    }

    public void authorNodeStructureChanged(AuthorNode node) {
        this.incrementTimestamp();
    }

    public void authorNodeNameChanged(AuthorNode node) {
        this.incrementTimestamp();
    }

    public void attributeChanged(AttributeChangedEvent e) {
        this.incrementTimestamp();
    }

    public void beforeDoctypeChange() {
        this.incrementTimestamp();
    }

    public void beforeContentInsert(DocumentContentInsertedEvent e) {
        this.incrementTimestamp();
    }

    public void beforeContentDelete(DocumentContentDeletedEvent e) {
        this.incrementTimestamp();
    }

    public void beforeAuthorNodeStructureChange(AuthorNode authorNode) {
        this.incrementTimestamp();
    }

    public void beforeAuthorNodeNameChange(AuthorNode authorNode) {
        this.incrementTimestamp();
    }

    public void beforeAttributeChange(AttributeChangedEvent e) {
        this.incrementTimestamp();
    }

    public void highlightAdded(AuthorPersistentHighlight highlight) {
        this.incrementTimestamp();
    }

    public void highlightRemoved(AuthorPersistentHighlight highlight) {
        this.incrementTimestamp();
    }

    public void highlightUpdated(AuthorPersistentHighlight highlight) {
        this.incrementTimestamp();
    }

    public void highlightsChanged() {
        this.incrementTimestamp();
    }
}

