/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.model;

import com.oxygenxml.webapp.diff.model.Interval;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;

public class StickyInterval
implements Interval {
    private Position start;
    private Position end;

    public StickyInterval(AuthorDocumentModel model, int start, int end) {
        try {
            this.start = model.getAuthorDocumentController().createPositionInContent(start);
            this.end = model.getAuthorDocumentController().createPositionInContent(end);
        }
        catch (BadLocationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private StickyInterval(Position start, Position end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public int getStartOffset() {
        return this.start.getOffset();
    }

    @Override
    public int getEndOffset() {
        return this.end.getOffset();
    }

    @Override
    public Interval withEnd(Position pos) {
        return new StickyInterval(this.start, pos);
    }

    public String toString() {
        return "Sticky[" + this.start + "," + this.end + ")";
    }
}

