/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.model;

import com.oxygenxml.webapp.diff.model.DiffInterval;
import com.oxygenxml.webapp.diff.model.DiffIntervalsPair;
import com.oxygenxml.webapp.diff.model.Interval;
import com.oxygenxml.webapp.diff.model.ParentDiffInterval;
import com.oxygenxml.webapp.diff.parent.diffs.SpecialCaseParentDiff;
import java.util.List;
import java.util.stream.Collectors;
import ro.sync.diff.api.DifferenceType;
import ro.sync.diff.merge.api.IntervalsPair;

class ParentDiffIntervalsPair {
    private String id;
    private List<DiffIntervalsPair> childrenPairs;
    private DifferenceType parentType;
    private SpecialCaseParentDiff.SpecialCaseParentDiffType specialCase;
    private Interval leftInterval;
    private Interval rightInterval;

    public ParentDiffIntervalsPair(String id, DifferenceType parentType, SpecialCaseParentDiff.SpecialCaseParentDiffType specialCase, Interval leftInterval, Interval rightInterval, List<DiffIntervalsPair> childrenPairs) {
        this.id = id;
        this.parentType = parentType;
        this.specialCase = specialCase;
        this.leftInterval = leftInterval;
        this.rightInterval = rightInterval;
        this.childrenPairs = childrenPairs;
    }

    public int getStart(IntervalsPair.Side side) {
        return this.getIntervalOfContent(side).getStartOffset();
    }

    public int getEnd(IntervalsPair.Side side) {
        return this.getIntervalOfContent(side).getEndOffset();
    }

    private Interval getIntervalOfContent(IntervalsPair.Side side) {
        return side == IntervalsPair.Side.LEFT ? this.leftInterval : this.rightInterval;
    }

    public ParentDiffInterval getInterval(IntervalsPair.Side side) {
        List<DiffInterval> diffIntervals = this.childrenPairs.stream().map(pair -> pair.getDiffInterval(side)).collect(Collectors.toList());
        return new ParentDiffInterval(this.id, this.parentType, diffIntervals, this.specialCase, this.getIntervalOfContent(side));
    }

    public String getId() {
        return this.id;
    }

    public List<DiffIntervalsPair> getChildrenPairs() {
        return this.childrenPairs;
    }

    public void removeChildrenPairs(List<IntervalsPair> toRemove) {
        this.childrenPairs.removeAll(toRemove);
    }

    public boolean isEmpty() {
        return this.childrenPairs.isEmpty();
    }
}

