/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

class IdIndexer<T> {
    private final Map<T, Long> objectToId = new HashMap<T, Long>();
    private final AtomicLong idCounter;

    public IdIndexer(AtomicLong idCounter) {
        this.idCounter = idCounter;
    }

    public IdIndexer() {
        this.idCounter = new AtomicLong();
    }

    public long getId(T object) {
        Objects.requireNonNull(object);
        long id = -1L;
        Long objectId = this.objectToId.get(object);
        id = objectId != null ? objectId.longValue() : this.indexObject(object);
        return id;
    }

    private long indexObject(T object) {
        long currentId = this.idCounter.getAndIncrement();
        this.objectToId.put(object, currentId);
        return currentId;
    }
}

