/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.model;

import com.oxygenxml.webapp.diff.model.DiffModelImpl;
import ro.sync.ecss.extensions.api.access.EditingSessionContext;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;

public class DiffModelStorage {
    private static final String DIFF_MODEL_ATTR_NAME = "diff_intervals";
    private static final String DIFF_MODEL_TMP_ATTR_NAME = "diff_intervals_tmp";
    private EditingSessionContext editingContext;

    public DiffModelStorage(EditingSessionContext editingContext) {
        this.editingContext = editingContext;
    }

    public DiffModelStorage(AuthorDocumentModel adm) {
        this.editingContext = adm.getAuthorAccess().getEditorAccess().getEditingContext();
    }

    public DiffModelImpl getDiffModel() {
        DiffModelImpl diffModelImpl = DiffModelStorage.getModelFromEditingContext(this.editingContext, DIFF_MODEL_ATTR_NAME);
        if (diffModelImpl == null) {
            throw new IllegalStateException("Please reload the page.");
        }
        return diffModelImpl;
    }

    public DiffModelImpl getTempDiffModel() {
        return DiffModelStorage.getModelFromEditingContext(this.editingContext, DIFF_MODEL_TMP_ATTR_NAME);
    }

    public void storeDiffModel(DiffModelImpl model) {
        this.editingContext.setAttribute(DIFF_MODEL_ATTR_NAME, (Object)model);
    }

    public void storeTempDiffModel(DiffModelImpl model) {
        this.editingContext.setAttribute(DIFF_MODEL_TMP_ATTR_NAME, (Object)model);
    }

    public void removeTempDiffModel() {
        this.editingContext.setAttribute(DIFF_MODEL_TMP_ATTR_NAME, null);
    }

    private static DiffModelImpl getModelFromEditingContext(EditingSessionContext editingContext, String contextAttributeName) {
        return (DiffModelImpl)editingContext.getAttribute(contextAttributeName);
    }
}

