/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.model;

import com.oxygenxml.webapp.diff.model.DiffIntervalsPair;
import com.oxygenxml.webapp.diff.model.ParentDiffInterval;
import com.oxygenxml.webapp.diff.model.ParentDiffIntervalsPair;
import com.oxygenxml.webapp.diff.operations.DiffHighlightsManager;
import com.oxygenxml.webapp.diff.operations.descriptors.DifferenceDescriptor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import ro.sync.diff.merge.api.DiffModel;
import ro.sync.diff.merge.api.IntervalsPair;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;

public class DiffModelImpl
implements DiffModel {
    private List<ParentDiffIntervalsPair> intervalsPairs;
    private Set<String> removedDiffIds = new HashSet<String>();
    private AuthorDocumentModel docModel;
    private long docTimestamp;
    private Map<String, Map<String, List<DifferenceDescriptor>>> differencesDescriptors;

    DiffModelImpl(List<ParentDiffIntervalsPair> intervalsPairs, AuthorDocumentModel docModel, long documentTimestamp, Map<String, Map<String, List<DifferenceDescriptor>>> differencesDescriptors) {
        this.intervalsPairs = intervalsPairs;
        this.docModel = docModel;
        this.docTimestamp = documentTimestamp;
        this.differencesDescriptors = differencesDescriptors;
    }

    public List<IntervalsPair> getAllDiffs() {
        ArrayList<IntervalsPair> toReturn = new ArrayList<IntervalsPair>();
        for (ParentDiffIntervalsPair pair : this.intervalsPairs) {
            toReturn.addAll(pair.getChildrenPairs());
        }
        return toReturn;
    }

    public void removeDiffs(List<IntervalsPair> toRemove) {
        for (ParentDiffIntervalsPair pair : this.intervalsPairs) {
            pair.removeChildrenPairs(toRemove);
        }
        this.intervalsPairs.removeIf(ParentDiffIntervalsPair::isEmpty);
        toRemove.stream().map(DiffIntervalsPair.class::cast).map(DiffIntervalsPair::getId).forEach(this.removedDiffIds::add);
    }

    public void setEndPosition(IntervalsPair intervalsPair, IntervalsPair.Side side, int endOffset) {
        Position endPos;
        DiffIntervalsPair diffPair = (DiffIntervalsPair)intervalsPair;
        AuthorDocumentController controller = this.docModel.getAuthorDocumentController();
        try {
            endPos = controller.createPositionInContent(endOffset);
        }
        catch (BadLocationException e) {
            throw new IllegalStateException(e);
        }
        diffPair.setEndPosition(side, endPos);
        new DiffHighlightsManager(this.docModel).updateHighlightEndPosition(diffPair.getDiffInterval(IntervalsPair.Side.LEFT));
    }

    public List<ParentDiffInterval> getParentDiffIntervals(IntervalsPair.Side side) {
        return this.intervalsPairs.stream().map(pair -> pair.getInterval(side)).collect(Collectors.toList());
    }

    public List<DiffIntervalsPair> findDiffsByParentId(String parentDiffId) {
        return this.intervalsPairs.stream().filter(parentDiff -> parentDiffId.equals(parentDiff.getId())).flatMap(parentDiff -> parentDiff.getChildrenPairs().stream()).collect(Collectors.toList());
    }

    public Optional<DiffIntervalsPair> findDiffById(String diffId) {
        return this.getAllDiffs().stream().map(DiffIntervalsPair.class::cast).filter(diffPair -> diffId.equals(diffPair.getId())).findAny();
    }

    public long getDocTimestamp() {
        return this.docTimestamp;
    }

    public Set<String> getRemovedDiffIds() {
        return this.removedDiffIds;
    }

    public boolean isAlreadyMerged(DiffIntervalsPair diffPair) {
        return this.removedDiffIds.contains(diffPair.getId());
    }

    public Map<String, Map<String, List<DifferenceDescriptor>>> getDifferencesDescriptors() {
        return this.differencesDescriptors;
    }
}

