/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.model;

import com.oxygenxml.webapp.diff.model.DiffIntervalImpl;
import com.oxygenxml.webapp.diff.model.DiffIntervalsPair;
import com.oxygenxml.webapp.diff.model.DiffModelImpl;
import com.oxygenxml.webapp.diff.model.IdIndexer;
import com.oxygenxml.webapp.diff.model.Interval;
import com.oxygenxml.webapp.diff.model.ParentDiffIntervalsPair;
import com.oxygenxml.webapp.diff.model.StaticInterval;
import com.oxygenxml.webapp.diff.model.StickyInterval;
import com.oxygenxml.webapp.diff.operations.AuthorDocumentLastModificationTimestampTracker;
import com.oxygenxml.webapp.diff.operations.descriptors.DifferenceDescriptor;
import com.oxygenxml.webapp.diff.operations.descriptors.DifferencesDescriptorsDetector;
import com.oxygenxml.webapp.diff.parent.diffs.SpecialCaseParentDiff;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.text.BadLocationException;
import ro.sync.diff.api.Difference;
import ro.sync.diff.api.DifferenceParent;
import ro.sync.diff.api.DifferenceType;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.access.EditingSessionContext;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;

public class DiffModelBuilder {
    private static final String DIFF_NODES_INDEXER_CONTEXT_ATTR_NAME = "diff-nodes-indexer";
    private boolean useStickyIntervalsOnLeft = false;
    private AuthorDocumentModel leftDocument;

    public DiffModelImpl buildFromDifferenceParents(List<? extends DifferenceParent> parentDiffs, DifferencesDescriptorsDetector diffsDescriptorsDetector) {
        long lastModificationTimestamp = AuthorDocumentLastModificationTimestampTracker.installOnce(this.leftDocument);
        HashSet<String> parentDiffIds = new HashSet<String>();
        TreeMap<String, Map<String, List<DifferenceDescriptor>>> diffsDescriptors = new TreeMap<String, Map<String, List<DifferenceDescriptor>>>();
        ArrayList<ParentDiffIntervalsPair> pairs = new ArrayList<ParentDiffIntervalsPair>();
        for (DifferenceParent differenceParent : parentDiffs) {
            String parentDiffId = this.getParentDiffId(differenceParent, parentDiffIds);
            parentDiffIds.add(parentDiffId);
            TreeMap<CallSite, List<DifferenceDescriptor>> secondLevelDiffDescriptors = new TreeMap<CallSite, List<DifferenceDescriptor>>();
            diffsDescriptors.put(parentDiffId, secondLevelDiffDescriptors);
            ArrayList<DiffIntervalsPair> childrenPairs = new ArrayList<DiffIntervalsPair>();
            List secondLevelDiffs = differenceParent.getChildren();
            for (int i = 0; i < secondLevelDiffs.size(); ++i) {
                Difference diffEntry = (Difference)secondLevelDiffs.get(i);
                DifferenceType type = diffEntry.getType();
                String secondLevelDiffId = parentDiffId + "." + i;
                Interval leftInterval = this.createLeftInterval(diffEntry, this.leftDocument);
                DiffIntervalImpl left = new DiffIntervalImpl(secondLevelDiffId, leftInterval, type);
                StaticInterval rightInterval = this.createRightInterval(diffEntry);
                DiffIntervalImpl right = new DiffIntervalImpl(secondLevelDiffId, rightInterval, type);
                DiffIntervalsPair childPair = new DiffIntervalsPair(left, right);
                childrenPairs.add(childPair);
                List<DifferenceDescriptor> diffDescriptors = diffsDescriptorsDetector.computeDiffsDescriptors(diffEntry);
                secondLevelDiffDescriptors.put((CallSite)((Object)secondLevelDiffId), diffDescriptors);
            }
            Interval leftInterval = this.createLeftInterval((Difference)differenceParent, this.leftDocument);
            StaticInterval rightInterval = this.createRightInterval((Difference)differenceParent);
            ParentDiffIntervalsPair pair = new ParentDiffIntervalsPair(parentDiffId, differenceParent.getType(), DiffModelBuilder.getSpecialDiffType(differenceParent), leftInterval, rightInterval, childrenPairs);
            pairs.add(pair);
        }
        return new DiffModelImpl(pairs, this.leftDocument, lastModificationTimestamp, diffsDescriptors);
    }

    private String getParentDiffId(DifferenceParent parentDiff, Set<String> existingParentDiffIds) {
        String blockElementId;
        try {
            int leftIntervalStart = parentDiff.getLeftIntervalStart();
            AuthorDocumentController controller = this.leftDocument.getAuthorDocumentController();
            AuthorNode blockElement = controller.getNodeAtOffset(leftIntervalStart + 1);
            blockElementId = String.valueOf(DiffModelBuilder.getOrInitNodesIndexer(this.leftDocument).getId(blockElement));
        }
        catch (BadLocationException e) {
            blockElementId = String.valueOf(Integer.MAX_VALUE);
        }
        if (!existingParentDiffIds.contains(blockElementId)) {
            return blockElementId;
        }
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            String candidate = blockElementId + "-" + i;
            if (existingParentDiffIds.contains(candidate)) continue;
            return candidate;
        }
        throw new IllegalStateException();
    }

    private StaticInterval createRightInterval(Difference difference) {
        return new StaticInterval(difference.getRightIntervalStart(), difference.getRightIntervalEnd());
    }

    private Interval createLeftInterval(Difference difference, AuthorDocumentModel leftDocument) {
        if (this.useStickyIntervalsOnLeft) {
            return new StickyInterval(leftDocument, difference.getLeftIntervalStart(), difference.getLeftIntervalEnd());
        }
        return new StaticInterval(difference.getLeftIntervalStart(), difference.getLeftIntervalEnd());
    }

    private static SpecialCaseParentDiff.SpecialCaseParentDiffType getSpecialDiffType(DifferenceParent difference) {
        SpecialCaseParentDiff.SpecialCaseParentDiffType specialCase = difference instanceof SpecialCaseParentDiff ? ((SpecialCaseParentDiff)difference).getSpecialCaseType() : null;
        return specialCase;
    }

    private static IdIndexer<AuthorNode> getOrInitNodesIndexer(AuthorDocumentModel leftDocument) {
        IdIndexer<AuthorNode> nodesIndexer;
        EditingSessionContext editingContext = leftDocument.getAuthorAccess().getEditorAccess().getEditingContext();
        Object nodesIndexerStored = editingContext.getAttribute(DIFF_NODES_INDEXER_CONTEXT_ATTR_NAME);
        if (nodesIndexerStored == null) {
            nodesIndexer = new IdIndexer<AuthorNode>();
            editingContext.setAttribute(DIFF_NODES_INDEXER_CONTEXT_ATTR_NAME, nodesIndexer);
        } else {
            nodesIndexer = (IdIndexer<AuthorNode>)nodesIndexerStored;
        }
        return nodesIndexer;
    }

    public DiffModelBuilder useStickyIntervalsOnLeft() {
        this.useStickyIntervalsOnLeft = true;
        return this;
    }

    public DiffModelBuilder setLeftDocument(AuthorDocumentModel leftDocument) {
        this.leftDocument = leftDocument;
        return this;
    }
}

