/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.model;

import com.oxygenxml.webapp.diff.model.DiffInterval;
import javax.swing.text.Position;
import ro.sync.diff.api.DifferenceType;
import ro.sync.diff.merge.api.IntervalsPair;
import ro.sync.ecss.extensions.api.ContentInterval;

public class DiffIntervalsPair
implements IntervalsPair {
    private DiffInterval leftInterval;
    private DiffInterval rightInterval;
    private final String id;
    private final DifferenceType type;

    public DiffIntervalsPair(DiffInterval leftInterval, DiffInterval rightInterval) {
        this.leftInterval = leftInterval;
        this.rightInterval = rightInterval;
        this.id = leftInterval.getId();
        this.type = leftInterval.getType();
    }

    public int getStart(IntervalsPair.Side side) {
        return this.getInterval(side).getStartOffset();
    }

    public int getEnd(IntervalsPair.Side side) {
        return this.getInterval(side).getEndOffset();
    }

    public ContentInterval getInterval(IntervalsPair.Side side) {
        return this.getDiffInterval(side).asContentInterval();
    }

    DiffInterval getDiffInterval(IntervalsPair.Side side) {
        return side == IntervalsPair.Side.LEFT ? this.leftInterval : this.rightInterval;
    }

    public void setEndPosition(IntervalsPair.Side side, Position endPos) {
        DiffInterval oldInterval = this.getDiffInterval(side);
        DiffInterval newInterval = oldInterval.withEnd(endPos);
        if (side == IntervalsPair.Side.LEFT) {
            this.leftInterval = newInterval;
        } else {
            this.rightInterval = newInterval;
        }
    }

    public String getId() {
        return this.id;
    }

    public DifferenceType getType() {
        return this.type;
    }

    public String toString() {
        return "{left: " + this.leftInterval + ", right:" + this.rightInterval + "}";
    }
}

