/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff.model;

import com.oxygenxml.webapp.diff.model.DiffInterval;
import com.oxygenxml.webapp.diff.model.Interval;
import java.util.Objects;
import javax.swing.text.Position;
import ro.sync.diff.api.DifferenceType;
import ro.sync.ecss.extensions.api.ContentInterval;

class DiffIntervalImpl
implements DiffInterval {
    private final DifferenceType type;
    private final String id;
    private Interval interval;

    public DiffIntervalImpl(String id, Interval interval, DifferenceType type) {
        this.interval = interval;
        this.id = id;
        this.type = type;
    }

    public DiffIntervalImpl() {
        this.id = null;
        this.type = null;
    }

    @Override
    public int compareTo(DiffInterval o) {
        return this.getStart() - o.getStart();
    }

    @Override
    public int getStart() {
        return this.interval.getStartOffset();
    }

    @Override
    public int getEnd() {
        return this.interval.getEndOffset();
    }

    public int hashCode() {
        return Objects.hash(this.getStart(), this.getEnd());
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public ContentInterval asContentInterval() {
        return new ContentInterval(this.getStart(), this.getEnd());
    }

    @Override
    public DifferenceType getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getParentId() {
        return this.id.split("\\.")[0];
    }

    @Override
    public DiffInterval withEnd(Position endPos) {
        return new DiffIntervalImpl(this.id, this.interval.withEnd(endPos), this.type);
    }

    public String toString() {
        return this.interval + "<" + this.id + ":" + this.type + ">";
    }
}

