/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.oxygenxml.webapp.diff.DiffDocumentsLinker;
import com.oxygenxml.webapp.diff.model.DiffModelBuilder;
import com.oxygenxml.webapp.diff.model.DiffModelImpl;
import com.oxygenxml.webapp.diff.operations.ComputeDiffsOperation;
import com.oxygenxml.webapp.diff.operations.descriptors.DifferencesDescriptorsDetector;
import com.oxygenxml.webapp.diff.parent.ParentDiffsProvider;
import com.oxygenxml.webapp.diff.parent.diffs.ParentDiff;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.diff.api.AuthorDifferencePerformer;
import ro.sync.diff.api.DiffException;
import ro.sync.diff.merge.api.IntervalsPair;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.WSEditor;

public class DiffPerformer {
    private static final Logger log = LoggerFactory.getLogger(DiffPerformer.class);
    private AuthorDifferencePerformer diffPerformer;

    public DiffPerformer() throws DiffNotLicensedException {
        try {
            this.diffPerformer = PluginWorkspaceProvider.getPluginWorkspace().getCompareUtilAccess().createAuthorDiffPerformer();
        }
        catch (DiffException e) {
            throw new DiffNotLicensedException(e.getMessage());
        }
    }

    public DiffModelImpl computeDiffsModel(AuthorDocumentModel leftDocumentModel, AuthorDocumentModel rightDocumentModel, Optional<DiffDocumentsLinker.DiffBaseData> baseOpt) throws DiffException, IOException, DiffNotLicensedException {
        AuthorDocumentModel baseDocumentModel = baseOpt.isPresent() && !baseOpt.get().isLoadFailed() ? baseOpt.get().getAuthorDocumentModel() : rightDocumentModel;
        List<ParentDiff> parentDiffs = this.performDiff(leftDocumentModel, rightDocumentModel, baseDocumentModel);
        DifferencesDescriptorsDetector diffsDescriptorsDetector = baseOpt.isPresent() ? new DifferencesDescriptorsDetector(leftDocumentModel, rightDocumentModel, baseOpt.get().getAuthorDocumentModel()) : new DifferencesDescriptorsDetector(leftDocumentModel, rightDocumentModel, null);
        DiffModelImpl diffModel = new DiffModelBuilder().useStickyIntervalsOnLeft().setLeftDocument(leftDocumentModel).buildFromDifferenceParents(parentDiffs, diffsDescriptorsDetector);
        return diffModel;
    }

    public ComputeDiffsOperation.DiffResponseStatus computeResposeStatus(AuthorDocumentModel leftDocumentModel, AuthorDocumentModel rightDocumentModel, Optional<DiffDocumentsLinker.DiffBaseData> baseOpt, DiffModelImpl diffModel) {
        ComputeDiffsOperation.DiffResponseStatus status;
        block5: {
            if (diffModel.getParentDiffIntervals(IntervalsPair.Side.LEFT).isEmpty()) {
                try {
                    byte[] leftBytesOrigEncoding = this.getBytesOriginalEncoding(leftDocumentModel);
                    byte[] rightBytesOrigEncoding = this.getBytesOriginalEncoding(rightDocumentModel);
                    if (Arrays.equals(leftBytesOrigEncoding, rightBytesOrigEncoding)) {
                        status = ComputeDiffsOperation.DiffResponseStatus.RESPONSE_NO_DIFF;
                        break block5;
                    }
                    status = ComputeDiffsOperation.DiffResponseStatus.RESPONSE_NO_AUTHOR_DIFF;
                }
                catch (IOException e) {
                    log.warn(e.getMessage(), (Throwable)e);
                    status = ComputeDiffsOperation.DiffResponseStatus.RESPONSE_NO_AUTHOR_DIFF;
                }
            } else {
                status = baseOpt.isPresent() && baseOpt.get().isLoadFailed() ? ComputeDiffsOperation.DiffResponseStatus.RESPONSE_FAIL_TO_LOAD_BASE : ComputeDiffsOperation.DiffResponseStatus.RESPONSE_SUCCESS;
            }
        }
        return status;
    }

    private byte[] getBytesOriginalEncoding(AuthorDocumentModel docModel) throws IOException {
        WSEditor wsEditor = docModel.getWSEditor();
        try (InputStream contentStream = (InputStream)Preconditions.checkNotNull((Object)wsEditor.createContentInputStream());){
            byte[] byArray = ByteStreams.toByteArray((InputStream)contentStream);
            return byArray;
        }
    }

    @VisibleForTesting
    public List<ParentDiff> performDiff(AuthorDocumentModel leftDocumentModel, AuthorDocumentModel rightDocumentModel, AuthorDocumentModel baseDocumentModel) throws DiffException, IOException {
        this.diffPerformer.setBaseDocument(baseDocumentModel.getAuthorAccess());
        this.diffPerformer.setDocumentsToCompare(leftDocumentModel.getAuthorAccess(), rightDocumentModel.getAuthorAccess());
        List diffs = this.diffPerformer.performDiff(null);
        ParentDiffsProvider parentsProvider = new ParentDiffsProvider(leftDocumentModel, rightDocumentModel, diffs);
        return parentsProvider.getParentDiffs();
    }

    @VisibleForTesting
    public List<ParentDiff> performDiff(AuthorDocumentModel leftDocumentModel, AuthorDocumentModel rightDocumentModel) throws DiffException, IOException {
        return this.performDiff(leftDocumentModel, rightDocumentModel, rightDocumentModel);
    }

    public static class DiffNotLicensedException
    extends Exception {
        private static final long serialVersionUID = -5153555074772929251L;

        public DiffNotLicensedException(String message) {
            super(message);
        }
    }
}

