/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff;

import java.lang.ref.WeakReference;
import java.util.Optional;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.access.EditingSessionContext;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;

public class DiffDocumentsLinker {
    public static final String PARENT_EDITING_CONTEXT_ATTR_NAME = "parent.editing.context";
    public static final String DIFF_PAIR_EDITOR_ATTR_NAME = "diff_pair_editor";
    public static final String DIFF_BASE_ATTR_NAME = "diff_base_data";
    private AuthorDocumentModel leftDocument;

    public DiffDocumentsLinker(AuthorDocumentModel leftDocument) {
        this.leftDocument = leftDocument;
    }

    public AuthorDocumentModel getPair() {
        AuthorEditorAccess leftEditorAccess = this.leftDocument.getAuthorAccess().getEditorAccess();
        WeakReference rightDocumentModelRef = (WeakReference)leftEditorAccess.getEditingContext().getAttribute(DIFF_PAIR_EDITOR_ATTR_NAME);
        AuthorDocumentModel adm = (AuthorDocumentModel)rightDocumentModelRef.get();
        if (adm == null) {
            throw new IllegalStateException("Right document not available.");
        }
        return adm;
    }

    public Optional<DiffBaseData> getBase() {
        AuthorEditorAccess leftEditorAccess = this.leftDocument.getAuthorAccess().getEditorAccess();
        DiffBaseData diffBaseData = (DiffBaseData)leftEditorAccess.getEditingContext().getAttribute(DIFF_BASE_ATTR_NAME);
        return Optional.ofNullable(diffBaseData);
    }

    public void setBase(DiffBaseData baseData) {
        AuthorEditorAccess leftEditorAccess = this.leftDocument.getAuthorAccess().getEditorAccess();
        leftEditorAccess.getEditingContext().setAttribute(DIFF_BASE_ATTR_NAME, (Object)baseData);
    }

    public static void establishPairForRightDocument(AuthorDocumentModel rightDocumentModel) throws AuthorOperationException {
        AuthorAccess authorAccess = rightDocumentModel.getAuthorAccess();
        EditingSessionContext editingContext = authorAccess.getEditorAccess().getEditingContext();
        EditingSessionContext leftEditingContext = DiffDocumentsLinker.getLeftEditingContext(editingContext);
        if (leftEditingContext == null) {
            throw new AuthorOperationException("Parent editing context not found.");
        }
        leftEditingContext.setAttribute(DIFF_PAIR_EDITOR_ATTR_NAME, new WeakReference<AuthorDocumentModel>(rightDocumentModel));
    }

    public static EditingSessionContext getLeftEditingContext(EditingSessionContext rightEditingContext) {
        return (EditingSessionContext)rightEditingContext.getAttribute(PARENT_EDITING_CONTEXT_ATTR_NAME);
    }

    public static class DiffBaseData {
        private final boolean loadFailed;
        private final AuthorDocumentModel adm;

        public DiffBaseData(AuthorDocumentModel adm, boolean loadFailed) {
            this.adm = adm;
            this.loadFailed = loadFailed;
        }

        public boolean isLoadFailed() {
            return this.loadFailed;
        }

        public AuthorDocumentModel getAuthorDocumentModel() {
            return this.adm;
        }
    }
}

