/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.oxygenxml.webapp.diff.operations.ComputeDiffsOperation;
import com.oxygenxml.webapp.diff.operations.DiffOperationFailureResponse;
import com.oxygenxml.webapp.diff.operations.TextDiffOperationSuccessResponse;
import com.oxygenxml.webapp.diff.operations.parentdescriptor.AllTextDifferences;
import com.oxygenxml.webapp.diff.operations.parentdescriptor.TextDiffDescriptor;
import com.oxygenxml.webapp.diff.operations.parentdescriptor.TextParentDiffDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import ro.sync.diff.api.DiffException;
import ro.sync.diff.api.DiffOptions;
import ro.sync.diff.api.DiffProgressListener;
import ro.sync.diff.api.DifferencePerformer;
import ro.sync.diff.factory.CannotHandleException;
import ro.sync.diff.text.DiffEntry;
import ro.sync.diff.ui.files.DiffParentEntry;
import ro.sync.ecss.extensions.api.webapp.plugin.ServletPluginExtension;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.ServletException;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletRequest;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletResponse;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class ComputeTextDiffsServlet
extends ServletPluginExtension {
    public String getPath() {
        return "compute-text-diffs";
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        JsonNode tree = new ObjectMapper().readTree((InputStream)req.getInputStream());
        TextNode leftDoc = (TextNode)tree.get("leftEditorContent");
        TextNode rightDoc = (TextNode)tree.get("rightEditorContent");
        JsonNode baseDoc = tree.get("baseEditorContent");
        String baseDocText = null;
        if (!(baseDoc instanceof NullNode)) {
            baseDocText = ((TextNode)baseDoc).asText();
        }
        boolean failedToLoadBase = tree.get("failedToLoadBase") != null && tree.get("failedToLoadBase").asBoolean();
        TextNode contentTypeNode = (TextNode)tree.get("contentType");
        String contentType = contentTypeNode != null ? contentTypeNode.asText() : null;
        boolean ignoreWhitespaces = tree.get("ignoreWhitespaces") != null && tree.get("ignoreWhitespaces").asBoolean();
        String responseStr = this.computeSerializedDiffResponse(leftDoc.asText(), rightDoc.asText(), Optional.ofNullable(baseDocText), failedToLoadBase, contentType, ignoreWhitespaces);
        resp.setStatus(200);
        resp.setHeader("Content-Type", "application/json; charset=utf-8");
        resp.setCharacterEncoding("UTF-8");
        resp.getWriter().write(responseStr);
        resp.getWriter().flush();
    }

    String computeSerializedDiffResponse(String leftDocument, String rightDocument, Optional<String> baseDocumentOpt, boolean failedToLoadBase, String contentType, boolean ignoreWhitespaces) throws JsonProcessingException {
        ComputeDiffsOperation.DiffOperationResponse response = this.computeDiff(leftDocument, rightDocument, baseDocumentOpt, failedToLoadBase, contentType, ignoreWhitespaces);
        return new ObjectMapper().writeValueAsString((Object)response);
    }

    public ComputeDiffsOperation.DiffOperationResponse computeDiff(String leftDocument, String rightDocument, Optional<String> baseDocumentOpt, boolean failedToLoadBase) {
        return this.computeDiff(leftDocument, rightDocument, baseDocumentOpt, failedToLoadBase, null, false);
    }

    public ComputeDiffsOperation.DiffOperationResponse computeDiff(String leftDocument, String rightDocument, Optional<String> baseDocumentOpt, boolean failedToLoadBase, boolean ignoreWhitespaces) {
        return this.computeDiff(leftDocument, rightDocument, baseDocumentOpt, failedToLoadBase, null, ignoreWhitespaces);
    }

    public ComputeDiffsOperation.DiffOperationResponse computeDiff(String leftDocument, String rightDocument, Optional<String> baseDocumentOpt, boolean failedToLoadBase, String contentType) {
        return this.computeDiff(leftDocument, rightDocument, baseDocumentOpt, failedToLoadBase, contentType, false);
    }

    public ComputeDiffsOperation.DiffOperationResponse computeDiff(String leftDocument, String rightDocument, Optional<String> baseDocumentOpt, boolean failedToLoadBase, String contentType, boolean ignoreWhitespaces) {
        if (leftDocument.equals(rightDocument)) {
            return new TextDiffOperationSuccessResponse(ComputeDiffsOperation.DiffResponseStatus.RESPONSE_NO_DIFF, AllTextDifferences.noDifferences(), AllTextDifferences.noDifferences());
        }
        StringReader leftContentReader = new StringReader(leftDocument);
        StringReader rightContentReader = new StringReader(rightDocument);
        StringReader baseContentReader = new StringReader(baseDocumentOpt.orElse(rightDocument));
        String leftSystemId = null;
        String rightSystemId = null;
        String baseSystemId = null;
        String contentTypeForDiff = contentType != null ? contentType : "text/plain";
        DiffOptions diffOptions = new DiffOptions();
        diffOptions.setAlgorithm(3);
        diffOptions.setEnableHierarchicalDiff(true);
        diffOptions.setIgnoreWhitespaces(ignoreWhitespaces);
        DiffProgressListener diffProgressListener = null;
        ComputeDiffsOperation.DiffOperationResponse response = null;
        try {
            DifferencePerformer diffPerformer = PluginWorkspaceProvider.getPluginWorkspace().getCompareUtilAccess().createDiffPerformer();
            List differences = diffPerformer.performDiff((Reader)leftContentReader, (Reader)rightContentReader, (Reader)baseContentReader, leftSystemId, rightSystemId, baseSystemId, contentTypeForDiff, diffOptions, diffProgressListener);
            List<DiffParentEntry> diffParentEntries = differences.stream().map(DiffParentEntry.class::cast).collect(Collectors.toList());
            response = ComputeTextDiffsServlet.getDiffsResponse(diffParentEntries, failedToLoadBase, leftDocument, rightDocument, ignoreWhitespaces);
        }
        catch (IOException | DiffException | CannotHandleException e) {
            e.printStackTrace();
            response = new DiffOperationFailureResponse("Unable to perform diff.");
        }
        return response;
    }

    private static TextDiffOperationSuccessResponse getDiffsResponse(List<DiffParentEntry> diffParentEntries, boolean failedToLoadBase, String leftDocument, String rightDocument, boolean ignoreWhitespaces) {
        ArrayList<TextParentDiffDescriptor> leftParentDescriptors = new ArrayList<TextParentDiffDescriptor>();
        ArrayList<TextParentDiffDescriptor> rightParentDescriptors = new ArrayList<TextParentDiffDescriptor>();
        HashMap<String, TextDiffDescriptor> leftSecondLevelIntervals = new HashMap<String, TextDiffDescriptor>();
        HashMap<String, TextDiffDescriptor> rightSecondLevelIntervals = new HashMap<String, TextDiffDescriptor>();
        ArrayList<String> secondLevelDiffIds = new ArrayList<String>();
        if (diffParentEntries != null) {
            for (int i = 0; i < diffParentEntries.size(); ++i) {
                DiffParentEntry parentDiff = diffParentEntries.get(i);
                if (ignoreWhitespaces) {
                    for (DiffEntry secondLevelDiff : parentDiff.getChildren()) {
                        String leftDiffChunk = leftDocument.substring(secondLevelDiff.getLeftIntervalStart(), secondLevelDiff.getLeftIntervalEnd());
                        String rightDiffChunk = rightDocument.substring(secondLevelDiff.getRightIntervalStart(), secondLevelDiff.getRightIntervalEnd());
                        if (!leftDiffChunk.trim().equals(rightDiffChunk.trim())) continue;
                        parentDiff.removeChildDiff(secondLevelDiff);
                    }
                }
                boolean isLeftParentBetweenLines = ComputeTextDiffsServlet.isDiffBetweenLines(parentDiff, true);
                leftParentDescriptors.add(new TextParentDiffDescriptor(String.valueOf(i), String.valueOf(parentDiff.getType()), parentDiff.getLeftIntervalStart(), parentDiff.getLeftIntervalEnd(), isLeftParentBetweenLines));
                boolean isRightParentBetweenLines = ComputeTextDiffsServlet.isDiffBetweenLines(parentDiff, false);
                rightParentDescriptors.add(new TextParentDiffDescriptor(String.valueOf(i), String.valueOf(parentDiff.getType()), parentDiff.getRightIntervalStart(), parentDiff.getRightIntervalEnd(), isRightParentBetweenLines));
                List children = parentDiff.getChildren();
                for (int j = 0; j < children.size(); ++j) {
                    String secondLevelDiffId = i + "." + j;
                    DiffEntry secondLevelDiff = (DiffEntry)children.get(j);
                    secondLevelDiffIds.add(secondLevelDiffId);
                    TextDiffDescriptor leftInterval = new TextDiffDescriptor(secondLevelDiff.getLeftIntervalStart(), secondLevelDiff.getLeftIntervalEnd(), isLeftParentBetweenLines, secondLevelDiff.getType());
                    TextDiffDescriptor rightInterval = new TextDiffDescriptor(secondLevelDiff.getRightIntervalStart(), secondLevelDiff.getRightIntervalEnd(), isRightParentBetweenLines, secondLevelDiff.getType());
                    leftSecondLevelIntervals.put(secondLevelDiffId, leftInterval);
                    rightSecondLevelIntervals.put(secondLevelDiffId, rightInterval);
                }
            }
        }
        AllTextDifferences leftDiffs = new AllTextDifferences(leftParentDescriptors, secondLevelDiffIds, leftSecondLevelIntervals);
        AllTextDifferences rightDiffs = new AllTextDifferences(rightParentDescriptors, secondLevelDiffIds, rightSecondLevelIntervals);
        ComputeDiffsOperation.DiffResponseStatus status = ComputeDiffsOperation.DiffResponseStatus.RESPONSE_SUCCESS;
        if (leftParentDescriptors.isEmpty()) {
            status = ComputeDiffsOperation.DiffResponseStatus.NO_SIGNIFICANT_CHANGES;
        } else if (failedToLoadBase) {
            status = ComputeDiffsOperation.DiffResponseStatus.RESPONSE_FAIL_TO_LOAD_BASE;
        }
        return new TextDiffOperationSuccessResponse(status, leftDiffs, rightDiffs);
    }

    private static boolean isDiffBetweenLines(DiffParentEntry parentDiff, boolean isLeft) {
        if (isLeft) {
            return parentDiff.getLeftIntervalStart() == parentDiff.getLeftIntervalEnd();
        }
        return parentDiff.getRightIntervalStart() == parentDiff.getRightIntervalEnd();
    }
}

