/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.diff;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.css.Styles;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorReferenceNode;

public class AuthorUtil {
    private static final Logger log = LoggerFactory.getLogger(AuthorUtil.class);

    private AuthorUtil() {
    }

    public static AuthorNode getBlockAncestor(AuthorAccess authorAccess, AuthorNode node) {
        AuthorNode blockNode = null;
        Styles styles = authorAccess.getEditorAccess().getStyles(node);
        AuthorDocumentController documentController = authorAccess.getDocumentController();
        AuthorNode referenceAncestor = AuthorUtil.getReferenceAncestor(node, documentController);
        if (referenceAncestor != null) {
            node = referenceAncestor.getParent();
        }
        if (AuthorUtil.isBlock(node, styles, documentController)) {
            AuthorNode row = AuthorUtil.getRowAncestorOrSelf(node, styles, authorAccess);
            blockNode = row != null ? row : node;
        } else {
            AuthorNode parent = node.getParent();
            if (parent != null && parent.getType() == 2) {
                blockNode = node;
            } else if (parent != null) {
                blockNode = AuthorUtil.getBlockAncestor(authorAccess, parent);
            }
        }
        return blockNode;
    }

    public static AuthorNode getReferenceAncestor(AuthorNode node, AuthorDocumentController docCtrl) {
        AuthorNode referenceAncestor = null;
        AuthorElement rootElement = docCtrl.getAuthorDocumentNode().getRootElement();
        while (node != null && node != rootElement) {
            if (AuthorUtil.isTransparent(node)) {
                referenceAncestor = node;
            }
            node = node.getParent();
        }
        return referenceAncestor;
    }

    public static boolean isBlock(AuthorNode node, Styles styles, AuthorDocumentController controller) {
        boolean blockDisplay = "block".equals(styles.getDisplay()) || styles.isInTable() || styles.isListItem() || AuthorUtil.isMorphBlock(node, styles, controller);
        return blockDisplay && !AuthorUtil.isTransparent(node);
    }

    private static AuthorNode getRowAncestorOrSelf(AuthorNode node, Styles styles, AuthorAccess authorAccess) {
        AuthorNode rowAncestor = null;
        AuthorElement rootElement = authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement();
        while (node != null && node != rootElement) {
            if (styles.isTableRow()) {
                rowAncestor = node;
            }
            styles = (node = node.getParent()) != null ? authorAccess.getEditorAccess().getStyles(node) : null;
        }
        return rowAncestor;
    }

    private static boolean isMorphBlock(AuthorNode node, Styles styles, AuthorDocumentController controller) {
        boolean morphBlock = false;
        if (styles.isMorphDisplay()) {
            try {
                morphBlock = !controller.inInlineContext(node.getStartOffset() + 1);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return morphBlock;
    }

    private static boolean isTransparent(AuthorNode element) {
        boolean transparent = false;
        if (element instanceof AuthorReferenceNode) {
            transparent = true;
            List contentNodes = ((AuthorReferenceNode)element).getContentNodes();
            if (contentNodes.isEmpty()) {
                transparent = false;
            } else if (((AuthorNode)contentNodes.get(0)).getStartOffset() > element.getStartOffset() + 1) {
                transparent = false;
            } else if (((AuthorNode)contentNodes.get(contentNodes.size() - 1)).getEndOffset() < element.getEndOffset() - 1) {
                transparent = false;
            }
        }
        return transparent;
    }
}

