/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.ce.debug;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import com.oxygenxml.webapp.ce.ConcurrentPlugin;
import com.oxygenxml.webapp.ce.debug.a;
import com.oxygenxml.webapp.ce.impl.C;
import com.oxygenxml.webapp.ce.impl.G;
import com.oxygenxml.webapp.ce.impl.r;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLStreamHandlerFactorySetter;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.plugin.UserActionRequiredException;
import ro.sync.ecss.extensions.api.webapp.plugin.UserContext;
import ro.sync.ecss.webapp.testing.MockAuthorDocumentFactory;
import ro.sync.servlet.collaboration.api.RoomExt;
import ro.sync.servlet.collaboration.api.RoomExtDecorator;
import ro.sync.servlet.collaboration.api.UpdateHappenedListener;

public class DebuggableRoom
extends RoomExtDecorator {
    private static final Logger log = LoggerFactory.getLogger(DebuggableRoom.class);
    private static final BiMap roomClassToId = HashBiMap.create((Map)ImmutableMap.of(G.class, (Object)1, r.class, (Object)2));

    public DebuggableRoom(RoomExt roomExt) {
        super(roomExt);
    }

    public static void main(String[] stringArray) {
        String string = DebuggableRoom.readRoomSerialization(stringArray);
        DebuggableRoom.initPrerequisites();
        DebuggableRoom debuggableRoom = DebuggableRoom.fromBase64Serialization(string);
        AuthorDocumentModel authorDocumentModel = debuggableRoom.getDelegate().createModel("authorName", new HashMap(), new UserContext(new HashMap(), "sessionId"));
        String string2 = CharStreams.toString((Readable)authorDocumentModel.createReader());
        log.info("Model XML: {}", (Object)string2);
    }

    public AuthorDocumentModel createModel(String string, Map map, UserContext userContext) {
        try {
            long l2 = System.currentTimeMillis();
            AuthorDocumentModel authorDocumentModel = this.room.createModel(string, map, userContext);
            long l3 = System.currentTimeMillis() - l2;
            if (l3 > 30000L) {
                this.logModelCreationTookToLong(l3);
            }
            return authorDocumentModel;
        }
        catch (UserActionRequiredException userActionRequiredException) {
            throw userActionRequiredException;
        }
        catch (Exception exception) {
            this.logFailedToCreateModel(exception);
            throw exception;
        }
    }

    public AuthorDocumentModel createMapModel(String string, Map map, UserContext userContext) {
        try {
            long l2 = System.currentTimeMillis();
            AuthorDocumentModel authorDocumentModel = this.room.createMapModel(string, map, userContext);
            long l3 = System.currentTimeMillis() - l2;
            if (l3 > 30000L) {
                this.logModelCreationTookToLong(l3);
            }
            return authorDocumentModel;
        }
        catch (UserActionRequiredException userActionRequiredException) {
            throw userActionRequiredException;
        }
        catch (Exception exception) {
            this.logFailedToCreateModel(exception);
            throw exception;
        }
    }

    public RoomExt getDelegate() {
        return this.room;
    }

    public String serializeRoomAsB64() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
            Integer n2 = (Integer)roomClassToId.get(this.room.getClass());
            if (n2 == null) {
                throw new IllegalStateException("Unexpected room class " + this.room.getClass());
            }
            objectOutputStream.writeInt(n2);
            this.room.writeExternal(objectOutputStream);
        }
        return Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
    }

    public static DebuggableRoom fromBase64Serialization(String string) {
        byte[] byArray = Base64.getDecoder().decode(string);
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));){
            C c2;
            Integer n2 = objectInputStream.readInt();
            Class clazz = (Class)roomClassToId.inverse().get((Object)n2);
            if (clazz == G.class) {
                c2 = new G(objectInputStream);
            } else if (clazz == r.class) {
                c2 = new r(objectInputStream);
            } else {
                throw new IllegalStateException("Unexpected room class " + clazz);
            }
            DebuggableRoom debuggableRoom = new DebuggableRoom(c2);
            return debuggableRoom;
        }
    }

    private static String readRoomSerialization(String[] stringArray) {
        if (stringArray.length == 0 || stringArray[0].isEmpty()) {
            throw new IllegalArgumentException("Missing room serialization file argument.");
        }
        String string = stringArray[0];
        byte[] byArray = Files.readAllBytes(new File(string).toPath());
        String string2 = new String(byArray, StandardCharsets.UTF_8);
        if (string2.isEmpty()) {
            throw new IllegalStateException("The room serialization file is empty.");
        }
        return string2;
    }

    private static void initPrerequisites() {
        URLStreamHandlerFactorySetter uRLStreamHandlerFactorySetter = new URLStreamHandlerFactorySetter();
        a a2 = new a();
        uRLStreamHandlerFactorySetter.setFactory(string -> a2);
        MockAuthorDocumentFactory.initForTest();
    }

    private void logModelCreationTookToLong(long l2) {
        try {
            String string = this.serializeRoomAsB64();
            log.error("Create model took {} millis. Doc URL {}. Git commit {}. Base64 room serialization: {}", new Object[]{l2, this.getDocumentUrl(), ConcurrentPlugin.getInstance().getRevision(), string});
        }
        catch (Exception exception) {
            log.error((Object)exception, (Throwable)exception);
        }
    }

    private String getDocumentUrl() {
        try {
            return this.room.getDocumentURL().toExternalForm();
        }
        catch (Throwable throwable) {
            return "<not-available: Exception - " + throwable.getMessage() + ">";
        }
    }

    private void logFailedToCreateModel(Exception exception) {
        try {
            String string = this.serializeRoomAsB64();
            log.error("Failed to create model because '{}'. Doc URL {}. Git commit {}. Base64 room serialization: {}", new Object[]{exception.getMessage(), this.getDocumentUrl(), ConcurrentPlugin.getInstance().getRevision(), string, exception});
        }
        catch (Exception exception2) {
            exception.addSuppressed(exception2);
        }
    }

    public void fireServerSideUpdateListeners(AuthorDocumentModel authorDocumentModel) {
        this.room.fireServerSideUpdateListeners(authorDocumentModel);
    }

    public void addServerSideUpdateHappenedListener(UpdateHappenedListener updateHappenedListener) {
        this.room.addServerSideUpdateHappenedListener(updateHappenedListener);
    }

    public void removeServerSideUpdateHappenedListener(UpdateHappenedListener updateHappenedListener) {
        this.room.removeServerSideUpdateHappenedListener(updateHappenedListener);
    }
}

