/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util.java;

import java.util.Arrays;
import java.util.Comparator;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.java.JavaVersionDetector;
import ro.sync.basic.util.java.JavaVersionParser;

public enum JavaVersion {
    V_1_8("1.8"),
    V_9("9"),
    V_10("10"),
    V_11("11"),
    V_12("12"),
    V_13("13"),
    V_14("14"),
    V_15("15"),
    V_16("16"),
    V_17("17"),
    V_24("24");

    private final int[] versionNumber;
    static final Comparator<int[]> JAVA_VERSION_COMPARATOR;

    private JavaVersion(String version) throws ExceptionInInitializerError {
        try {
            this.versionNumber = JavaVersionParser.parse(version);
        }
        catch (NumberFormatException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static boolean isCurrentVersion(JavaVersion javaVersion, boolean evenNewer) {
        boolean isCurrentOrNewer = false;
        try {
            int result = JAVA_VERSION_COMPARATOR.compare(JavaVersionDetector.getVersion(), javaVersion.versionNumber);
            isCurrentOrNewer = result == 0 || evenNewer && result > 0;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            isCurrentOrNewer = evenNewer;
        }
        return isCurrentOrNewer;
    }

    public boolean isCurrentVersionOrNewer() {
        return JavaVersion.isCurrentVersion(this, true);
    }

    static {
        JAVA_VERSION_COMPARATOR = new Comparator<int[]>(){

            private boolean isValidJavaVersion(int[] javaVersion) {
                boolean valid;
                boolean bl = valid = javaVersion != null && javaVersion.length > 0;
                if (valid) {
                    for (int i = 0; i < javaVersion.length && valid; ++i) {
                        valid = javaVersion[i] > 0 || i > 0 && javaVersion[i] == 0;
                    }
                }
                return valid;
            }

            @Override
            public int compare(int[] jv1, int[] jv2) {
                int i;
                if (!this.isValidJavaVersion(jv1)) {
                    throw new IllegalArgumentException("Invalid Java version: " + Arrays.toString(jv1));
                }
                if (!this.isValidJavaVersion(jv2)) {
                    throw new IllegalArgumentException("Invalid Java version: " + Arrays.toString(jv2));
                }
                if (jv1 == jv2) {
                    return 0;
                }
                for (i = 0; i < jv1.length && i < jv2.length; ++i) {
                    if (jv1[i] == jv2[i]) continue;
                    return jv1[i] - jv2[i];
                }
                if (i < jv1.length) {
                    while (i < jv1.length) {
                        if (jv1[i] > 0) {
                            return 1;
                        }
                        ++i;
                    }
                }
                if (i < jv2.length) {
                    while (i < jv2.length) {
                        if (jv2[i] > 0) {
                            return -1;
                        }
                        ++i;
                    }
                }
                return 0;
            }
        };
    }
}

