/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util.concurrent;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.concurrent.SemaphoreTimeoutException;

public class Semaphore {
    private static Logger logger = LoggerFactory.getLogger((String)Semaphore.class.getName());
    int counter;
    int maxCounter;

    public Semaphore() {
        this(0);
    }

    public Semaphore(int counter) {
        this.maxCounter = counter <= 0 ? 1 : counter;
        this.counter = counter;
    }

    public synchronized void aquire() throws InterruptedException {
        if (this.counter > 0) {
            --this.counter;
        } else {
            logger.debug("Waiting to aquire.", (Throwable)new Exception());
            while (this.counter <= 0) {
                this.wait();
            }
            --this.counter;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Decresed the counter to: " + this.counter);
        }
        logger.debug("Notifying from aquire.", (Throwable)new Exception());
        this.notify();
    }

    public synchronized void aquireWithTimeout(int mils) throws SemaphoreTimeoutException {
        if (this.counter > 0) {
            --this.counter;
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Waiting to aquire. Timout:" + mils, (Throwable)new Exception());
            }
            while (this.counter <= 0) {
                int lastState = this.counter;
                try {
                    this.wait(mils);
                }
                catch (InterruptedException ie) {
                    logger.warn(ie.getMessage(), (Throwable)ie);
                }
                if (lastState != this.counter) continue;
                throw new SemaphoreTimeoutException();
            }
            --this.counter;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this + "Decresed the counter to: " + this.counter);
        }
        logger.debug("Notifying from aquire.", (Throwable)new Exception());
        this.notify();
    }

    public synchronized void release() {
        if (logger.isDebugEnabled()) {
            logger.debug("Counter: " + this.counter + " MaxCounter: " + this.maxCounter);
        }
        while (this.counter == this.maxCounter) {
            try {
                logger.debug("Waiting for a consumer to take a product.", (Throwable)new Exception());
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ++this.counter;
        logger.debug("Notifying from release.", (Throwable)new Exception());
        this.notify();
    }
}

