/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import ro.sync.basic.io.IOUtil;

public class ClipboardInspector {
    public String dumpClipboard() {
        StringBuilder sb = new StringBuilder();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable tr = clipboard.getContents(null);
        DataFlavor[] flavors = tr.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            sb.append("============== FLAVOR: " + flavors[i].getMimeType() + "\n param: " + flavors[i].getParameter("document") + "\n subt: " + flavors[i].getSubType() + "\n prim: " + flavors[i].getPrimaryType() + "\n");
            sb.append(flavors[i]);
            sb.append("\n");
            try {
                Object transferData = tr.getTransferData(flavors[i]);
                sb.append("======== content class name: " + transferData.getClass().getName() + "\n");
                if (transferData instanceof Reader) {
                    StringBuilder contentReader = IOUtil.read((Reader)transferData);
                    sb.append("\n\n+++++++++++++++ READER:\n\n" + contentReader + "\n\n++++++++++++++++\n\n");
                }
                if (transferData instanceof InputStream) {
                    String str = new String(IOUtil.readBytes((InputStream)transferData), "UTF-8");
                    sb.append("\n\n+++++++++++++++ CONTENT:\n\n" + str + "\n\n++++++++++++++++\n\n");
                }
                sb.append("======== content:\n" + transferData + "\n");
            }
            catch (Exception e) {
                sb.append("======== ERROR when retrieving the content:\n");
                StringWriter writer = new StringWriter();
                e.printStackTrace(new PrintWriter(writer));
                sb.append(writer.toString());
                sb.append("\n\n");
            }
            sb.append("==============\n\n");
        }
        return sb.toString();
    }
}

