/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.html;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import ro.sync.basic.html.HTMLEntitiesRepository;

public class UnescapeHTMLEntitiesWriter
extends FilterWriter {
    private boolean ignore = false;
    private int ignoreLen = 0;
    private StringBuilder buf = new StringBuilder();

    public UnescapeHTMLEntitiesWriter(Writer out) {
        super(out);
    }

    @Override
    public void write(int c) throws IOException {
        if (c == 38) {
            this.ignore = true;
            this.ignoreLen = 0;
            this.buf.setLength(0);
        }
        if (this.ignore) {
            HTMLEntitiesRepository entitiesRepository = HTMLEntitiesRepository.getInstance();
            if (this.buf.length() == 0) {
                entitiesRepository.reset();
            }
            this.buf.append((char)c);
            int alternateChar = entitiesRepository.accepts((char)c, this.ignoreLen);
            switch (alternateChar) {
                case -1: {
                    this.out.write(this.buf.toString());
                    this.ignore = false;
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    char[] chars = Character.toChars(alternateChar);
                    for (int i = 0; i < chars.length; ++i) {
                        this.out.write(chars[i]);
                    }
                    this.ignore = false;
                    this.buf.setLength(0);
                }
            }
            ++this.ignoreLen;
        } else {
            this.out.write(c);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.write(cbuf[off + i]);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.write(str.toCharArray(), off, len);
    }
}

