/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.sdksamples.svg;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import com.google.common.net.MediaType;
import com.oxygenxml.sdksamples.svg.EditingSessionContextManager;
import com.oxygenxml.sdksamples.svg.PerDocumentSvgCache;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.access.EditingSessionContext;
import ro.sync.ecss.extensions.api.webapp.plugin.ServletPluginExtension;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.ServletException;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletRequest;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletResponse;

public class SvgServlet
extends ServletPluginExtension {
    public void doGet(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        if (this.isOpenedInBrowserTab(httpRequest)) {
            httpResponse.sendError(400, "Load SVG using an <img> tag.");
        } else {
            String docId = httpRequest.getParameter("docId");
            String elemId = httpRequest.getParameter("elemId");
            AuthorAccess authorAccess = EditingSessionContextManager.getDocument(docId);
            if (authorAccess != null) {
                EditingSessionContext editingContext = authorAccess.getEditorAccess().getEditingContext();
                PerDocumentSvgCache svgCache = (PerDocumentSvgCache)editingContext.getAttribute("com.oxygenxml.sdksamples.svg.cache");
                String xml = svgCache.getXmlFragment(Long.valueOf(elemId));
                httpResponse.setHeader("Cache-Control", "max-age=31536000");
                httpResponse.setHeader("Content-Type", MediaType.SVG_UTF_8.toString());
                httpResponse.setHeader("Vary", "Accept-Encoding");
                httpResponse.setHeader("Content-Security-Policy", "sandbox");
                ByteStreams.copy((InputStream)new ByteArrayInputStream(xml.getBytes(Charsets.UTF_8)), (OutputStream)httpResponse.getOutputStream());
            } else {
                httpResponse.sendError(404, "SVG file was not found.");
            }
        }
    }

    private boolean isOpenedInBrowserTab(HttpServletRequest httpRequest) {
        String accept = httpRequest.getHeader("Accept");
        return accept != null && accept.contains("text/html");
    }

    public String getPath() {
        return "svg";
    }
}

