/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.sdksamples.svg;

import com.oxygenxml.sdksamples.svg.EditingSessionContextManager;
import com.oxygenxml.sdksamples.svg.PerDocumentSvgCache;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.access.EditingSessionContext;
import ro.sync.ecss.extensions.api.editor.AuthorInplaceContext;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.webapp.formcontrols.WebappFormControlRenderer;

public class SvgRenderer
extends WebappFormControlRenderer {
    private static final Logger log = LoggerFactory.getLogger(SvgRenderer.class);

    public void renderControl(AuthorInplaceContext context, Writer out) throws IOException {
        AuthorElement svgElement = context.getElem();
        AuthorAccess authorAccess = context.getAuthorAccess();
        EditingSessionContextManager.ensureInitialized(authorAccess);
        EditingSessionContext editingContext = authorAccess.getEditorAccess().getEditingContext();
        PerDocumentSvgCache equationCache = (PerDocumentSvgCache)editingContext.getAttribute("com.oxygenxml.sdksamples.svg.cache");
        String docId = (String)editingContext.getAttribute("com.oxygenxml.sdksamples.svg.author_access_id");
        try {
            long elemId = equationCache.freezeSvgFrag(svgElement);
            String xmlSvgFrag = equationCache.getXmlFragment(elemId);
            String svgHash = DigestUtils.sha256Hex((String)xmlSvgFrag);
            out.append("<img class=\"svg-image\" src=\"../plugins-dispatcher/svg?xmlSvgFragHash=" + svgHash + "&elemId=" + elemId + "&docId=" + docId + "\"></img>");
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            out.append("<span style=\"color: red\">Error rendering SVG image</span>");
        }
    }

    public boolean isChangeTrackingAware() {
        return true;
    }

    public String getDescription() {
        return "Svg Form Control Renderer";
    }
}

