/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.sdksamples.svg;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import javax.swing.text.BadLocationException;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;

public class PerDocumentSvgCache {
    private static final String XMLNS_SVG_NAMESPACE = "xmlns:svg";
    private static final String XMLNS_NAMESPACE = "xmlns";
    private final AuthorDocumentController docController;
    private final Map<Long, String> svgElements = new HashMap<Long, String>(0);
    private long lastCompactedCacheSize = 4L;
    Map<AuthorElement, Long> nodeIndexer = new WeakHashMap<AuthorElement, Long>();
    private long counter = 0L;

    public PerDocumentSvgCache(AuthorDocumentController controller) {
        this.docController = controller;
    }

    public synchronized long freezeSvgFrag(AuthorElement elem) throws BadLocationException {
        long elemId = this.nodeIndexer.computeIfAbsent(elem, new Function<AuthorElement, Long>(){

            @Override
            public Long apply(AuthorElement t) {
                return PerDocumentSvgCache.this.counter++;
            }
        });
        AuthorDocumentFragment svgFrag = this.docController.createDocumentFragment((AuthorNode)elem, true);
        List contentNodes = svgFrag.getContentNodes();
        if (!contentNodes.isEmpty()) {
            String namespaceValue;
            AttrValue xmlnsSvg;
            AuthorElement copyElem;
            AuthorNode copyNode = (AuthorNode)contentNodes.get(0);
            if (copyNode instanceof AuthorElement) {
                copyElem = (AuthorElement)copyNode;
                xmlnsSvg = copyElem.getAttribute(XMLNS_SVG_NAMESPACE);
                if (xmlnsSvg == null || !xmlnsSvg.isSpecified()) {
                    xmlnsSvg = copyElem.getAttribute(XMLNS_NAMESPACE);
                }
                namespaceValue = null;
                namespaceValue = xmlnsSvg != null && !xmlnsSvg.isSpecified() ? xmlnsSvg.getValue() : "http://www.w3.org/2000/svg";
                copyElem.setAttribute(XMLNS_SVG_NAMESPACE, new AttrValue(namespaceValue));
            }
            if ((copyNode = (AuthorNode)contentNodes.get(0)) instanceof AuthorElement && (xmlnsSvg = (copyElem = (AuthorElement)copyNode).getAttribute(XMLNS_SVG_NAMESPACE)) != null && !xmlnsSvg.isSpecified()) {
                namespaceValue = xmlnsSvg.getValue();
                copyElem.setAttribute(XMLNS_SVG_NAMESPACE, new AttrValue(namespaceValue));
            }
        }
        String xml = this.docController.serializeFragmentToXML(svgFrag);
        this.svgElements.put(elemId, xml);
        if ((long)this.svgElements.size() > 2L * this.lastCompactedCacheSize) {
            this.compactCache();
        }
        return elemId;
    }

    private void compactCache() {
        HashSet<Long> valuesSet = new HashSet<Long>(this.nodeIndexer.values());
        this.svgElements.entrySet().removeIf(entry -> !valuesSet.contains(entry.getKey()));
        this.lastCompactedCacheSize = this.svgElements.size();
    }

    int getSize() {
        return this.svgElements.size();
    }

    public synchronized String getXmlFragment(long elemId) {
        return this.svgElements.get(elemId);
    }
}

