/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.sdksamples.svg;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.oxygenxml.sdksamples.svg.PerDocumentSvgCache;
import java.security.SecureRandom;
import org.apache.commons.codec.binary.Hex;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.access.EditingSessionContext;

public class EditingSessionContextManager {
    static final String AUTHOR_ACCESS_ID = "com.oxygenxml.sdksamples.svg.author_access_id";
    static final String SVG_CACHE = "com.oxygenxml.sdksamples.svg.cache";
    private static final SecureRandom random = new SecureRandom();
    private static final Cache<String, AuthorAccess> activeAuthorAccessCache = CacheBuilder.newBuilder().weakValues().build();

    public static void ensureInitialized(AuthorAccess authorAccess) {
        EditingSessionContext editingContext = authorAccess.getEditorAccess().getEditingContext();
        if (editingContext.getAttribute(AUTHOR_ACCESS_ID) == null) {
            String docId = EditingSessionContextManager.generateId();
            activeAuthorAccessCache.put((Object)docId, (Object)authorAccess);
            editingContext.setAttribute(AUTHOR_ACCESS_ID, (Object)docId);
            editingContext.setAttribute(SVG_CACHE, (Object)new PerDocumentSvgCache(authorAccess.getDocumentController()));
        }
    }

    private static String generateId() {
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        return Hex.encodeHexString((byte[])bytes);
    }

    public static AuthorAccess getDocument(String authorAccessId) {
        return (AuthorAccess)activeAuthorAccessCache.getIfPresent((Object)authorAccessId);
    }
}

