<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs" version="2.0">
    <xsl:param name="rootName">topicmeta</xsl:param>
    <xsl:param name="navtitle">navtitle</xsl:param>
    <xsl:output omit-xml-declaration="yes" indent="yes"/>

    <xsl:template match="@* | node()">
        <xsl:copy>
            <xsl:apply-templates select="@* | node()"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="*[name() = $rootName][count(child::*[name() = $navtitle]) = 0]">
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <xsl:element name="{$navtitle}"><xsl:text>$select("Insert navtitle text here")</xsl:text></xsl:element>
            <xsl:apply-templates select="node()"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="*[name() = $navtitle][1]">
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <xsl:text>$select("</xsl:text>
            <xsl:if test="not(node())">
                <xsl:text>Insert navtitle text here</xsl:text>
            </xsl:if>
            <xsl:apply-templates select="node()"/>
            <xsl:text>")</xsl:text>
        </xsl:copy>
    </xsl:template>
</xsl:stylesheet>
