JQuery.prototype = { 
 /**
  * Add elements to the set of matched elements.
  * 
  * @param selector A string representing a selector expression to find additional elements to add to the set of matched elements. This parameter is required.
  *
  * @return jQuery
  */
 add:function(selector){},

 /**
  * Add elements to the set of matched elements.
  * 
  * @param elements One or more elements to add to the set of matched elements. This parameter is required.
  *
  * @return jQuery
  */
 add__variant__oxygen__2:function(elements){},

 /**
  * Add elements to the set of matched elements.
  * 
  * @param html An HTML fragment to add to the set of matched elements. This parameter is required.
  *
  * @return jQuery
  */
 add__variant__oxygen__3:function(html){},

 /**
  * Add elements to the set of matched elements.
  * 
  * @param jQueryObject An existing jQuery object to add to the set of matched elements. This parameter is required.
  *
  * @return jQuery
  */
 add__variant__oxygen__4:function(jQueryObject){},

 /**
  * Add elements to the set of matched elements.
  * 
  * @param selector A string representing a selector expression to find additional elements to add to the set of matched elements. This parameter is required.
  * @param context The point in the document at which the selector should begin matching; similar to the context argument of the $(selector, context) method. This parameter is required.
  *
  * @return jQuery
  */
 add__variant__oxygen__5:function(selector, context){},

 /**
  * Adds the specified class(es) to each of the set of matched elements.
  * 
  * @param className One or more space-separated classes to be added to the class attribute of each matched element. This parameter is required.
  *
  * @return jQuery
  */
 addClass:function(className){},

 /**
  * Adds the specified class(es) to each of the set of matched elements.
  * 
  * @param func=function(index, currentClass) A function returning one or more space-separated class names to be added to the existing class name(s). Receives the index position of the element in the set and the existing class name(s) as arguments. Within the function, this refers to the current element in the set. This parameter is required.
  *
  * @return jQuery
  */
 addClass__variant__oxygen__2:function(func){},

 /**
  * Insert content, specified by the parameter, after each element in the set of matched elements.
  * 
  * @param content HTML string, DOM element, or jQuery object to insert after each element in the set of matched elements. This parameter is required.
  * @param content One or more additional DOM elements, arrays of elements, HTML strings, or jQuery objects to insert after each element in the set of matched elements. This parameter is optional.
  *
  * @return jQuery
  */
 after:function(content, content){},

 /**
  * Insert content, specified by the parameter, after each element in the set of matched elements.
  * 
  * @param func=function(index) A function that returns an HTML string, DOM element(s), or jQuery object to insert after each element in the set of matched elements. Receives the index position of the element in the set as an argument. Within the function, this refers to the current element in the set. This parameter is required.
  *
  * @return jQuery
  */
 after__variant__oxygen__2:function(func){},

 /**
  * Register a handler to be called when Ajax requests complete. This is an AjaxEvent.
  * 
  * @param handler=handler(event, XMLHttpRequest, ajaxOptions) The function to be invoked. This parameter is required.
  *
  * @return jQuery
  */
 ajaxComplete:function(handler){},

 /**
  * Register a handler to be called when Ajax requests complete with an error. This is an Ajax Event.
  * 
  * @param handler=handler(event, jqXHR, ajaxSettings, thrownError) The function to be invoked. This parameter is required.
  *
  * @return jQuery
  */
 ajaxError:function(handler){},

 /**
  * Attach a function to be executed before an Ajax request is sent. This is an Ajax Event.
  * 
  * @param handler=handler(event, jqXHR, ajaxOptions) The function to be invoked. This parameter is required.
  *
  * @return jQuery
  */
 ajaxSend:function(handler){},

 /**
  * Register a handler to be called when the first Ajax request begins. This is an Ajax Event.
  * 
  * @param handler=handler() The function to be invoked. This parameter is required.
  *
  * @return jQuery
  */
 ajaxStart:function(handler){},

 /**
  * Register a handler to be called when all Ajax requests have completed. This is an Ajax Event.
  * 
  * @param handler=handler() The function to be invoked. This parameter is required.
  *
  * @return jQuery
  */
 ajaxStop:function(handler){},

 /**
  * Attach a function to be executed whenever an Ajax request completes successfully. This is an Ajax Event.
  * 
  * @param handler=handler(event, XMLHttpRequest, ajaxOptions) The function to be invoked. This parameter is required.
  *
  * @return jQuery
  */
 ajaxSuccess:function(handler){},

 /**
  * Add the previous set of elements on the stack to the current set.
  *
  * @return jQuery
  */
 andSelf:function(){},

 /**
  * Perform a custom animation of a set of CSS properties.
  * 
  * @param properties An object of CSS properties and values that the animation will move toward. This parameter is required.
  * @param duration A string or number determining how long the animation will run. This parameter is optional.
  * @param easing A string indicating which easing function to use for the transition. This parameter is optional.
  * @param complete A function to call once the animation is complete. This parameter is optional.
  *
  * @return jQuery
  */
 animate:function(properties, duration, easing, complete){},

 /**
  * Perform a custom animation of a set of CSS properties.
  * 
  * @param properties An object of CSS properties and values that the animation will move toward. This parameter is required.
  * @param options A map of additional options to pass to the method. This parameter is required.
  *
  * @return jQuery
  */
 animate__variant__oxygen__2:function(properties, options){},

 /**
  * Insert content, specified by the parameter, to the end of each element in the set of matched elements.
  * 
  * @param content DOM element, HTML string, or jQuery object to insert at the end of each element in the set of matched elements. This parameter is required.
  * @param content One or more additional DOM elements, arrays of elements, HTML strings, or jQuery objects to insert at the end of each element in the set of matched elements. This parameter is optional.
  *
  * @return jQuery
  */
 append:function(content, content){},

 /**
  * Insert content, specified by the parameter, to the end of each element in the set of matched elements.
  * 
  * @param func=function(index, html) A function that returns an HTML string, DOM element(s), or jQuery object to insert at the end of each element in the set of matched elements. Receives the index position of the element in the set and the old HTML value of the element as arguments. Within the function, this refers to the current element in the set. This parameter is required.
  *
  * @return jQuery
  */
 append__variant__oxygen__2:function(func){},

 /**
  * Insert every element in the set of matched elements to the end of the target.
  * 
  * @param target A selector, element, HTML string, or jQuery object; the matched set of elements will be inserted at the end of the element(s) specified by this parameter. This parameter is required.
  *
  * @return jQuery
  */
 appendTo:function(target){},

 /**
  * Get the value of an attribute for the first element in the set of matched elements.
  * 
  * @param attributeName The name of the attribute to get. This parameter is required.
  *
  * @return String
  */
 attr:function(attributeName){},

 /**
  * Set one or more attributes for the set of matched elements.
  * 
  * @param attributeName The name of the attribute to set. This parameter is required.
  * @param value A value to set for the attribute. This parameter is required.
  *
  * @return jQuery
  */
 attr__variant__oxygen__2:function(attributeName, value){},

 /**
  * Set one or more attributes for the set of matched elements.
  * 
  * @param attributes An object of attribute-value pairs to set. This parameter is required.
  *
  * @return jQuery
  */
 attr__variant__oxygen__3:function(attributes){},

 /**
  * Set one or more attributes for the set of matched elements.
  * 
  * @param attributeName The name of the attribute to set. This parameter is required.
  * @param func=function(index, attr) A function returning the value to set. this is the current element. Receives the index position of the element in the set and the old attribute value as arguments. This parameter is required.
  *
  * @return jQuery
  */
 attr__variant__oxygen__4:function(attributeName, func){},

 /**
  * Insert content, specified by the parameter, before each element in the set of matched elements.
  * 
  * @param content HTML string, DOM element, or jQuery object to insert before each element in the set of matched elements. This parameter is required.
  * @param content One or more additional DOM elements, arrays of elements, HTML strings, or jQuery objects to insert before each element in the set of matched elements. This parameter is optional.
  *
  * @return jQuery
  */
 before:function(content, content){},

 /**
  * Insert content, specified by the parameter, before each element in the set of matched elements.
  * 
  * @param function A function that returns an HTML string, DOM element(s), or jQuery object to insert before each element in the set of matched elements. Receives the index position of the element in the set as an argument. Within the function, this refers to the current element in the set. This parameter is required.
  *
  * @return jQuery
  */
 before__variant__oxygen__2:function(func){},

 /**
  * Attach a handler to an event for the elements.
  * 
  * @param eventType A string containing one or more DOM event types, such as "click" or "submit," or custom event names. This parameter is required.
  * @param eventData An object containing data that will be passed to the event handler. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 bind:function(eventType, eventData, handler){},

 /**
  * Attach a handler to an event for the elements.
  * 
  * @param eventType A string containing one or more DOM event types, such as "click" or "submit," or custom event names. This parameter is required.
  * @param eventData An object containing data that will be passed to the event handler. This parameter is optional.
  * @param preventBubble Setting the third argument to false will attach a function that prevents the default action from occurring and stops the event from bubbling. The default is true. This parameter is required.
  *
  * @return jQuery
  */
 bind__variant__oxygen__2:function(eventType, eventData, preventBubble){},

 /**
  * Attach a handler to an event for the elements.
  * 
  * @param events An object containing one or more DOM event types and functions to execute for them. This parameter is required.
  *
  * @return jQuery
  */
 bind__variant__oxygen__3:function(events){},

 /**
  * Bind an event handler to the "blur" JavaScript event, or trigger that event on an element.
  * 
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 blur:function(handler){},

 /**
  * Bind an event handler to the "blur" JavaScript event, or trigger that event on an element.
  * 
  * @param eventData An object containing data that will be passed to the event handler. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 blur__variant__oxygen__2:function(eventData, handler){},

 /**
  * Bind an event handler to the "blur" JavaScript event, or trigger that event on an element.
  *
  * @return jQuery
  */
 blur__variant__oxygen__3:function(){},

 /**
  * Bind an event handler to the "change" JavaScript event, or trigger that event on an element.
  * 
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 change:function(handler){},

 /**
  * Bind an event handler to the "change" JavaScript event, or trigger that event on an element.
  * 
  * @param eventData An object containing data that will be passed to the event handler. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 change__variant__oxygen__2:function(eventData, handler){},

 /**
  * Bind an event handler to the "change" JavaScript event, or trigger that event on an element.
  *
  * @return jQuery
  */
 change__variant__oxygen__3:function(){},

 /**
  * Get the children of each element in the set of matched elements, optionally filtered by a selector.
  * 
  * @param selector A string containing a selector expression to match elements against. This parameter is optional.
  *
  * @return jQuery
  */
 children:function(selector){},

 /**
  * Remove from the queue all items that have not yet been run.
  * 
  * @param queueName A string containing the name of the queue. Defaults to fx, the standard effects queue. This parameter is optional.
  *
  * @return jQuery
  */
 clearQueue:function(queueName){},

 /**
  * Bind an event handler to the "click" JavaScript event, or trigger that event on an element.
  * 
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 click:function(handler){},

 /**
  * Bind an event handler to the "click" JavaScript event, or trigger that event on an element.
  * 
  * @param eventData An object containing data that will be passed to the event handler. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 click__variant__oxygen__2:function(eventData, handler){},

 /**
  * Bind an event handler to the "click" JavaScript event, or trigger that event on an element.
  *
  * @return jQuery
  */
 click__variant__oxygen__3:function(){},

 /**
  * Create a deep copy of the set of matched elements.
  * 
  * @param withDataAndEvents A Boolean indicating whether event handlers should be copied along with the elements. As of jQuery 1.4, element data will be copied as well. This parameter is optional.
  *
  * @return jQuery
  */
 clone:function(withDataAndEvents){},

 /**
  * Create a deep copy of the set of matched elements.
  * 
  * @param withDataAndEvents A Boolean indicating whether event handlers and data should be copied along with the elements. The default value is false. *In jQuery 1.5.0 the default value was incorrectly true; it was changed back to false in 1.5.1 and up. This parameter is optional.
  * @param deepWithDataAndEvents A Boolean indicating whether event handlers and data for all children of the cloned element should be copied. By default its value matches the first argument's value (which defaults to false). This parameter is optional.
  *
  * @return jQuery
  */
 clone__variant__oxygen__2:function(withDataAndEvents, deepWithDataAndEvents){},

 /**
  * For each element in the set, get the first element that matches the selector by testing the element itself and traversing up through its ancestors in the DOM tree.
  * 
  * @param selector A string containing a selector expression to match elements against. This parameter is required.
  *
  * @return jQuery
  */
 closest:function(selector){},

 /**
  * For each element in the set, get the first element that matches the selector by testing the element itself and traversing up through its ancestors in the DOM tree.
  * 
  * @param selector A string containing a selector expression to match elements against. This parameter is required.
  * @param context A DOM element within which a matching element may be found. If no context is passed in then the context of the jQuery set will be used instead. This parameter is optional.
  *
  * @return jQuery
  */
 closest__variant__oxygen__2:function(selector, context){},

 /**
  * For each element in the set, get the first element that matches the selector by testing the element itself and traversing up through its ancestors in the DOM tree.
  * 
  * @param jQueryObject A jQuery object to match elements against. This parameter is required.
  *
  * @return jQuery
  */
 closest__variant__oxygen__3:function(jQueryObject){},

 /**
  * For each element in the set, get the first element that matches the selector by testing the element itself and traversing up through its ancestors in the DOM tree.
  * 
  * @param element An element to match elements against. This parameter is required.
  *
  * @return jQuery
  */
 closest__variant__oxygen__4:function(element){},

 /**
  * Get an array of all the elements and selectors matched against the current element up through the DOM tree.
  * 
  * @param selectors An array or string containing a selector expression to match elements against (can also be a jQuery object). This parameter is required.
  * @param context A DOM element within which a matching element may be found. If no context is passed in then the context of the jQuery set will be used instead. This parameter is optional.
  *
  * @return Array
  */
 closest__variant__oxygen__5:function(selectors, context){},

 /**
  * Get the children of each element in the set of matched elements, including text and comment nodes.
  *
  * @return jQuery
  */
 contents:function(){},

 /**
  * Get the value of style properties for the first element in the set of matched elements.
  * 
  * @param propertyName A CSS property. This parameter is required.
  *
  * @return String
  */
 css:function(propertyName){},

 /**
  * Get the value of style properties for the first element in the set of matched elements.
  * 
  * @param propertyNames An array of one or more CSS properties. This parameter is required.
  *
  * @return String
  */
 css__variant__oxygen__2:function(propertyNames){},

 /**
  * Set one or more CSS properties for the set of matched elements.
  * 
  * @param propertyName A CSS property name. This parameter is required.
  * @param value A value to set for the property. This parameter is required.
  *
  * @return jQuery
  */
 css__variant__oxygen__3:function(propertyName, value){},

 /**
  * Set one or more CSS properties for the set of matched elements.
  * 
  * @param propertyName A CSS property name. This parameter is required.
  * @param func=function(index, value) A function returning the value to set. this is the current element. Receives the index position of the element in the set and the old value as arguments. This parameter is required.
  *
  * @return jQuery
  */
 css__variant__oxygen__4:function(propertyName, func){},

 /**
  * Set one or more CSS properties for the set of matched elements.
  * 
  * @param properties An object of property-value pairs to set. This parameter is required.
  *
  * @return jQuery
  */
 css__variant__oxygen__5:function(properties){},

 /**
  * Store arbitrary data associated with the matched elements.
  * 
  * @param key A string naming the piece of data to set. This parameter is required.
  * @param value The new data value; it can be any Javascript type including Array or Object. This parameter is required.
  *
  * @return jQuery
  */
 data:function(key, value){},

 /**
  * Store arbitrary data associated with the matched elements.
  * 
  * @param obj An object of key-value pairs of data to update. This parameter is required.
  *
  * @return jQuery
  */
 data__variant__oxygen__2:function(obj){},

 /**
  * Return the value at the named data store for the first element in the jQuery collection, as set by data(name, value) or by an HTML5 data-* attribute.
  * 
  * @param key Name of the data stored. This parameter is required.
  *
  * @return Object
  */
 data__variant__oxygen__3:function(key){},

 /**
  * Return the value at the named data store for the first element in the jQuery collection, as set by data(name, value) or by an HTML5 data-* attribute.
  *
  * @return Object
  */
 data__variant__oxygen__4:function(){},

 /**
  * Bind an event handler to the "dblclick" JavaScript event, or trigger that event on an element.
  * 
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 dblclick:function(handler){},

 /**
  * Bind an event handler to the "dblclick" JavaScript event, or trigger that event on an element.
  * 
  * @param eventData An object containing data that will be passed to the event handler. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 dblclick__variant__oxygen__2:function(eventData, handler){},

 /**
  * Bind an event handler to the "dblclick" JavaScript event, or trigger that event on an element.
  *
  * @return jQuery
  */
 dblclick__variant__oxygen__3:function(){},

 /**
  * Set a timer to delay execution of subsequent items in the queue.
  * 
  * @param duration An integer indicating the number of milliseconds to delay execution of the next item in the queue. This parameter is required.
  * @param queueName A string containing the name of the queue. Defaults to fx, the standard effects queue. This parameter is optional.
  *
  * @return jQuery
  */
 delay:function(duration, queueName){},

 /**
  * Attach a handler to one or more events for all elements that match the selector, now or in the future, based on a specific set of root elements.
  * 
  * @param selector A selector to filter the elements that trigger the event. This parameter is required.
  * @param eventType A string containing one or more space-separated JavaScript event types, such as "click" or "keydown," or custom event names. This parameter is required.
  * @param handler=handler(eventObject) A function to execute at the time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 delegate:function(selector, eventType, handler){},

 /**
  * Attach a handler to one or more events for all elements that match the selector, now or in the future, based on a specific set of root elements.
  * 
  * @param selector A selector to filter the elements that trigger the event. This parameter is required.
  * @param eventType A string containing one or more space-separated JavaScript event types, such as "click" or "keydown," or custom event names. This parameter is required.
  * @param eventData An object containing data that will be passed to the event handler. This parameter is required.
  * @param handler=handler(eventObject) A function to execute at the time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 delegate__variant__oxygen__2:function(selector, eventType, eventData, handler){},

 /**
  * Attach a handler to one or more events for all elements that match the selector, now or in the future, based on a specific set of root elements.
  * 
  * @param selector A selector to filter the elements that trigger the event. This parameter is required.
  * @param events A plain object of one or more event types and functions to execute for them. This parameter is required.
  *
  * @return jQuery
  */
 delegate__variant__oxygen__3:function(selector, events){},

 /**
  * Execute the next function on the queue for the matched elements.
  * 
  * @param queueName A string containing the name of the queue. Defaults to fx, the standard effects queue. This parameter is optional.
  *
  * @return jQuery
  */
 dequeue:function(queueName){},

 /**
  * Remove the set of matched elements from the DOM.
  * 
  * @param selector A selector expression that filters the set of matched elements to be removed. This parameter is optional.
  *
  * @return jQuery
  */
 detach:function(selector){},

 /**
  * Remove event handlers previously attached using .live() from the elements.
  *
  * @return jQuery
  */
 die:function(){},

 /**
  * Remove event handlers previously attached using .live() from the elements.
  * 
  * @param eventType A string containing a JavaScript event type, such as click or keydown. This parameter is required.
  * @param handler The function that is no longer to be executed. This parameter is optional.
  *
  * @return jQuery
  */
 die__variant__oxygen__2:function(eventType, handler){},

 /**
  * Remove event handlers previously attached using .live() from the elements.
  * 
  * @param events A plain object of one or more event types, such as click or keydown and their corresponding functions that are no longer to be executed. This parameter is required.
  *
  * @return jQuery
  */
 die__variant__oxygen__3:function(events){},

 /**
  * Iterate over a jQuery object, executing a function for each matched element.
  * 
  * @param func=function(index, Element) A function to execute for each matched element. This parameter is required.
  *
  * @return jQuery
  */
 each:function(func){},

 /**
  * Remove all child nodes of the set of matched elements from the DOM.
  *
  * @return jQuery
  */
 empty:function(){},

 /**
  * End the most recent filtering operation in the current chain and return the set of matched elements to its previous state.
  *
  * @return jQuery
  */
 end:function(){},

 /**
  * Reduce the set of matched elements to the one at the specified index.
  * 
  * @param index An integer indicating the 0-based position of the element. This parameter is required.
  *
  * @return jQuery
  */
 eq:function(index){},

 /**
  * Reduce the set of matched elements to the one at the specified index.
  * 
  * @param -index An integer indicating the position of the element, counting backwards from the last element in the set. This parameter is required.
  *
  * @return jQuery
  */
 eq__variant__oxygen__2:function(index){},

 /**
  * Bind an event handler to the "error" JavaScript event.
  * 
  * @param handler=handler(eventObject) A function to execute when the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 error:function(handler){},

 /**
  * Bind an event handler to the "error" JavaScript event.
  * 
  * @param eventData An object containing data that will be passed to the event handler. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 error__variant__oxygen__2:function(eventData, handler){},

 /**
  * Display the matched elements by fading them to opaque.
  * 
  * @param duration A string or number determining how long the animation will run. This parameter is optional.
  * @param complete A function to call once the animation is complete. This parameter is optional.
  *
  * @return jQuery
  */
 fadeIn:function(duration, complete){},

 /**
  * Display the matched elements by fading them to opaque.
  * 
  * @param options A map of additional options to pass to the method. This parameter is required.
  *
  * @return jQuery
  */
 fadeIn__variant__oxygen__2:function(options){},

 /**
  * Display the matched elements by fading them to opaque.
  * 
  * @param duration A string or number determining how long the animation will run. This parameter is optional.
  * @param easing A string indicating which easing function to use for the transition. This parameter is optional.
  * @param complete A function to call once the animation is complete. This parameter is optional.
  *
  * @return jQuery
  */
 fadeIn__variant__oxygen__3:function(duration, easing, complete){},

 /**
  * Hide the matched elements by fading them to transparent.
  * 
  * @param duration A string or number determining how long the animation will run. This parameter is optional.
  * @param complete A function to call once the animation is complete. This parameter is optional.
  *
  * @return jQuery
  */
 fadeOut:function(duration, complete){},

 /**
  * Hide the matched elements by fading them to transparent.
  * 
  * @param options A map of additional options to pass to the method. This parameter is required.
  *
  * @return jQuery
  */
 fadeOut__variant__oxygen__2:function(options){},

 /**
  * Hide the matched elements by fading them to transparent.
  * 
  * @param duration A string or number determining how long the animation will run. This parameter is optional.
  * @param easing A string indicating which easing function to use for the transition. This parameter is optional.
  * @param complete A function to call once the animation is complete. This parameter is optional.
  *
  * @return jQuery
  */
 fadeOut__variant__oxygen__3:function(duration, easing, complete){},

 /**
  * Adjust the opacity of the matched elements.
  * 
  * @param duration A string or number determining how long the animation will run. This parameter is required.
  * @param opacity A number between 0 and 1 denoting the target opacity. This parameter is required.
  * @param complete A function to call once the animation is complete. This parameter is optional.
  *
  * @return jQuery
  */
 fadeTo:function(duration, opacity, complete){},

 /**
  * Adjust the opacity of the matched elements.
  * 
  * @param duration A string or number determining how long the animation will run. This parameter is required.
  * @param opacity A number between 0 and 1 denoting the target opacity. This parameter is required.
  * @param easing A string indicating which easing function to use for the transition. This parameter is optional.
  * @param complete A function to call once the animation is complete. This parameter is optional.
  *
  * @return jQuery
  */
 fadeTo__variant__oxygen__2:function(duration, opacity, easing, complete){},

 /**
  * Display or hide the matched elements by animating their opacity.
  * 
  * @param duration A string or number determining how long the animation will run. This parameter is optional.
  * @param easing A string indicating which easing function to use for the transition. This parameter is optional.
  * @param complete A function to call once the animation is complete. This parameter is optional.
  *
  * @return jQuery
  */
 fadeToggle:function(duration, easing, complete){},

 /**
  * Display or hide the matched elements by animating their opacity.
  * 
  * @param options A map of additional options to pass to the method. This parameter is required.
  *
  * @return jQuery
  */
 fadeToggle__variant__oxygen__2:function(options){},

 /**
  * Reduce the set of matched elements to those that match the selector or pass the function's test.
  * 
  * @param selector A string containing a selector expression to match the current set of elements against. This parameter is required.
  *
  * @return jQuery
  */
 filter:function(selector){},

 /**
  * Reduce the set of matched elements to those that match the selector or pass the function's test.
  * 
  * @param func=function(index) A function used as a test for each element in the set. this is the current DOM element. This parameter is required.
  *
  * @return jQuery
  */
 filter__variant__oxygen__2:function(func){},

 /**
  * Reduce the set of matched elements to those that match the selector or pass the function's test.
  * 
  * @param element An element to match the current set of elements against. This parameter is required.
  *
  * @return jQuery
  */
 filter__variant__oxygen__3:function(element){},

 /**
  * Reduce the set of matched elements to those that match the selector or pass the function's test.
  * 
  * @param jQueryObject An existing jQuery object to match the current set of elements against. This parameter is required.
  *
  * @return jQuery
  */
 filter__variant__oxygen__4:function(jQueryObject){},

 /**
  * Get the descendants of each element in the current set of matched elements, filtered by a selector, jQuery object, or element.
  * 
  * @param selector A string containing a selector expression to match elements against. This parameter is required.
  *
  * @return jQuery
  */
 find:function(selector){},

 /**
  * Get the descendants of each element in the current set of matched elements, filtered by a selector, jQuery object, or element.
  * 
  * @param jQueryObject A jQuery object to match elements against. This parameter is required.
  *
  * @return jQuery
  */
 find__variant__oxygen__2:function(jQueryObject){},

 /**
  * Get the descendants of each element in the current set of matched elements, filtered by a selector, jQuery object, or element.
  * 
  * @param element An element to match elements against. This parameter is required.
  *
  * @return jQuery
  */
 find__variant__oxygen__3:function(element){},

 /**
  * Reduce the set of matched elements to the first in the set.
  *
  * @return jQuery
  */
 first:function(){},

 /**
  * Bind an event handler to the "focus" JavaScript event, or trigger that event on an element.
  * 
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 focus:function(handler){},

 /**
  * Bind an event handler to the "focus" JavaScript event, or trigger that event on an element.
  * 
  * @param eventData An object containing data that will be passed to the event handler. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 focus__variant__oxygen__2:function(eventData, handler){},

 /**
  * Bind an event handler to the "focus" JavaScript event, or trigger that event on an element.
  *
  * @return jQuery
  */
 focus__variant__oxygen__3:function(){},

 /**
  * Bind an event handler to the "focusin" event.
  * 
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 focusin:function(handler){},

 /**
  * Bind an event handler to the "focusin" event.
  * 
  * @param eventData An object containing data that will be passed to the event handler. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 focusin__variant__oxygen__2:function(eventData, handler){},

 /**
  * Bind an event handler to the "focusout" JavaScript event.
  * 
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 focusout:function(handler){},

 /**
  * Bind an event handler to the "focusout" JavaScript event.
  * 
  * @param eventData An object containing data that will be passed to the event handler. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 focusout__variant__oxygen__2:function(eventData, handler){},

 /**
  * Retrieve the DOM elements matched by the jQuery object.
  * 
  * @param index A zero-based integer indicating which element to retrieve. This parameter is optional.
  *
  * @return Element, Array
  */
 get:function(index){},

 /**
  * Reduce the set of matched elements to those that have a descendant that matches the selector or DOM element.
  * 
  * @param selector A string containing a selector expression to match elements against. This parameter is required.
  *
  * @return jQuery
  */
 has:function(selector){},

 /**
  * Reduce the set of matched elements to those that have a descendant that matches the selector or DOM element.
  * 
  * @param contained A DOM element to match elements against. This parameter is required.
  *
  * @return jQuery
  */
 has__variant__oxygen__2:function(contained){},

 /**
  * Determine whether any of the matched elements are assigned the given class.
  * 
  * @param className The class name to search for. This parameter is required.
  *
  * @return Boolean
  */
 hasClass:function(className){},

 /**
  * Get the current computed height for the first element in the set of matched elements.
  *
  * @return Integer
  */
 height:function(){},

 /**
  * Set the CSS height of every matched element.
  * 
  * @param value An integer representing the number of pixels, or an integer with an optional unit of measure appended (as a string). This parameter is required.
  *
  * @return jQuery
  */
 height__variant__oxygen__2:function(value){},

 /**
  * Set the CSS height of every matched element.
  * 
  * @param func=function(index, height) A function returning the height to set. Receives the index position of the element in the set and the old height as arguments. Within the function, this refers to the current element in the set. This parameter is required.
  *
  * @return jQuery
  */
 height__variant__oxygen__3:function(func){},

 /**
  * Hide the matched elements.
  *
  * @return jQuery
  */
 hide:function(){},

 /**
  * Hide the matched elements.
  * 
  * @param duration A string or number determining how long the animation will run. This parameter is optional.
  * @param complete A function to call once the animation is complete. This parameter is optional.
  *
  * @return jQuery
  */
 hide__variant__oxygen__2:function(duration, complete){},

 /**
  * Hide the matched elements.
  * 
  * @param options A map of additional options to pass to the method. This parameter is required.
  *
  * @return jQuery
  */
 hide__variant__oxygen__3:function(options){},

 /**
  * Hide the matched elements.
  * 
  * @param duration A string or number determining how long the animation will run. This parameter is required.
  * @param easing A string indicating which easing function to use for the transition. This parameter is optional.
  * @param complete A function to call once the animation is complete. This parameter is optional.
  *
  * @return jQuery
  */
 hide__variant__oxygen__4:function(duration, easing, complete){},

 /**
  * Bind two handlers to the matched elements, to be executed when the mouse pointer enters and leaves the elements.
  * 
  * @param handler=handlerIn(eventObject) A function to execute when the mouse pointer enters the element. This parameter is required.
  * @param handler=handlerOut(eventObject) A function to execute when the mouse pointer leaves the element. This parameter is required.
  *
  * @return jQuery
  */
 hover:function(handler, handler){},

 /**
  * Bind a single handler to the matched elements, to be executed when the mouse pointer enters or leaves the elements.
  * 
  * @param handler=handlerInOut(eventObject) A function to execute when the mouse pointer enters or leaves the element. This parameter is required.
  *
  * @return jQuery
  */
 hover__variant__oxygen__2:function(handler){},

 /**
  * Get the HTML contents of the first element in the set of matched elements.
  *
  * @return String
  */
 html:function(){},

 /**
  * Set the HTML contents of each element in the set of matched elements.
  * 
  * @param htmlString A string of HTML to set as the content of each matched element. This parameter is required.
  *
  * @return jQuery
  */
 html__variant__oxygen__2:function(htmlString){},

 /**
  * Set the HTML contents of each element in the set of matched elements.
  * 
  * @param func=function(index, oldhtml) A function returning the HTML content to set. Receives the index position of the element in the set and the old HTML value as arguments. jQuery empties the element before calling the function; use the oldhtml argument to reference the previous content. Within the function, this refers to the current element in the set. This parameter is required.
  *
  * @return jQuery
  */
 html__variant__oxygen__3:function(func){},

 /**
  * Search for a given element from among the matched elements.
  *
  * @return Number
  */
 index:function(){},

 /**
  * Search for a given element from among the matched elements.
  * 
  * @param selector A selector representing a jQuery collection in which to look for an element. This parameter is required.
  *
  * @return Number
  */
 index__variant__oxygen__2:function(selector){},

 /**
  * Search for a given element from among the matched elements.
  * 
  * @param element The DOM element or first element within the jQuery object to look for. This parameter is required.
  *
  * @return Number
  */
 index__variant__oxygen__3:function(element){},

 /**
  * Get the current computed height for the first element in the set of matched elements, including padding but not border.
  *
  * @return Integer
  */
 innerHeight:function(){},

 /**
  * Get the current computed width for the first element in the set of matched elements, including padding but not border.
  *
  * @return Integer
  */
 innerWidth:function(){},

 /**
  * Insert every element in the set of matched elements after the target.
  * 
  * @param target A selector, element, HTML string, or jQuery object; the matched set of elements will be inserted after the element(s) specified by this parameter. This parameter is required.
  *
  * @return jQuery
  */
 insertAfter:function(target){},

 /**
  * Insert every element in the set of matched elements before the target.
  * 
  * @param target A selector, element, HTML string, or jQuery object; the matched set of elements will be inserted before the element(s) specified by this parameter. This parameter is required.
  *
  * @return jQuery
  */
 insertBefore:function(target){},

 /**
  * Check the current matched set of elements against a selector, element, or jQuery object and return true if at least one of these elements matches the given arguments.
  * 
  * @param selector A string containing a selector expression to match elements against. This parameter is required.
  *
  * @return Boolean
  */
 is:function(selector){},

 /**
  * Check the current matched set of elements against a selector, element, or jQuery object and return true if at least one of these elements matches the given arguments.
  * 
  * @param func=function(index) A function used as a test for the set of elements. It accepts one argument, index, which is the element's index in the jQuery collection.Within the function, this refers to the current DOM element. This parameter is required.
  *
  * @return Boolean
  */
 is__variant__oxygen__2:function(func){},

 /**
  * Check the current matched set of elements against a selector, element, or jQuery object and return true if at least one of these elements matches the given arguments.
  * 
  * @param jQueryObject An existing jQuery object to match the current set of elements against. This parameter is required.
  *
  * @return Boolean
  */
 is__variant__oxygen__3:function(jQueryObject){},

 /**
  * Check the current matched set of elements against a selector, element, or jQuery object and return true if at least one of these elements matches the given arguments.
  * 
  * @param element An element to match the current set of elements against. This parameter is required.
  *
  * @return Boolean
  */
 is__variant__oxygen__4:function(element){},

 /**
  * Accepts a string containing a CSS selector which is then used to match a set of elements.
  * 
  * @param selector A string containing a selector expression This parameter is required.
  * @param context A DOM Element, Document, or jQuery to use as context This parameter is optional.
  *
  * @return jQuery
  */
 jQuery:function(selector, context){},

 /**
  * Accepts a string containing a CSS selector which is then used to match a set of elements.
  * 
  * @param element A DOM element to wrap in a jQuery object. This parameter is required.
  *
  * @return jQuery
  */
 jQuery__variant__oxygen__2:function(element){},

 /**
  * Accepts a string containing a CSS selector which is then used to match a set of elements.
  * 
  * @param elementArray An array containing a set of DOM elements to wrap in a jQuery object. This parameter is required.
  *
  * @return jQuery
  */
 jQuery__variant__oxygen__3:function(elementArray){},

 /**
  * Accepts a string containing a CSS selector which is then used to match a set of elements.
  * 
  * @param object A plain object to wrap in a jQuery object. This parameter is required.
  *
  * @return jQuery
  */
 jQuery__variant__oxygen__4:function(object){},

 /**
  * Accepts a string containing a CSS selector which is then used to match a set of elements.
  * 
  * @param jQueryObject An existing jQuery object to clone. This parameter is required.
  *
  * @return jQuery
  */
 jQuery__variant__oxygen__5:function(jQueryObject){},

 /**
  * Accepts a string containing a CSS selector which is then used to match a set of elements.
  *
  * @return jQuery
  */
 jQuery__variant__oxygen__6:function(){},

 /**
  * Creates DOM elements on the fly from the provided string of raw HTML.
  * 
  * @param html A string of HTML to create on the fly. Note that this parses HTML, not XML. This parameter is required.
  * @param ownerDocument A document in which the new elements will be created This parameter is optional.
  *
  * @return jQuery
  */
 jQuery__variant__oxygen__7:function(html, ownerDocument){},

 /**
  * Creates DOM elements on the fly from the provided string of raw HTML.
  * 
  * @param html A string defining a single, standalone, HTML element (e.g. <div/> or <div></div>). This parameter is required.
  * @param attributes An object of attributes, events, and methods to call on the newly-created element. This parameter is required.
  *
  * @return jQuery
  */
 jQuery__variant__oxygen__8:function(html, attributes){},

 /**
  * Binds a function to be executed when the DOM has finished loading.
  * 
  * @param callback The function to execute when the DOM is ready. This parameter is required.
  *
  * @return jQuery
  */
 jQuery__variant__oxygen__9:function(callback){},

 /**
  * Bind an event handler to the "keydown" JavaScript event, or trigger that event on an element.
  * 
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 keydown:function(handler){},

 /**
  * Bind an event handler to the "keydown" JavaScript event, or trigger that event on an element.
  * 
  * @param eventData An object containing data that will be passed to the event handler. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 keydown__variant__oxygen__2:function(eventData, handler){},

 /**
  * Bind an event handler to the "keydown" JavaScript event, or trigger that event on an element.
  *
  * @return jQuery
  */
 keydown__variant__oxygen__3:function(){},

 /**
  * Bind an event handler to the "keypress" JavaScript event, or trigger that event on an element.
  * 
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 keypress:function(handler){},

 /**
  * Bind an event handler to the "keypress" JavaScript event, or trigger that event on an element.
  * 
  * @param eventData An object containing data that will be passed to the event handler. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 keypress__variant__oxygen__2:function(eventData, handler){},

 /**
  * Bind an event handler to the "keypress" JavaScript event, or trigger that event on an element.
  *
  * @return jQuery
  */
 keypress__variant__oxygen__3:function(){},

 /**
  * Bind an event handler to the "keyup" JavaScript event, or trigger that event on an element.
  * 
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 keyup:function(handler){},

 /**
  * Bind an event handler to the "keyup" JavaScript event, or trigger that event on an element.
  * 
  * @param eventData An object containing data that will be passed to the event handler. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 keyup__variant__oxygen__2:function(eventData, handler){},

 /**
  * Bind an event handler to the "keyup" JavaScript event, or trigger that event on an element.
  *
  * @return jQuery
  */
 keyup__variant__oxygen__3:function(){},

 /**
  * Reduce the set of matched elements to the final one in the set.
  *
  * @return jQuery
  */
 last:function(){},

 /**
  * Attach an event handler for all elements which match the current selector, now and in the future.
  * 
  * @param events A string containing a JavaScript event type, such as "click" or "keydown." As of jQuery 1.4 the string can contain multiple, space-separated event types or custom event names. This parameter is required.
  * @param handler=handler(eventObject) A function to execute at the time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 live:function(events, handler){},

 /**
  * Attach an event handler for all elements which match the current selector, now and in the future.
  * 
  * @param events A string containing a JavaScript event type, such as "click" or "keydown." As of jQuery 1.4 the string can contain multiple, space-separated event types or custom event names. This parameter is required.
  * @param data An object containing data that will be passed to the event handler. This parameter is required.
  * @param handler=handler(eventObject) A function to execute at the time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 live__variant__oxygen__2:function(events, data, handler){},

 /**
  * Attach an event handler for all elements which match the current selector, now and in the future.
  * 
  * @param events A plain object of one or more JavaScript event types and functions to execute for them. This parameter is required.
  *
  * @return jQuery
  */
 live__variant__oxygen__3:function(events){},

 /**
  * Bind an event handler to the "load" JavaScript event.
  * 
  * @param handler=handler(eventObject) A function to execute when the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 load:function(handler){},

 /**
  * Bind an event handler to the "load" JavaScript event.
  * 
  * @param eventData An object containing data that will be passed to the event handler. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 load__variant__oxygen__2:function(eventData, handler){},

 /**
  * Load data from the server and place the returned HTML into the matched element.
  * 
  * @param url A string containing the URL to which the request is sent. This parameter is required.
  * @param data A plain object or string that is sent to the server with the request. This parameter is optional.
  * @param complete=complete(responseText, textStatus, XMLHttpRequest) A callback function that is executed when the request completes. This parameter is optional.
  *
  * @return jQuery
  */
 load__variant__oxygen__3:function(url, data, complete){},

 /**
  * Pass each element in the current matched set through a function, producing a new jQuery object containing the return values.
  * 
  * @param callback=callback(index, domElement) A function object that will be invoked for each element in the current set. This parameter is required.
  *
  * @return jQuery
  */
 map:function(callback){},

 /**
  * Bind an event handler to the "mousedown" JavaScript event, or trigger that event on an element.
  * 
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 mousedown:function(handler){},

 /**
  * Bind an event handler to the "mousedown" JavaScript event, or trigger that event on an element.
  * 
  * @param eventData An object containing data that will be passed to the event handler. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 mousedown__variant__oxygen__2:function(eventData, handler){},

 /**
  * Bind an event handler to the "mousedown" JavaScript event, or trigger that event on an element.
  *
  * @return jQuery
  */
 mousedown__variant__oxygen__3:function(){},

 /**
  * Bind an event handler to be fired when the mouse enters an element, or trigger that handler on an element.
  * 
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 mouseenter:function(handler){},

 /**
  * Bind an event handler to be fired when the mouse enters an element, or trigger that handler on an element.
  * 
  * @param eventData An object containing data that will be passed to the event handler. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 mouseenter__variant__oxygen__2:function(eventData, handler){},

 /**
  * Bind an event handler to be fired when the mouse enters an element, or trigger that handler on an element.
  *
  * @return jQuery
  */
 mouseenter__variant__oxygen__3:function(){},

 /**
  * Bind an event handler to be fired when the mouse leaves an element, or trigger that handler on an element.
  * 
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 mouseleave:function(handler){},

 /**
  * Bind an event handler to be fired when the mouse leaves an element, or trigger that handler on an element.
  * 
  * @param eventData An object containing data that will be passed to the event handler. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 mouseleave__variant__oxygen__2:function(eventData, handler){},

 /**
  * Bind an event handler to be fired when the mouse leaves an element, or trigger that handler on an element.
  *
  * @return jQuery
  */
 mouseleave__variant__oxygen__3:function(){},

 /**
  * Bind an event handler to the "mousemove" JavaScript event, or trigger that event on an element.
  * 
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 mousemove:function(handler){},

 /**
  * Bind an event handler to the "mousemove" JavaScript event, or trigger that event on an element.
  * 
  * @param eventData An object containing data that will be passed to the event handler. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 mousemove__variant__oxygen__2:function(eventData, handler){},

 /**
  * Bind an event handler to the "mousemove" JavaScript event, or trigger that event on an element.
  *
  * @return jQuery
  */
 mousemove__variant__oxygen__3:function(){},

 /**
  * Bind an event handler to the "mouseout" JavaScript event, or trigger that event on an element.
  * 
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 mouseout:function(handler){},

 /**
  * Bind an event handler to the "mouseout" JavaScript event, or trigger that event on an element.
  * 
  * @param eventData An object containing data that will be passed to the event handler. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 mouseout__variant__oxygen__2:function(eventData, handler){},

 /**
  * Bind an event handler to the "mouseout" JavaScript event, or trigger that event on an element.
  *
  * @return jQuery
  */
 mouseout__variant__oxygen__3:function(){},

 /**
  * Bind an event handler to the "mouseover" JavaScript event, or trigger that event on an element.
  * 
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 mouseover:function(handler){},

 /**
  * Bind an event handler to the "mouseover" JavaScript event, or trigger that event on an element.
  * 
  * @param eventData An object containing data that will be passed to the event handler. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 mouseover__variant__oxygen__2:function(eventData, handler){},

 /**
  * Bind an event handler to the "mouseover" JavaScript event, or trigger that event on an element.
  *
  * @return jQuery
  */
 mouseover__variant__oxygen__3:function(){},

 /**
  * Bind an event handler to the "mouseup" JavaScript event, or trigger that event on an element.
  * 
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 mouseup:function(handler){},

 /**
  * Bind an event handler to the "mouseup" JavaScript event, or trigger that event on an element.
  * 
  * @param eventData An object containing data that will be passed to the event handler. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 mouseup__variant__oxygen__2:function(eventData, handler){},

 /**
  * Bind an event handler to the "mouseup" JavaScript event, or trigger that event on an element.
  *
  * @return jQuery
  */
 mouseup__variant__oxygen__3:function(){},

 /**
  * Get the immediately following sibling of each element in the set of matched elements. If a selector is provided, it retrieves the next sibling only if it matches that selector.
  * 
  * @param selector A string containing a selector expression to match elements against. This parameter is optional.
  *
  * @return jQuery
  */
 next:function(selector){},

 /**
  * Get all following siblings of each element in the set of matched elements, optionally filtered by a selector.
  * 
  * @param selector A string containing a selector expression to match elements against. This parameter is optional.
  *
  * @return jQuery
  */
 nextAll:function(selector){},

 /**
  * Get all following siblings of each element up to but not including the element matched by the selector, DOM node, or jQuery object passed.
  * 
  * @param selector A string containing a selector expression to indicate where to stop matching following sibling elements. This parameter is optional.
  * @param filter A string containing a selector expression to match elements against. This parameter is optional.
  *
  * @return jQuery
  */
 nextUntil:function(selector, filter){},

 /**
  * Get all following siblings of each element up to but not including the element matched by the selector, DOM node, or jQuery object passed.
  * 
  * @param element A DOM node or jQuery object indicating where to stop matching following sibling elements. This parameter is optional.
  * @param filter A string containing a selector expression to match elements against. This parameter is optional.
  *
  * @return jQuery
  */
 nextUntil__variant__oxygen__2:function(element, filter){},

 /**
  * Remove elements from the set of matched elements.
  * 
  * @param selector A string containing a selector expression to match elements against. This parameter is required.
  *
  * @return jQuery
  */
 not:function(selector){},

 /**
  * Remove elements from the set of matched elements.
  * 
  * @param elements One or more DOM elements to remove from the matched set. This parameter is required.
  *
  * @return jQuery
  */
 not__variant__oxygen__2:function(elements){},

 /**
  * Remove elements from the set of matched elements.
  * 
  * @param func=function(index) A function used as a test for each element in the set. this is the current DOM element. This parameter is required.
  *
  * @return jQuery
  */
 not__variant__oxygen__3:function(func){},

 /**
  * Remove elements from the set of matched elements.
  * 
  * @param jQueryObject An existing jQuery object to match the current set of elements against. This parameter is required.
  *
  * @return jQuery
  */
 not__variant__oxygen__4:function(jQueryObject){},

 /**
  * Remove an event handler.
  * 
  * @param events One or more space-separated event types and optional namespaces, or just namespaces, such as "click", "keydown.myPlugin", or ".myPlugin". This parameter is required.
  * @param selector A selector which should match the one originally passed to .on() when attaching event handlers. This parameter is optional.
  * @param handler=handler(eventObject) A handler function previously attached for the event(s), or the special value false. This parameter is optional.
  *
  * @return jQuery
  */
 off:function(events, selector, handler){},

 /**
  * Remove an event handler.
  * 
  * @param events An object where the string keys represent one or more space-separated event types and optional namespaces, and the values represent handler functions previously attached for the event(s). This parameter is required.
  * @param selector A selector which should match the one originally passed to .on() when attaching event handlers. This parameter is optional.
  *
  * @return jQuery
  */
 off__variant__oxygen__2:function(events, selector){},

 /**
  * Get the current coordinates of the first element in the set of matched elements, relative to the document.
  *
  * @return Object
  */
 offset:function(){},

 /**
  * Set the current coordinates of every element in the set of matched elements, relative to the document.
  * 
  * @param coordinates An object containing the properties top and left, which are integers indicating the new top and left coordinates for the elements. This parameter is required.
  *
  * @return jQuery
  */
 offset__variant__oxygen__2:function(coordinates){},

 /**
  * Set the current coordinates of every element in the set of matched elements, relative to the document.
  * 
  * @param func=function(index, coords) A function to return the coordinates to set. Receives the index of the element in the collection as the first argument and the current coordinates as the second argument. The function should return an object with the new top and left properties. This parameter is required.
  *
  * @return jQuery
  */
 offset__variant__oxygen__3:function(func){},

 /**
  * Get the closest ancestor element that is positioned.
  *
  * @return jQuery
  */
 offsetParent:function(){},

 /**
  * Attach an event handler function for one or more events to the selected elements.
  * 
  * @param events One or more space-separated event types and optional namespaces, such as "click" or "keydown.myPlugin". This parameter is required.
  * @param selector A selector string to filter the descendants of the selected elements that trigger the event. If the selector is null or omitted, the event is always triggered when it reaches the selected element. This parameter is optional.
  * @param data Data to be passed to the handler in event.data when an event is triggered. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute when the event is triggered. The value false is also allowed as a shorthand for a function that simply does return false. This parameter is required.
  *
  * @return jQuery
  */
 on:function(events, selector, data, handler){},

 /**
  * Attach an event handler function for one or more events to the selected elements.
  * 
  * @param events An object in which the string keys represent one or more space-separated event types and optional namespaces, and the values represent a handler function to be called for the event(s). This parameter is required.
  * @param selector A selector string to filter the descendants of the selected elements that will call the handler. If the selector is null or omitted, the handler is always called when it reaches the selected element. This parameter is optional.
  * @param data Data to be passed to the handler in event.data when an event occurs. This parameter is optional.
  *
  * @return jQuery
  */
 on__variant__oxygen__2:function(events, selector, data){},

 /**
  * Attach a handler to an event for the elements. The handler is executed at most once per element.
  * 
  * @param events A string containing one or more JavaScript event types, such as "click" or "submit," or custom event names. This parameter is required.
  * @param data An object containing data that will be passed to the event handler. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute at the time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 one:function(events, data, handler){},

 /**
  * Attach a handler to an event for the elements. The handler is executed at most once per element.
  * 
  * @param events One or more space-separated event types and optional namespaces, such as "click" or "keydown.myPlugin". This parameter is required.
  * @param selector A selector string to filter the descendants of the selected elements that trigger the event. If the selector is null or omitted, the event is always triggered when it reaches the selected element. This parameter is optional.
  * @param data Data to be passed to the handler in event.data when an event is triggered. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute when the event is triggered. The value false is also allowed as a shorthand for a function that simply does return false. This parameter is required.
  *
  * @return jQuery
  */
 one__variant__oxygen__2:function(events, selector, data, handler){},

 /**
  * Attach a handler to an event for the elements. The handler is executed at most once per element.
  * 
  * @param events An object in which the string keys represent one or more space-separated event types and optional namespaces, and the values represent a handler function to be called for the event(s). This parameter is required.
  * @param selector A selector string to filter the descendants of the selected elements that will call the handler. If the selector is null or omitted, the handler is always called when it reaches the selected element. This parameter is optional.
  * @param data Data to be passed to the handler in event.data when an event occurs. This parameter is optional.
  *
  * @return jQuery
  */
 one__variant__oxygen__3:function(events, selector, data){},

 /**
  * Get the current computed height for the first element in the set of matched elements, including padding, border, and optionally margin. Returns an integer (without "px") representation of the value or null if called on an empty set of elements.
  * 
  * @param includeMargin A Boolean indicating whether to include the element's margin in the calculation. This parameter is optional.
  *
  * @return Integer
  */
 outerHeight:function(includeMargin){},

 /**
  * Get the current computed width for the first element in the set of matched elements, including padding and border.
  * 
  * @param includeMargin A Boolean indicating whether to include the element's margin in the calculation. This parameter is optional.
  *
  * @return Integer
  */
 outerWidth:function(includeMargin){},

 /**
  * Get the parent of each element in the current set of matched elements, optionally filtered by a selector.
  * 
  * @param selector A string containing a selector expression to match elements against. This parameter is optional.
  *
  * @return jQuery
  */
 parent:function(selector){},

 /**
  * Get the ancestors of each element in the current set of matched elements, optionally filtered by a selector.
  * 
  * @param selector A string containing a selector expression to match elements against. This parameter is optional.
  *
  * @return jQuery
  */
 parents:function(selector){},

 /**
  * Get the ancestors of each element in the current set of matched elements, up to but not including the element matched by the selector, DOM node, or jQuery object.
  * 
  * @param selector A string containing a selector expression to indicate where to stop matching ancestor elements. This parameter is optional.
  * @param filter A string containing a selector expression to match elements against. This parameter is optional.
  *
  * @return jQuery
  */
 parentsUntil:function(selector, filter){},

 /**
  * Get the ancestors of each element in the current set of matched elements, up to but not including the element matched by the selector, DOM node, or jQuery object.
  * 
  * @param element A DOM node or jQuery object indicating where to stop matching ancestor elements. This parameter is optional.
  * @param filter A string containing a selector expression to match elements against. This parameter is optional.
  *
  * @return jQuery
  */
 parentsUntil__variant__oxygen__2:function(element, filter){},

 /**
  * Get the current coordinates of the first element in the set of matched elements, relative to the offset parent.
  *
  * @return Object
  */
 position:function(){},

 /**
  * Insert content, specified by the parameter, to the beginning of each element in the set of matched elements.
  * 
  * @param content DOM element, array of elements, HTML string, or jQuery object to insert at the beginning of each element in the set of matched elements. This parameter is required.
  * @param content One or more additional DOM elements, arrays of elements, HTML strings, or jQuery objects to insert at the beginning of each element in the set of matched elements. This parameter is optional.
  *
  * @return jQuery
  */
 prepend:function(content, content){},

 /**
  * Insert content, specified by the parameter, to the beginning of each element in the set of matched elements.
  * 
  * @param func=function(index, html) A function that returns an HTML string, DOM element(s), or jQuery object to insert at the beginning of each element in the set of matched elements. Receives the index position of the element in the set and the old HTML value of the element as arguments. Within the function, this refers to the current element in the set. This parameter is required.
  *
  * @return jQuery
  */
 prepend__variant__oxygen__2:function(func){},

 /**
  * Insert every element in the set of matched elements to the beginning of the target.
  * 
  * @param target A selector, element, HTML string, or jQuery object; the matched set of elements will be inserted at the beginning of the element(s) specified by this parameter. This parameter is required.
  *
  * @return jQuery
  */
 prependTo:function(target){},

 /**
  * Get the immediately preceding sibling of each element in the set of matched elements, optionally filtered by a selector.
  * 
  * @param selector A string containing a selector expression to match elements against. This parameter is optional.
  *
  * @return jQuery
  */
 prev:function(selector){},

 /**
  * Get all preceding siblings of each element in the set of matched elements, optionally filtered by a selector.
  * 
  * @param selector A string containing a selector expression to match elements against. This parameter is optional.
  *
  * @return jQuery
  */
 prevAll:function(selector){},

 /**
  * Get all preceding siblings of each element up to but not including the element matched by the selector, DOM node, or jQuery object.
  * 
  * @param selector A string containing a selector expression to indicate where to stop matching preceding sibling elements. This parameter is optional.
  * @param filter A string containing a selector expression to match elements against. This parameter is optional.
  *
  * @return jQuery
  */
 prevUntil:function(selector, filter){},

 /**
  * Get all preceding siblings of each element up to but not including the element matched by the selector, DOM node, or jQuery object.
  * 
  * @param element A DOM node or jQuery object indicating where to stop matching preceding sibling elements. This parameter is optional.
  * @param filter A string containing a selector expression to match elements against. This parameter is optional.
  *
  * @return jQuery
  */
 prevUntil__variant__oxygen__2:function(element, filter){},

 /**
  * Return a Promise object to observe when all actions of a certain type bound to the collection, queued or not, have finished.
  * 
  * @param type The type of queue that needs to be observed. This parameter is optional.
  * @param target Object onto which the promise methods have to be attached This parameter is optional.
  *
  * @return Promise
  */
 promise:function(type, target){},

 /**
  * Get the value of a property for the first element in the set of matched elements.
  * 
  * @param propertyName The name of the property to get. This parameter is required.
  *
  * @return String
  */
 prop:function(propertyName){},

 /**
  * Set one or more properties for the set of matched elements.
  * 
  * @param propertyName The name of the property to set. This parameter is required.
  * @param value A value to set for the property. This parameter is required.
  *
  * @return jQuery
  */
 prop__variant__oxygen__2:function(propertyName, value){},

 /**
  * Set one or more properties for the set of matched elements.
  * 
  * @param properties An object of property-value pairs to set. This parameter is required.
  *
  * @return jQuery
  */
 prop__variant__oxygen__3:function(properties){},

 /**
  * Set one or more properties for the set of matched elements.
  * 
  * @param propertyName The name of the property to set. This parameter is required.
  * @param func=function(index, oldPropertyValue) A function returning the value to set. Receives the index position of the element in the set and the old property value as arguments. Within the function, the keyword this refers to the current element. This parameter is required.
  *
  * @return jQuery
  */
 prop__variant__oxygen__4:function(propertyName, func){},

 /**
  * Add a collection of DOM elements onto the jQuery stack.
  * 
  * @param elements An array of elements to push onto the stack and make into a new jQuery object. This parameter is required.
  *
  * @return jQuery
  */
 pushStack:function(elements){},

 /**
  * Add a collection of DOM elements onto the jQuery stack.
  * 
  * @param elements An array of elements to push onto the stack and make into a new jQuery object. This parameter is required.
  * @param name The name of a jQuery method that generated the array of elements. This parameter is required.
  * @param arguments The arguments that were passed in to the jQuery method (for serialization). This parameter is required.
  *
  * @return jQuery
  */
 pushStack__variant__oxygen__2:function(elements, name, arguments){},

 /**
  * Show the queue of functions to be executed on the matched elements.
  * 
  * @param queueName A string containing the name of the queue. Defaults to fx, the standard effects queue. This parameter is optional.
  *
  * @return Array
  */
 queue:function(queueName){},

 /**
  * Manipulate the queue of functions to be executed, once for each matched element.
  * 
  * @param queueName A string containing the name of the queue. Defaults to fx, the standard effects queue. This parameter is optional.
  * @param newQueue An array of functions to replace the current queue contents. This parameter is required.
  *
  * @return jQuery
  */
 queue__variant__oxygen__2:function(queueName, newQueue){},

 /**
  * Manipulate the queue of functions to be executed, once for each matched element.
  * 
  * @param queueName A string containing the name of the queue. Defaults to fx, the standard effects queue. This parameter is optional.
  * @param callback=callback( next ) The new function to add to the queue, with a function to call that will dequeue the next item. This parameter is required.
  *
  * @return jQuery
  */
 queue__variant__oxygen__3:function(queueName, callback){},

 /**
  * Specify a function to execute when the DOM is fully loaded.
  * 
  * @param handler A function to execute after the DOM is ready. This parameter is required.
  *
  * @return jQuery
  */
 ready:function(handler){},

 /**
  * Remove the set of matched elements from the DOM.
  * 
  * @param selector A selector expression that filters the set of matched elements to be removed. This parameter is optional.
  *
  * @return jQuery
  */
 remove:function(selector){},

 /**
  * Remove an attribute from each element in the set of matched elements.
  * 
  * @param attributeName An attribute to remove; as of version 1.7, it can be a space-separated list of attributes. This parameter is required.
  *
  * @return jQuery
  */
 removeAttr:function(attributeName){},

 /**
  * Remove a single class, multiple classes, or all classes from each element in the set of matched elements.
  * 
  * @param className One or more space-separated classes to be removed from the class attribute of each matched element. This parameter is optional.
  *
  * @return jQuery
  */
 removeClass:function(className){},

 /**
  * Remove a single class, multiple classes, or all classes from each element in the set of matched elements.
  * 
  * @param func=function(index, class) A function returning one or more space-separated class names to be removed. Receives the index position of the element in the set and the old class value as arguments. This parameter is required.
  *
  * @return jQuery
  */
 removeClass__variant__oxygen__2:function(func){},

 /**
  * Remove a previously-stored piece of data.
  * 
  * @param name A string naming the piece of data to delete. This parameter is optional.
  *
  * @return jQuery
  */
 removeData:function(name){},

 /**
  * Remove a previously-stored piece of data.
  * 
  * @param list An array or space-separated string naming the pieces of data to delete. This parameter is optional.
  *
  * @return jQuery
  */
 removeData__variant__oxygen__2:function(list){},

 /**
  * Remove a property for the set of matched elements.
  * 
  * @param propertyName The name of the property to remove. This parameter is required.
  *
  * @return jQuery
  */
 removeProp:function(propertyName){},

 /**
  * Replace each target element with the set of matched elements.
  * 
  * @param target A selector expression indicating which element(s) to replace. This parameter is required.
  *
  * @return jQuery
  */
 replaceAll:function(target){},

 /**
  * Replace each element in the set of matched elements with the provided new content and return the set of elements that was removed.
  * 
  * @param newContent The content to insert. May be an HTML string, DOM element, or jQuery object. This parameter is required.
  *
  * @return jQuery
  */
 replaceWith:function(newContent){},

 /**
  * Replace each element in the set of matched elements with the provided new content and return the set of elements that was removed.
  * 
  * @param function A function that returns content with which to replace the set of matched elements. This parameter is required.
  *
  * @return jQuery
  */
 replaceWith__variant__oxygen__2:function(func){},

 /**
  * Bind an event handler to the "resize" JavaScript event, or trigger that event on an element.
  * 
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 resize:function(handler){},

 /**
  * Bind an event handler to the "resize" JavaScript event, or trigger that event on an element.
  * 
  * @param eventData An object containing data that will be passed to the event handler. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 resize__variant__oxygen__2:function(eventData, handler){},

 /**
  * Bind an event handler to the "resize" JavaScript event, or trigger that event on an element.
  *
  * @return jQuery
  */
 resize__variant__oxygen__3:function(){},

 /**
  * Bind an event handler to the "scroll" JavaScript event, or trigger that event on an element.
  * 
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 scroll:function(handler){},

 /**
  * Bind an event handler to the "scroll" JavaScript event, or trigger that event on an element.
  * 
  * @param eventData An object containing data that will be passed to the event handler. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 scroll__variant__oxygen__2:function(eventData, handler){},

 /**
  * Bind an event handler to the "scroll" JavaScript event, or trigger that event on an element.
  *
  * @return jQuery
  */
 scroll__variant__oxygen__3:function(){},

 /**
  * Get the current horizontal position of the scroll bar for the first element in the set of matched elements.
  *
  * @return Integer
  */
 scrollLeft:function(){},

 /**
  * Set the current horizontal position of the scroll bar for each of the set of matched elements.
  * 
  * @param value An integer indicating the new position to set the scroll bar to. This parameter is required.
  *
  * @return jQuery
  */
 scrollLeft__variant__oxygen__2:function(value){},

 /**
  * Get the current vertical position of the scroll bar for the first element in the set of matched elements or set the vertical position of the scroll bar for every matched element.
  *
  * @return Integer
  */
 scrollTop:function(){},

 /**
  * Set the current vertical position of the scroll bar for each of the set of matched elements.
  * 
  * @param value An integer indicating the new position to set the scroll bar to. This parameter is required.
  *
  * @return jQuery
  */
 scrollTop__variant__oxygen__2:function(value){},

 /**
  * Bind an event handler to the "select" JavaScript event, or trigger that event on an element.
  * 
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 select:function(handler){},

 /**
  * Bind an event handler to the "select" JavaScript event, or trigger that event on an element.
  * 
  * @param eventData An object containing data that will be passed to the event handler. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 select__variant__oxygen__2:function(eventData, handler){},

 /**
  * Bind an event handler to the "select" JavaScript event, or trigger that event on an element.
  *
  * @return jQuery
  */
 select__variant__oxygen__3:function(){},

 /**
  * Encode a set of form elements as a string for submission.
  *
  * @return String
  */
 serialize:function(){},

 /**
  * Encode a set of form elements as an array of names and values.
  *
  * @return Array
  */
 serializeArray:function(){},

 /**
  * Display the matched elements.
  *
  * @return jQuery
  */
 show:function(){},

 /**
  * Display the matched elements.
  * 
  * @param duration A string or number determining how long the animation will run. This parameter is optional.
  * @param complete A function to call once the animation is complete. This parameter is optional.
  *
  * @return jQuery
  */
 show__variant__oxygen__2:function(duration, complete){},

 /**
  * Display the matched elements.
  * 
  * @param options A map of additional options to pass to the method. This parameter is required.
  *
  * @return jQuery
  */
 show__variant__oxygen__3:function(options){},

 /**
  * Display the matched elements.
  * 
  * @param duration A string or number determining how long the animation will run. This parameter is required.
  * @param easing A string indicating which easing function to use for the transition. This parameter is optional.
  * @param complete A function to call once the animation is complete. This parameter is optional.
  *
  * @return jQuery
  */
 show__variant__oxygen__4:function(duration, easing, complete){},

 /**
  * Get the siblings of each element in the set of matched elements, optionally filtered by a selector.
  * 
  * @param selector A string containing a selector expression to match elements against. This parameter is optional.
  *
  * @return jQuery
  */
 siblings:function(selector){},

 /**
  * Return the number of elements in the jQuery object.
  *
  * @return Number
  */
 size:function(){},

 /**
  * Reduce the set of matched elements to a subset specified by a range of indices.
  * 
  * @param start An integer indicating the 0-based position at which the elements begin to be selected. If negative, it indicates an offset from the end of the set. This parameter is required.
  * @param end An integer indicating the 0-based position at which the elements stop being selected. If negative, it indicates an offset from the end of the set. If omitted, the range continues until the end of the set. This parameter is optional.
  *
  * @return jQuery
  */
 slice:function(start, end){},

 /**
  * Display the matched elements with a sliding motion.
  * 
  * @param duration A string or number determining how long the animation will run. This parameter is optional.
  * @param complete A function to call once the animation is complete. This parameter is optional.
  *
  * @return jQuery
  */
 slideDown:function(duration, complete){},

 /**
  * Display the matched elements with a sliding motion.
  * 
  * @param options A map of additional options to pass to the method. This parameter is required.
  *
  * @return jQuery
  */
 slideDown__variant__oxygen__2:function(options){},

 /**
  * Display the matched elements with a sliding motion.
  * 
  * @param duration A string or number determining how long the animation will run. This parameter is optional.
  * @param easing A string indicating which easing function to use for the transition. This parameter is optional.
  * @param complete A function to call once the animation is complete. This parameter is optional.
  *
  * @return jQuery
  */
 slideDown__variant__oxygen__3:function(duration, easing, complete){},

 /**
  * Display or hide the matched elements with a sliding motion.
  * 
  * @param duration A string or number determining how long the animation will run. This parameter is optional.
  * @param complete A function to call once the animation is complete. This parameter is optional.
  *
  * @return jQuery
  */
 slideToggle:function(duration, complete){},

 /**
  * Display or hide the matched elements with a sliding motion.
  * 
  * @param options A map of additional options to pass to the method. This parameter is required.
  *
  * @return jQuery
  */
 slideToggle__variant__oxygen__2:function(options){},

 /**
  * Display or hide the matched elements with a sliding motion.
  * 
  * @param duration A string or number determining how long the animation will run. This parameter is optional.
  * @param easing A string indicating which easing function to use for the transition. This parameter is optional.
  * @param complete A function to call once the animation is complete. This parameter is optional.
  *
  * @return jQuery
  */
 slideToggle__variant__oxygen__3:function(duration, easing, complete){},

 /**
  * Hide the matched elements with a sliding motion.
  * 
  * @param duration A string or number determining how long the animation will run. This parameter is optional.
  * @param complete A function to call once the animation is complete. This parameter is optional.
  *
  * @return jQuery
  */
 slideUp:function(duration, complete){},

 /**
  * Hide the matched elements with a sliding motion.
  * 
  * @param options A map of additional options to pass to the method. This parameter is required.
  *
  * @return jQuery
  */
 slideUp__variant__oxygen__2:function(options){},

 /**
  * Hide the matched elements with a sliding motion.
  * 
  * @param duration A string or number determining how long the animation will run. This parameter is optional.
  * @param easing A string indicating which easing function to use for the transition. This parameter is optional.
  * @param complete A function to call once the animation is complete. This parameter is optional.
  *
  * @return jQuery
  */
 slideUp__variant__oxygen__3:function(duration, easing, complete){},

 /**
  * Stop the currently-running animation on the matched elements.
  * 
  * @param clearQueue A Boolean indicating whether to remove queued animation as well. Defaults to false. This parameter is optional.
  * @param jumpToEnd A Boolean indicating whether to complete the current animation immediately. Defaults to false. This parameter is optional.
  *
  * @return jQuery
  */
 stop:function(clearQueue, jumpToEnd){},

 /**
  * Stop the currently-running animation on the matched elements.
  * 
  * @param queue The name of the queue in which to stop animations. This parameter is optional.
  * @param clearQueue A Boolean indicating whether to remove queued animation as well. Defaults to false. This parameter is optional.
  * @param jumpToEnd A Boolean indicating whether to complete the current animation immediately. Defaults to false. This parameter is optional.
  *
  * @return jQuery
  */
 stop__variant__oxygen__2:function(queue, clearQueue, jumpToEnd){},

 /**
  * Bind an event handler to the "submit" JavaScript event, or trigger that event on an element.
  * 
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 submit:function(handler){},

 /**
  * Bind an event handler to the "submit" JavaScript event, or trigger that event on an element.
  * 
  * @param eventData An object containing data that will be passed to the event handler. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 submit__variant__oxygen__2:function(eventData, handler){},

 /**
  * Bind an event handler to the "submit" JavaScript event, or trigger that event on an element.
  *
  * @return jQuery
  */
 submit__variant__oxygen__3:function(){},

 /**
  * Get the combined text contents of each element in the set of matched elements, including their descendants.
  *
  * @return String
  */
 text:function(){},

 /**
  * Set the content of each element in the set of matched elements to the specified text.
  * 
  * @param textString A string of text to set as the content of each matched element. This parameter is required.
  *
  * @return jQuery
  */
 text__variant__oxygen__2:function(textString){},

 /**
  * Set the content of each element in the set of matched elements to the specified text.
  * 
  * @param func=function(index, text) A function returning the text content to set. Receives the index position of the element in the set and the old text value as arguments. This parameter is required.
  *
  * @return jQuery
  */
 text__variant__oxygen__3:function(func){},

 /**
  * Retrieve all the DOM elements contained in the jQuery set, as an array.
  *
  * @return Array
  */
 toArray:function(){},

 /**
  * Bind two or more handlers to the matched elements, to be executed on alternate clicks.
  * 
  * @param handler=handler(eventObject) A function to execute every even time the element is clicked. This parameter is required.
  * @param handler=handler(eventObject) A function to execute every odd time the element is clicked. This parameter is required.
  * @param handler=handler(eventObject) Additional handlers to cycle through after clicks. This parameter is optional.
  *
  * @return jQuery
  */
 toggle:function(handler, handler, handler){},

 /**
  * Display or hide the matched elements.
  * 
  * @param duration A string or number determining how long the animation will run. This parameter is optional.
  * @param complete A function to call once the animation is complete. This parameter is optional.
  *
  * @return jQuery
  */
 toggle__variant__oxygen__2:function(duration, complete){},

 /**
  * Display or hide the matched elements.
  * 
  * @param options A map of additional options to pass to the method. This parameter is required.
  *
  * @return jQuery
  */
 toggle__variant__oxygen__3:function(options){},

 /**
  * Display or hide the matched elements.
  * 
  * @param duration A string or number determining how long the animation will run. This parameter is required.
  * @param easing A string indicating which easing function to use for the transition. This parameter is optional.
  * @param complete A function to call once the animation is complete. This parameter is optional.
  *
  * @return jQuery
  */
 toggle__variant__oxygen__4:function(duration, easing, complete){},

 /**
  * Display or hide the matched elements.
  * 
  * @param showOrHide A Boolean indicating whether to show or hide the elements. This parameter is required.
  *
  * @return jQuery
  */
 toggle__variant__oxygen__5:function(showOrHide){},

 /**
  * Add or remove one or more classes from each element in the set of matched elements, depending on either the class's presence or the value of the switch argument.
  * 
  * @param className One or more class names (separated by spaces) to be toggled for each element in the matched set. This parameter is required.
  *
  * @return jQuery
  */
 toggleClass:function(className){},

 /**
  * Add or remove one or more classes from each element in the set of matched elements, depending on either the class's presence or the value of the switch argument.
  * 
  * @param className One or more class names (separated by spaces) to be toggled for each element in the matched set. This parameter is required.
  * @param switchParam A Boolean (not just truthy/falsy) value to determine whether the class should be added or removed. This parameter is required.
  *
  * @return jQuery
  */
 toggleClass__variant__oxygen__2:function(className, switchParam){},

 /**
  * Add or remove one or more classes from each element in the set of matched elements, depending on either the class's presence or the value of the switch argument.
  * 
  * @param switchParam A boolean value to determine whether the class should be added or removed. This parameter is optional.
  *
  * @return jQuery
  */
 toggleClass__variant__oxygen__3:function(switchParam){},

 /**
  * Add or remove one or more classes from each element in the set of matched elements, depending on either the class's presence or the value of the switch argument.
  * 
  * @param func=function(index, class, switch) A function that returns class names to be toggled in the class attribute of each element in the matched set. Receives the index position of the element in the set, the old class value, and the switch as arguments. This parameter is required.
  * @param switchParam A boolean value to determine whether the class should be added or removed. This parameter is optional.
  *
  * @return jQuery
  */
 toggleClass__variant__oxygen__4:function(func, switchParam){},

 /**
  * Execute all handlers and behaviors attached to the matched elements for the given event type.
  * 
  * @param eventType A string containing a JavaScript event type, such as click or submit. This parameter is required.
  * @param extraParameters Additional parameters to pass along to the event handler. This parameter is optional.
  *
  * @return jQuery
  */
 trigger:function(eventType, extraParameters){},

 /**
  * Execute all handlers and behaviors attached to the matched elements for the given event type.
  * 
  * @param event A jQuery.Event object. This parameter is required.
  *
  * @return jQuery
  */
 trigger__variant__oxygen__2:function(event){},

 /**
  * Execute all handlers attached to an element for an event.
  * 
  * @param eventType A string containing a JavaScript event type, such as click or submit. This parameter is required.
  * @param extraParameters An array of additional parameters to pass along to the event handler. This parameter is optional.
  *
  * @return Object
  */
 triggerHandler:function(eventType, extraParameters){},

 /**
  * Remove a previously-attached event handler from the elements.
  * 
  * @param eventType A string containing a JavaScript event type, such as click or submit. This parameter is optional.
  * @param handler=handler(eventObject) The function that is to be no longer executed. This parameter is optional.
  *
  * @return jQuery
  */
 unbind:function(eventType, handler){},

 /**
  * Remove a previously-attached event handler from the elements.
  * 
  * @param eventType A string containing a JavaScript event type, such as click or submit. This parameter is required.
  * @param falseParam Unbinds the corresponding 'return false' function that was bound using .bind( eventType, false ). This parameter is required.
  *
  * @return jQuery
  */
 unbind__variant__oxygen__2:function(eventType, falseParam){},

 /**
  * Remove a previously-attached event handler from the elements.
  * 
  * @param event A JavaScript event object as passed to an event handler. This parameter is required.
  *
  * @return jQuery
  */
 unbind__variant__oxygen__3:function(event){},

 /**
  * Remove a handler from the event for all elements which match the current selector, based upon a specific set of root elements.
  *
  * @return jQuery
  */
 undelegate:function(){},

 /**
  * Remove a handler from the event for all elements which match the current selector, based upon a specific set of root elements.
  * 
  * @param selector A selector which will be used to filter the event results. This parameter is required.
  * @param eventType A string containing a JavaScript event type, such as "click" or "keydown" This parameter is required.
  *
  * @return jQuery
  */
 undelegate__variant__oxygen__2:function(selector, eventType){},

 /**
  * Remove a handler from the event for all elements which match the current selector, based upon a specific set of root elements.
  * 
  * @param selector A selector which will be used to filter the event results. This parameter is required.
  * @param eventType A string containing a JavaScript event type, such as "click" or "keydown" This parameter is required.
  * @param handler=handler(eventObject) A function to execute at the time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 undelegate__variant__oxygen__3:function(selector, eventType, handler){},

 /**
  * Remove a handler from the event for all elements which match the current selector, based upon a specific set of root elements.
  * 
  * @param selector A selector which will be used to filter the event results. This parameter is required.
  * @param events An object of one or more event types and previously bound functions to unbind from them. This parameter is required.
  *
  * @return jQuery
  */
 undelegate__variant__oxygen__4:function(selector, events){},

 /**
  * Remove a handler from the event for all elements which match the current selector, based upon a specific set of root elements.
  * 
  * @param namespace A string containing a namespace to unbind all events from. This parameter is required.
  *
  * @return jQuery
  */
 undelegate__variant__oxygen__5:function(namespace){},

 /**
  * Bind an event handler to the "unload" JavaScript event.
  * 
  * @param handler=handler(eventObject) A function to execute when the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 unload:function(handler){},

 /**
  * Bind an event handler to the "unload" JavaScript event.
  * 
  * @param eventData A plain object of data that will be passed to the event handler. This parameter is optional.
  * @param handler=handler(eventObject) A function to execute each time the event is triggered. This parameter is required.
  *
  * @return jQuery
  */
 unload__variant__oxygen__2:function(eventData, handler){},

 /**
  * Remove the parents of the set of matched elements from the DOM, leaving the matched elements in their place.
  *
  * @return jQuery
  */
 unwrap:function(){},

 /**
  * Get the current value of the first element in the set of matched elements.
  *
  * @return String, Number, Array
  */
 val:function(){},

 /**
  * Set the value of each element in the set of matched elements.
  * 
  * @param value A string of text or an array of strings corresponding to the value of each matched element to set as selected/checked. This parameter is required.
  *
  * @return jQuery
  */
 val__variant__oxygen__2:function(value){},

 /**
  * Set the value of each element in the set of matched elements.
  * 
  * @param func=function(index, value) A function returning the value to set. this is the current element. Receives the index position of the element in the set and the old value as arguments. This parameter is required.
  *
  * @return jQuery
  */
 val__variant__oxygen__3:function(func){},

 /**
  * Get the current computed width for the first element in the set of matched elements.
  *
  * @return Integer
  */
 width:function(){},

 /**
  * Set the CSS width of each element in the set of matched elements.
  * 
  * @param value An integer representing the number of pixels, or an integer along with an optional unit of measure appended (as a string). This parameter is required.
  *
  * @return jQuery
  */
 width__variant__oxygen__2:function(value){},

 /**
  * Set the CSS width of each element in the set of matched elements.
  * 
  * @param func=function(index, width) A function returning the width to set. Receives the index position of the element in the set and the old width as arguments. Within the function, this refers to the current element in the set. This parameter is required.
  *
  * @return jQuery
  */
 width__variant__oxygen__3:function(func){},

 /**
  * Wrap an HTML structure around each element in the set of matched elements.
  * 
  * @param wrappingElement A selector, element, HTML string, or jQuery object specifying the structure to wrap around the matched elements. This parameter is required.
  *
  * @return jQuery
  */
 wrap:function(wrappingElement){},

 /**
  * Wrap an HTML structure around each element in the set of matched elements.
  * 
  * @param func=function(index) A callback function returning the HTML content or jQuery object to wrap around the matched elements. Receives the index position of the element in the set as an argument. Within the function, this refers to the current element in the set. This parameter is required.
  *
  * @return jQuery
  */
 wrap__variant__oxygen__2:function(func){},

 /**
  * Wrap an HTML structure around all elements in the set of matched elements.
  * 
  * @param wrappingElement A selector, element, HTML string, or jQuery object specifying the structure to wrap around the matched elements. This parameter is required.
  *
  * @return jQuery
  */
 wrapAll:function(wrappingElement){},

 /**
  * Wrap an HTML structure around the content of each element in the set of matched elements.
  * 
  * @param wrappingElement An HTML snippet, selector expression, jQuery object, or DOM element specifying the structure to wrap around the content of the matched elements. This parameter is required.
  *
  * @return jQuery
  */
 wrapInner:function(wrappingElement){},

 /**
  * Wrap an HTML structure around the content of each element in the set of matched elements.
  * 
  * @param func=function(index) A callback function which generates a structure to wrap around the content of the matched elements. Receives the index position of the element in the set as an argument. Within the function, this refers to the current element in the set. This parameter is required.
  *
  * @return jQuery
  */
 wrapInner__variant__oxygen__2:function(func){},

 /**
  * Add the previous set of elements on the stack to the current set, optionally filtered by a selector.
  * 
  * @param selector A string containing a selector expression to match the current set of elements against. This parameter is optional.
  *
  * @return jQuery
  */
 addBack:function(selector){},

 /**
  * Stop the currently-running animation, remove all queued animations, and complete all animations for the matched elements.
  * 
  * @param queue The name of the queue in which to stop animations. This parameter is optional.
  *
  * @return jQuery
  */
 finish:function(queue){}
}

callbacks.prototype = { 
 /**
  * Add a callback or a collection of callbacks to a callback list.
  * 
  * @param callbacks A function, or array of functions, that are to be added to the callback list. This parameter is required.
  *
  * @return Callbacks
  */
 add:function(callbacks){},

 /**
  * Disable a callback list from doing anything more.
  *
  * @return Callbacks
  */
 disable:function(){},

 /**
  * Remove all of the callbacks from a list.
  *
  * @return Callbacks
  */
 empty:function(){},

 /**
  * Call all of the callbacks with the given arguments
  * 
  * @param arguments The argument or list of arguments to pass back to the callback list. This parameter is required.
  *
  * @return Callbacks
  */
 fire:function(arguments){},

 /**
  * Call all callbacks in a list with the given context and arguments.
  * 
  * @param context A reference to the context in which the callbacks in the list should be fired. This parameter is optional.
  * @param args An argument, or array of arguments, to pass to the callbacks in the list. This parameter is optional.
  *
  * @return Callbacks
  */
 fireWith:function(context, args){},

 /**
  * Determine if the callbacks have already been called at least once.
  *
  * @return Boolean
  */
 fired:function(){},

 /**
  * Determine whether a supplied callback is in a list
  * 
  * @param callback The callback to search for. This parameter is required.
  *
  * @return Boolean
  */
 has:function(callback){},

 /**
  * Lock a callback list in its current state.
  *
  * @return Callbacks
  */
 lock:function(){},

 /**
  * Determine if the callbacks list has been locked.
  *
  * @return Boolean
  */
 locked:function(){},

 /**
  * Remove a callback or a collection of callbacks from a callback list.
  * 
  * @param callbacks A function, or array of functions, that are to be removed from the callback list. This parameter is required.
  *
  * @return Callbacks
  */
 remove:function(callbacks){},

 /**
  * Determine if the callbacks list has been disabled.
  *
  * @return Boolean
  */
 disabled:function(){}
}

deferred.prototype = { 
 /**
  * Add handlers to be called when the Deferred object is either resolved or rejected.
  * 
  * @param alwaysCallbacks A function, or array of functions, that is called when the Deferred is resolved or rejected. This parameter is required.
  * @param alwaysCallbacks Optional additional functions, or arrays of functions, that are called when the Deferred is resolved or rejected. This parameter is optional.
  *
  * @return Deferred
  */
 always:function(alwaysCallbacks, alwaysCallbacks){},

 /**
  * Add handlers to be called when the Deferred object is resolved.
  * 
  * @param doneCallbacks A function, or array of functions, that are called when the Deferred is resolved. This parameter is required.
  * @param doneCallbacks Optional additional functions, or arrays of functions, that are called when the Deferred is resolved. This parameter is optional.
  *
  * @return Deferred
  */
 done:function(doneCallbacks, doneCallbacks){},

 /**
  * Add handlers to be called when the Deferred object is rejected.
  * 
  * @param failCallbacks A function, or array of functions, that are called when the Deferred is rejected. This parameter is required.
  * @param failCallbacks Optional additional functions, or arrays of functions, that are called when the Deferred is rejected. This parameter is optional.
  *
  * @return Deferred
  */
 fail:function(failCallbacks, failCallbacks){},

 /**
  * Determine whether a Deferred object has been rejected.
  *
  * @return Boolean
  */
 isRejected:function(){},

 /**
  * Determine whether a Deferred object has been resolved.
  *
  * @return Boolean
  */
 isResolved:function(){},

 /**
  * Call the progressCallbacks on a Deferred object with the given args.
  * 
  * @param args Optional arguments that are passed to the progressCallbacks. This parameter is required.
  *
  * @return Deferred
  */
 notify:function(args){},

 /**
  * Call the progressCallbacks on a Deferred object with the given context and args.
  * 
  * @param context Context passed to the progressCallbacks as the this object. This parameter is required.
  * @param args Optional arguments that are passed to the progressCallbacks. This parameter is optional.
  *
  * @return Deferred
  */
 notifyWith:function(context, args){},

 /**
  * Utility method to filter and/or chain Deferreds.
  * 
  * @param doneFilter An optional function that is called when the Deferred is resolved. This parameter is optional.
  * @param failFilter An optional function that is called when the Deferred is rejected. This parameter is optional.
  *
  * @return Promise
  */
 pipe:function(doneFilter, failFilter){},

 /**
  * Utility method to filter and/or chain Deferreds.
  * 
  * @param doneFilter An optional function that is called when the Deferred is resolved. This parameter is optional.
  * @param failFilter An optional function that is called when the Deferred is rejected. This parameter is optional.
  * @param progressFilter An optional function that is called when progress notifications are sent to the Deferred. This parameter is optional.
  *
  * @return Promise
  */
 pipe__variant__oxygen__2:function(doneFilter, failFilter, progressFilter){},

 /**
  * Add handlers to be called when the Deferred object generates progress notifications.
  * 
  * @param progressCallbacks A function, or array of functions, that is called when the Deferred generates progress notifications. This parameter is required.
  *
  * @return Deferred
  */
 progress:function(progressCallbacks){},

 /**
  * Return a Deferred's Promise object.
  * 
  * @param target Object onto which the promise methods have to be attached This parameter is optional.
  *
  * @return Promise
  */
 promise:function(target){},

 /**
  * Reject a Deferred object and call any failCallbacks with the given args.
  * 
  * @param args Optional arguments that are passed to the failCallbacks. This parameter is required.
  *
  * @return Deferred
  */
 reject:function(args){},

 /**
  * Reject a Deferred object and call any failCallbacks with the given context and args.
  * 
  * @param context Context passed to the failCallbacks as the this object. This parameter is required.
  * @param args An optional array of arguments that are passed to the failCallbacks. This parameter is optional.
  *
  * @return Deferred
  */
 rejectWith:function(context, args){},

 /**
  * Resolve a Deferred object and call any doneCallbacks with the given args.
  * 
  * @param args Optional arguments that are passed to the doneCallbacks. This parameter is required.
  *
  * @return Deferred
  */
 resolve:function(args){},

 /**
  * Resolve a Deferred object and call any doneCallbacks with the given context and args.
  * 
  * @param context Context passed to the doneCallbacks as the this object. This parameter is required.
  * @param args An optional array of arguments that are passed to the doneCallbacks. This parameter is optional.
  *
  * @return Deferred
  */
 resolveWith:function(context, args){},

 /**
  * Determine the current state of a Deferred object.
  *
  * @return String
  */
 state:function(){},

 /**
  * Add handlers to be called when the Deferred object is resolved, rejected, or still in progress.
  * 
  * @param doneFilter A function that is called when the Deferred is resolved. This parameter is required.
  * @param failFilter An optional function that is called when the Deferred is rejected. This parameter is optional.
  * @param progressFilter An optional function that is called when progress notifications are sent to the Deferred. This parameter is optional.
  *
  * @return Promise
  */
 then:function(doneFilter, failFilter, progressFilter){},

 /**
  * Add handlers to be called when the Deferred object is resolved, rejected, or still in progress.
  * 
  * @param doneCallbacks A function, or array of functions, called when the Deferred is resolved. This parameter is required.
  * @param failCallbacks A function, or array of functions, called when the Deferred is rejected. This parameter is required.
  *
  * @return Promise
  */
 then__variant__oxygen__2:function(doneCallbacks, failCallbacks){},

 /**
  * Add handlers to be called when the Deferred object is resolved, rejected, or still in progress.
  * 
  * @param doneCallbacks A function, or array of functions, called when the Deferred is resolved. This parameter is required.
  * @param failCallbacks A function, or array of functions, called when the Deferred is rejected. This parameter is required.
  * @param progressCallbacks A function, or array of functions, called when the Deferred notifies progress. This parameter is optional.
  *
  * @return Promise
  */
 then__variant__oxygen__3:function(doneCallbacks, failCallbacks, progressCallbacks){}
}

event.prototype = { 
 /**
  * Returns whether event.preventDefault() was ever called on this event object.
  *
  * @return Boolean
  */
 isDefaultPrevented:function(){},

 /**
  * Returns whether event.stopImmediatePropagation() was ever called on this event object.
  *
  * @return Boolean
  */
 isImmediatePropagationStopped:function(){},

 /**
  * Returns whether event.stopPropagation() was ever called on this event object.
  *
  * @return Boolean
  */
 isPropagationStopped:function(){},

 /**
  * If this method is called, the default action of the event will not be triggered.
  *
  * @return undefined
  */
 preventDefault:function(){},

 /**
  * Keeps the rest of the handlers from being executed and prevents the event from bubbling up the DOM tree.
  */
 stopImmediatePropagation:function(){},

 /**
  * Prevents the event from bubbling up the DOM tree, preventing any parent handlers from being notified of the event.
  */
 stopPropagation:function(){},

 /**
  * The current DOM element within the event bubbling phase.
  * 
   * @return Element
  */
currentTarget:0,

 /**
  * An optional object of data passed to an event method when the current executing handler is bound.
  * 
   * @return Object
  */
data:0,

 /**
  * The element where the currently-called jQuery event handler was attached.
  * 
   * @return Element
  */
delegateTarget:0,

 /**
  * The namespace specified when the event was triggered.
  * 
   * @return String
  */
namespace:0,

 /**
  * The mouse position relative to the left edge of the document.
  * 
   * @return Number
  */
pageX:0,

 /**
  * The mouse position relative to the top edge of the document.
  * 
   * @return Number
  */
pageY:0,

 /**
  * The other DOM element involved in the event, if any.
  * 
   * @return Element
  */
relatedTarget:0,

 /**
  * The last value returned by an event handler that was triggered by this event, unless the value was undefined.
  * 
   * @return Object
  */
result:0,

 /**
  * The DOM element that initiated the event.
  * 
   * @return Element
  */
target:0,

 /**
  * The difference in milliseconds between the time the browser created the event and January 1, 1970.
  * 
   * @return Number
  */
timeStamp:0,

 /**
  * Describes the nature of the event.
  * 
   * @return String
  */
type:0,

 /**
  * For key or mouse events, this property indicates the specific key or button that was pressed.
  * 
   * @return Number
  */
which:0,

 /**
  * Indicates whether the META key was pressed when the event fired.
  * 
   * @return Boolean
  */
metaKey:0
}

jQuery.prototype = { 
 /**
  * A multi-purpose callbacks list object that provides a powerful way to manage callback lists.
  * 
  * @param flags An optional list of space-separated flags that change how the callback list behaves. This parameter is required.
  *
  * @return Callbacks
  */
 Callbacks:function(flags){},

 /**
  * Perform an asynchronous HTTP (Ajax) request.
  * 
  * @param url A string containing the URL to which the request is sent. This parameter is required.
  * @param settings A set of key/value pairs that configure the Ajax request. All settings are optional. A default can be set for any option with $.ajaxSetup(). See jQuery.ajax( settings ) below for a complete list of all settings. This parameter is optional.
  *
  * @return jqXHR
  */
 ajax:function(url, settings){},

 /**
  * Perform an asynchronous HTTP (Ajax) request.
  * 
  * @param settings A set of key/value pairs that configure the Ajax request. All settings are optional. A default can be set for any option with $.ajaxSetup(). This parameter is optional.
  *
  * @return jqXHR
  */
 ajax__variant__oxygen__2:function(settings){},

 /**
  * Handle custom Ajax options or modify existing options before each request is sent and before they are processed by $.ajax().
  * 
  * @param dataTypes An optional string containing one or more space-separated dataTypes This parameter is optional.
  * @param handler=handler(options, originalOptions, jqXHR) A handler to set default values for future Ajax requests. This parameter is required.
  *
  * @return undefined
  */
 ajaxPrefilter:function(dataTypes, handler){},

 /**
  * Set default values for future Ajax requests.
  * 
  * @param options A set of key/value pairs that configure the default Ajax request. All options are optional. This parameter is required.
  */
 ajaxSetup:function(options){},

 /**
  * Creates an object that handles the actual transmission of Ajax data.
  * 
  * @param dataType A string identifying the data type to use This parameter is required.
  * @param handler=handler(options, originalOptions, jqXHR) A handler to return the new transport object to use with the data type provided in the first argument. This parameter is required.
  *
  * @return undefined
  */
 ajaxTransport:function(dataType, handler){},

 /**
  * Check to see if a DOM element is a descendant of another DOM element.
  * 
  * @param container The DOM element that may contain the other element. This parameter is required.
  * @param contained The DOM element that may be contained by (a descendant of) the other element. This parameter is required.
  *
  * @return Boolean
  */
 contains:function(container, contained){},

 /**
  * Store arbitrary data associated with the specified element. Returns the value that was set.
  * 
  * @param element The DOM element to associate with the data. This parameter is required.
  * @param key A string naming the piece of data to set. This parameter is required.
  * @param value The new data value. This parameter is required.
  *
  * @return Object
  */
 data:function(element, key, value){},

 /**
  * Returns value at named data store for the element, as set by jQuery.data(element, name, value), or the full data store for the element.
  * 
  * @param element The DOM element to query for the data. This parameter is required.
  * @param key Name of the data stored. This parameter is required.
  *
  * @return Object
  */
 data__variant__oxygen__2:function(element, key){},

 /**
  * Returns value at named data store for the element, as set by jQuery.data(element, name, value), or the full data store for the element.
  * 
  * @param element The DOM element to query for the data. This parameter is required.
  *
  * @return Object
  */
 data__variant__oxygen__3:function(element){},

 /**
  * Execute the next function on the queue for the matched element.
  * 
  * @param element A DOM element from which to remove and execute a queued function. This parameter is required.
  * @param queueName A string containing the name of the queue. Defaults to fx, the standard effects queue. This parameter is optional.
  *
  * @return undefined
  */
 dequeue:function(element, queueName){},

 /**
  * A generic iterator function, which can be used to seamlessly iterate over both objects and arrays. Arrays and array-like objects with a length property (such as a function's arguments object) are iterated by numeric index, from 0 to length-1. Other objects are iterated via their named properties.
  * 
  * @param collection The object or array to iterate over. This parameter is required.
  * @param callback=callback(indexInArray, valueOfElement) The function that will be executed on every object. This parameter is required.
  *
  * @return Object
  */
 each:function(collection, callback){},

 /**
  * Takes a string and throws an exception containing it.
  * 
  * @param message The message to send out. This parameter is required.
  */
 error:function(message){},

 /**
  * Merge the contents of two or more objects together into the first object.
  * 
  * @param target An object that will receive the new properties if additional objects are passed in or that will extend the jQuery namespace if it is the sole argument. This parameter is required.
  * @param object1 An object containing additional properties to merge in. This parameter is optional.
  * @param objectN Additional objects containing properties to merge in. This parameter is optional.
  *
  * @return Object
  */
 extend:function(target, object1, objectN){},

 /**
  * Merge the contents of two or more objects together into the first object.
  * 
  * @param deep If true, the merge becomes recursive (aka. deep copy). This parameter is optional.
  * @param target The object to extend. It will receive the new properties. This parameter is required.
  * @param object1 An object containing additional properties to merge in. This parameter is required.
  * @param objectN Additional objects containing properties to merge in. This parameter is optional.
  *
  * @return Object
  */
 extend__variant__oxygen__2:function(deep, target, object1, objectN){},

 /**
  * Load data from the server using a HTTP GET request.
  * 
  * @param url A string containing the URL to which the request is sent. This parameter is required.
  * @param data A plain object or string that is sent to the server with the request. This parameter is optional.
  * @param success=success(data, textStatus, jqXHR) A callback function that is executed if the request succeeds. This parameter is optional.
  * @param dataType The type of data expected from the server. Default: Intelligent Guess (xml, json, script, or html). This parameter is optional.
  *
  * @return jqXHR
  */
 get:function(url, data, success, dataType){},

 /**
  * Load JSON-encoded data from the server using a GET HTTP request.
  * 
  * @param url A string containing the URL to which the request is sent. This parameter is required.
  * @param data A plain object or string that is sent to the server with the request. This parameter is optional.
  * @param success=success(data, textStatus, jqXHR) A callback function that is executed if the request succeeds. This parameter is optional.
  *
  * @return jqXHR
  */
 getJSON:function(url, data, success){},

 /**
  * Load a JavaScript file from the server using a GET HTTP request, then execute it.
  * 
  * @param url A string containing the URL to which the request is sent. This parameter is required.
  * @param success=success(script, textStatus, jqXHR) A callback function that is executed if the request succeeds. This parameter is optional.
  *
  * @return jqXHR
  */
 getScript:function(url, success){},

 /**
  * Execute some JavaScript code globally.
  * 
  * @param code The JavaScript code to execute. This parameter is required.
  */
 globalEval:function(code){},

 /**
  * Finds the elements of an array which satisfy a filter function. The original array is not affected.
  * 
  * @param array The array to search through. This parameter is required.
  * @param func=function(elementOfArray, indexInArray) The function to process each item against. The first argument to the function is the item, and the second argument is the index. The function should return a Boolean value. this will be the global window object. This parameter is required.
  * @param invert If "invert" is false, or not provided, then the function returns an array consisting of all elements for which "callback" returns true. If "invert" is true, then the function returns an array consisting of all elements for which "callback" returns false. This parameter is optional.
  *
  * @return Array
  */
 grep:function(array, func, invert){},

 /**
  * Determine whether an element has any jQuery data associated with it.
  * 
  * @param element A DOM element to be checked for data. This parameter is required.
  *
  * @return Boolean
  */
 hasData:function(element){},

 /**
  * Holds or releases the execution of jQuery's ready event.
  * 
  * @param hold Indicates whether the ready hold is being requested or released This parameter is required.
  *
  * @return undefined
  */
 holdReady:function(hold){},

 /**
  * Search for a specified value within an array and return its index (or -1 if not found).
  * 
  * @param value The value to search for. This parameter is required.
  * @param array An array through which to search. This parameter is required.
  * @param fromIndex The index of the array at which to begin the search. The default is 0, which will search the whole array. This parameter is optional.
  *
  * @return Number
  */
 inArray:function(value, array, fromIndex){},

 /**
  * Determine whether the argument is an array.
  * 
  * @param obj Object to test whether or not it is an array. This parameter is required.
  *
  * @return boolean
  */
 isArray:function(obj){},

 /**
  * Check to see if an object is empty (contains no enumerable properties).
  * 
  * @param object The object that will be checked to see if it's empty. This parameter is required.
  *
  * @return Boolean
  */
 isEmptyObject:function(object){},

 /**
  * Determine if the argument passed is a Javascript function object.
  * 
  * @param obj Object to test whether or not it is a function. This parameter is required.
  *
  * @return boolean
  */
 isFunction:function(obj){},

 /**
  * Determines whether its argument is a number.
  * 
  * @param value The value to be tested. This parameter is required.
  *
  * @return Boolean
  */
 isNumeric:function(value){},

 /**
  * Check to see if an object is a plain object (created using "{}" or "new Object").
  * 
  * @param object The object that will be checked to see if it's a plain object. This parameter is required.
  *
  * @return Boolean
  */
 isPlainObject:function(object){},

 /**
  * Determine whether the argument is a window.
  * 
  * @param obj Object to test whether or not it is a window. This parameter is required.
  *
  * @return boolean
  */
 isWindow:function(obj){},

 /**
  * Check to see if a DOM node is within an XML document (or is an XML document).
  * 
  * @param node The DOM node that will be checked to see if it's in an XML document. This parameter is required.
  *
  * @return Boolean
  */
 isXMLDoc:function(node){},

 /**
  * Convert an array-like object into a true JavaScript array.
  * 
  * @param obj Any object to turn into a native Array. This parameter is required.
  *
  * @return Array
  */
 makeArray:function(obj){},

 /**
  * Translate all items in an array or object to new array of items.
  * 
  * @param array The Array to translate. This parameter is required.
  * @param callback=callback(elementOfArray, indexInArray) The function to process each item against. The first argument to the function is the array item, the second argument is the index in array The function can return any value. Within the function, this refers to the global (window) object. This parameter is required.
  *
  * @return Array
  */
 map:function(array, callback){},

 /**
  * Translate all items in an array or object to new array of items.
  * 
  * @param arrayOrObject The Array or Object to translate. This parameter is required.
  * @param callback=callback( value, indexOrKey ) The function to process each item against. The first argument to the function is the value; the second argument is the index or key of the array or object property. The function can return any value to add to the array. A returned array will be flattened into the resulting array. Within the function, this refers to the global (window) object. This parameter is required.
  *
  * @return Array
  */
 map__variant__oxygen__2:function(arrayOrObject, callback){},

 /**
  * Merge the contents of two arrays together into the first array.
  * 
  * @param first The first array to merge, the elements of second added. This parameter is required.
  * @param second The second array to merge into the first, unaltered. This parameter is required.
  *
  * @return Array
  */
 merge:function(first, second){},

 /**
  * Relinquish jQuery's control of the $ variable.
  * 
  * @param removeAll A Boolean indicating whether to remove all jQuery variables from the global scope (including jQuery itself). This parameter is optional.
  *
  * @return Object
  */
 noConflict:function(removeAll){},

 /**
  * An empty function.
  *
  * @return undefined
  */
 noop:function(){},

 /**
  * Return a number representing the current time.
  *
  * @return Number
  */
 now:function(){},

 /**
  * Create a serialized representation of an array or object, suitable for use in a URL query string or Ajax request.
  * 
  * @param obj An array or object to serialize. This parameter is required.
  *
  * @return String
  */
 param:function(obj){},

 /**
  * Create a serialized representation of an array or object, suitable for use in a URL query string or Ajax request.
  * 
  * @param obj An array or object to serialize. This parameter is required.
  * @param traditional A Boolean indicating whether to perform a traditional "shallow" serialization. This parameter is required.
  *
  * @return String
  */
 param__variant__oxygen__2:function(obj, traditional){},

 /**
  * Takes a well-formed JSON string and returns the resulting JavaScript object.
  * 
  * @param json The JSON string to parse. This parameter is required.
  *
  * @return Object
  */
 parseJSON:function(json){},

 /**
  * Parses a string into an XML document.
  * 
  * @param data a well-formed XML string to be parsed This parameter is required.
  *
  * @return XMLDocument
  */
 parseXML:function(data){},

 /**
  * Load data from the server using a HTTP POST request.
  * 
  * @param url A string containing the URL to which the request is sent. This parameter is required.
  * @param data A plain object or string that is sent to the server with the request. This parameter is optional.
  * @param success=success(data, textStatus, jqXHR) A callback function that is executed if the request succeeds. This parameter is optional.
  * @param dataType The type of data expected from the server. Default: Intelligent Guess (xml, json, script, text, html). This parameter is optional.
  *
  * @return jqXHR
  */
 post:function(url, data, success, dataType){},

 /**
  * Takes a function and returns a new one that will always have a particular context.
  * 
  * @param function The function whose context will be changed. This parameter is required.
  * @param context The object to which the context (this) of the function should be set. This parameter is required.
  *
  * @return Function
  */
 proxy:function(func, context){},

 /**
  * Takes a function and returns a new one that will always have a particular context.
  * 
  * @param context The object to which the context of the function should be set. This parameter is required.
  * @param name The name of the function whose context will be changed (should be a property of the context object). This parameter is required.
  *
  * @return Function
  */
 proxy__variant__oxygen__2:function(context, name){},

 /**
  * Takes a function and returns a new one that will always have a particular context.
  * 
  * @param function The function whose context will be changed. This parameter is required.
  * @param context The object to which the context (this) of the function should be set. This parameter is required.
  * @param additionalArguments Any number of arguments to be passed to the function referenced in the function argument. This parameter is optional.
  *
  * @return Function
  */
 proxy__variant__oxygen__3:function(func, context, additionalArguments){},

 /**
  * Takes a function and returns a new one that will always have a particular context.
  * 
  * @param context The object to which the context of the function should be set. This parameter is required.
  * @param name The name of the function whose context will be changed (should be a property of the context object). This parameter is required.
  * @param additionalArguments Any number of arguments to be passed to the function named in the name argument. This parameter is optional.
  *
  * @return Function
  */
 proxy__variant__oxygen__4:function(context, name, additionalArguments){},

 /**
  * Show the queue of functions to be executed on the matched element.
  * 
  * @param element A DOM element to inspect for an attached queue. This parameter is required.
  * @param queueName A string containing the name of the queue. Defaults to fx, the standard effects queue. This parameter is optional.
  *
  * @return Array
  */
 queue:function(element, queueName){},

 /**
  * Manipulate the queue of functions to be executed on the matched element.
  * 
  * @param element A DOM element where the array of queued functions is attached. This parameter is required.
  * @param queueName A string containing the name of the queue. Defaults to fx, the standard effects queue. This parameter is required.
  * @param newQueue An array of functions to replace the current queue contents. This parameter is required.
  *
  * @return jQuery
  */
 queue__variant__oxygen__2:function(element, queueName, newQueue){},

 /**
  * Manipulate the queue of functions to be executed on the matched element.
  * 
  * @param element A DOM element on which to add a queued function. This parameter is required.
  * @param queueName A string containing the name of the queue. Defaults to fx, the standard effects queue. This parameter is required.
  * @param callback=callback() The new function to add to the queue. This parameter is required.
  *
  * @return jQuery
  */
 queue__variant__oxygen__3:function(element, queueName, callback){},

 /**
  * Remove a previously-stored piece of data.
  * 
  * @param element A DOM element from which to remove data. This parameter is required.
  * @param name A string naming the piece of data to remove. This parameter is optional.
  *
  * @return jQuery
  */
 removeData:function(element, name){},

 /**
  * Creates a new copy of jQuery whose properties and methods can be modified without affecting the original jQuery object.
  *
  * @return jQuery
  */
 sub:function(){},

 /**
  * Remove the whitespace from the beginning and end of a string.
  * 
  * @param str The string to trim. This parameter is required.
  *
  * @return String
  */
 trim:function(str){},

 /**
  * Determine the internal JavaScript [[Class]] of an object.
  * 
  * @param obj Object to get the internal JavaScript [[Class]] of. This parameter is required.
  *
  * @return String
  */
 type:function(obj){},

 /**
  * Sorts an array of DOM elements, in place, with the duplicates removed. Note that this only works on arrays of DOM elements, not strings or numbers.
  * 
  * @param array The Array of DOM elements. This parameter is required.
  *
  * @return Array
  */
 unique:function(array){},

 /**
  * Provides a way to execute callback functions based on one or more objects, usually Deferred objects that represent asynchronous events.
  * 
  * @param deferreds One or more Deferred objects, or plain JavaScript objects. This parameter is required.
  *
  * @return Promise
  */
 when:function(deferreds){},

 /**
  * A constructor function that returns a chainable utility object with methods to register multiple callbacks into callback queues, invoke callback queues, and relay the success or failure state of any synchronous or asynchronous function.
  * 
  * @param beforeStart A function that is called just before the constructor returns. This parameter is optional.
  *
  * @return Deferred
  */
 Deferred:function(beforeStart){},

 /**
  * Parses a string into an array of DOM nodes.
  * 
  * @param data HTML string to be parsed This parameter is required.
  * @param context DOM element to serve as the context in which the HTML fragment will be created This parameter is optional.
  * @param keepScripts A Boolean indicating whether to include scripts passed in the HTML string This parameter is optional.
  *
  * @return Array
  */
 parseHTML:function(data, context, keepScripts){},

 /**
  * Deprecated in jQuery 1.3 (see jQuery.support). States if the current page, in the user's browser, is being rendered using the W3C CSS Box Model.
  * 
   * @return Boolean
  */
boxModel:0,

 /**
  * Contains flags for the useragent, read from navigator.userAgent. We recommend against using this property; please try to use feature detection instead (see jQuery.support). jQuery.browser may be moved to a plugin in a future release of jQuery.
  * 
   * @return PlainObject
  */
browser:0,

 /**
  * The version number of the rendering engine for the user's browser.
  * 
   * @return String
  */
version:0,

 /**
  * Hook directly into jQuery to override how particular CSS properties are retrieved or set, normalize CSS property naming, or create custom properties.
  * 
   * @return Object
  */
cssHooks:0,

 /**
  * The rate (in milliseconds) at which animations fire.
  * 
   * @return Number
  */
interval:0,

 /**
  * Globally disable all animations.
  * 
   * @return Boolean
  */
off:0,

 /**
  * A collection of properties that represent the presence of different browser features or bugs. Primarily intended for jQuery's internal use; specific properties may be removed when they are no longer needed internally to improve page startup performance.
  * 
   * @return Object
  */
support:0
}

