<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="2.0" xmlns:iso="http://purl.oclc.org/dsdl/schematron"
  xmlns:sqf="http://www.schematron-quickfix.com/validator/process">
  
  <!-- Import the iso schematron abstract -->
  <xsl:import href="iso-schematron-abstract.xsl"/>
  
   <!-- Key used to identify the global quick fixes ids -->
   <xsl:key name="globalQuickFixes" match="sqf:fixes/sqf:fix|sqf:fixes/sqf:group/sqf:fix" use="@id"/>
   <xsl:key name="globalQuickFixesGroup" match="sqf:fixes/sqf:group" use="@id"/>
  
  <!-- Do not copy the abstract quick fixes. -->
  <xsl:template match="sqf:fixes/sqf:fix[sqf:param[@abstract='true']]"/>
  <xsl:template match="sqf:fixes/sqf:group[sqf:fix/sqf:param[@abstract='true']]"/>
  
  <xsl:template match="iso:assert[@sqf:fix] | iso:report[@sqf:fix]" mode="instantiate">
    <xsl:param name="params"/>
    <xsl:copy>
      <xsl:apply-templates select="node() | @*" mode="instantiate">
        <xsl:with-param name="params" select="$params"/>
      </xsl:apply-templates>
    </xsl:copy>
    
    <!-- Get only the distinct values of the quick fix ids -->
    <xsl:variable name="quickFixIds" select="distinct-values(tokenize(@sqf:fix, ' '))"/>
    <!-- Process the quick fixes -->
    <xsl:variable name="ruleNode" select="current()/parent::node()"/>
    <xsl:variable name="root" select="root(current())"/>
    
    
    <xsl:for-each select="$quickFixIds">
      <!-- If the quick fix is not defined locally, then search for a global one  -->
      <xsl:if test="count($ruleNode/sqf:fix[@id=current()]) = 0">
        <!-- Copy the the global quick fix in the current abstract pattern-->
        <xsl:variable name="fixNode" select="key('globalQuickFixes', current(), $root)"/>
        <!-- Get only the first fix match -->
        <xsl:if test="count($fixNode) > 0">
          <!-- Generate the quick-fix -->
          <xsl:apply-templates select="$fixNode[1]" mode="instantiate">
            <xsl:with-param name="params" select="$params"/>
          </xsl:apply-templates>
        </xsl:if>
        
        <!-- Copy the the global quick fix group in the current abstract pattern-->
        <xsl:variable name="groupNode" select="key('globalQuickFixesGroup', current(), $root)"/>
        <!--  Get only the first fix match -->
        <xsl:if test="count($groupNode) > 0">
          <!-- Generate the quick-fix -->
          <xsl:apply-templates select="$groupNode[1]" mode="instantiate">
            <xsl:with-param name="params" select="$params"/>
          </xsl:apply-templates>
        </xsl:if>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>
  
</xsl:stylesheet>
