<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    exclude-result-prefixes="xs s util"
    xmlns:s="http://www.oxygenxml.com/ns/framework/extend"
    xmlns:util="http://www.oxygenxml.com/ns/framework/extend/util"
    version="2.0">
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Updates transformation and validation scenarios.</xd:p>
        </xd:desc>
    </xd:doc>
    
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Base framework context. Framework validation scenario updater.</xd:p>
            <xd:pre>
      <validationScenarios>
        <addScenarios  href="validation_scenarios.xml"/>
        <removeScenario name="Accessibility"/>
        <defaultScenarios>
            <name>DITA-NEW</name>
        </defaultScenarios>
      </validationScenarios>  
            </xd:pre>
        </xd:desc>
    </xd:doc>
    <xsl:template match="documentTypeDescriptor/field[@name='validationScenarios']/validationScenario-array" mode="copy-target">
        <xsl:call-template name="updateScenarios">
            <xsl:with-param name="scriptScenariosElement" select="$script/s:validationScenarios"/>
        </xsl:call-template>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Base framework context. Framework transformation scenario updater.</xd:p>
            <xd:pre>
      <transformationScenarios>
        <addScenarios  href="transformation_scenarios.xml"/>
        <removeScenario name="Accessibility"/>
        <defaultScenarios>
            <name>DITA-NEW</name>
        </defaultScenarios>
     </transformationScenarios>  
            </xd:pre>
        </xd:desc>
    </xd:doc>
    <xsl:template match="documentTypeDescriptor/field[@name='scenarios']/scenario-array" mode="copy-target">
        <xsl:call-template name="updateScenarios">
            <xsl:with-param name="scriptScenariosElement" select="$script/s:transformationScenarios"/>
        </xsl:call-template>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Updates the validation or transformation scenarios. Executed operations: insert, delete</xd:p>
        </xd:desc>
        <xd:param name="scriptScenariosElement">The element from the script that contains all the operations.
            Either <xd:i>transformationScenarios</xd:i> or <xd:i>transformationScenario</xd:i>.
        </xd:param>
    </xd:doc>
    <xsl:template name="updateScenarios">
        <xsl:param name="scriptScenariosElement"/>
        <xsl:copy>
            <xsl:if test="not($scriptScenariosElement/@inherit) or $scriptScenariosElement/@inherit = 'all'">
                <xsl:variable name="skippedScenarios" select="$scriptScenariosElement/s:removeScenario/xs:string(@name)"/>
                <xsl:apply-templates mode="copy-target" select="*[not(util:isSkippedEntry(field[@name='name']/String/text(), $skippedScenarios))]"/>
            </xsl:if>
            
            <!-- Load external validation scenarios file. -->
            <xsl:if test="$scriptScenariosElement/s:addScenarios/@href">
                <xsl:variable name="path" select="$scriptScenariosElement/s:addScenarios/@href"/>
                
                <xsl:variable name="step1" select="replace($path, '\$\{framework\}', resolve-uri('.', $scriptURL))"/>
                <!-- We need an URL here so we will expand frameworkDir to an URL as well. -->
                <xsl:variable name="step2" select="replace($step1, '\$\{frameworkDir\}', resolve-uri('.', $scriptURL))"/>
                
                <xsl:variable 
                    name="newScenarios" 
                    select="doc(resolve-uri($step2, base-uri($script)))/serialized/serializableOrderedMap/entry/(validationScenario-array,scenario-array)/*"/>
                
                <!-- Append new scenarios. -->
                <xsl:for-each select="$newScenarios">
                    <xsl:apply-templates mode="copy-pristine" select="."/>
                </xsl:for-each>
            </xsl:if>
        </xsl:copy>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Updates default validation scenarios.</xd:p>
            <xd:pre>
     <field name="defaultValidationScenarios">
      <list>
       <String>DITA</String>
      </list>
     </field>
            </xd:pre>
        </xd:desc>
    </xd:doc>
    <xsl:template match="documentTypeDescriptor/field[@name='defaultValidationScenarios']" mode="copy-target">
        <xsl:call-template name="copyDefaultScenarios">
            <xsl:with-param name="defaults" select="$script/s:validationScenarios/s:defaultScenarios/s:name/text()"/>
        </xsl:call-template>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Updates default validation scenarios.</xd:p>
            <xd:pre>
     <field name="defaultTransformationScenarios">
      <list>
       <String>DITA</String>
      </list>
     </field>
            </xd:pre>
        </xd:desc>
    </xd:doc>
    <xsl:template match="documentTypeDescriptor/field[@name='defaultTransformationScenarios']" mode="copy-target">
        <xsl:call-template name="copyDefaultScenarios">
            <xsl:with-param name="defaults" select="$script/s:transformationScenarios/s:defaultScenarios/s:name/text()"/>
        </xsl:call-template>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Updates default scenarios.</xd:p>
        </xd:desc>
        <xd:param name="defaults">The new default scenarios names.</xd:param>
    </xd:doc>
    <xsl:template name="copyDefaultScenarios">
        <xsl:param name="defaults"/>
        
        <xsl:copy>
            <xsl:apply-templates select="@*" mode="#current"/>
            <xsl:choose>
                <xsl:when test="$defaults">
                    <!-- We have defaults. -->
                    <list>
                        <xsl:for-each select="$defaults">
                            <xsl:sequence select="util:stringValue(.)"></xsl:sequence>
                        </xsl:for-each>
                    </list> 
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="node()" mode="#current"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:copy>
    </xsl:template>
</xsl:stylesheet>