<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    exclude-result-prefixes="xs util s"
    xmlns:util="http://www.oxygenxml.com/ns/framework/extend/util"
    xmlns:actions="http://www.oxygenxml.com/ns/framework/extend/actions"
    xmlns:s="http://www.oxygenxml.com/ns/framework/extend"
    version="3.0">
    
    <xsl:template match="authorExtension/field/action-array"
        mode="copy-target">
        <!-- Actions defined in the extension framework. -->
        <xsl:param name="frameworkOwnActions" tunnel="yes"/>
        <!-- Actions from the base framework marked in the script as to be removed.-->
        <xsl:variable 
            name="skippedActions" 
            select="$script/s:author/s:authorActions/s:removeAction/xs:string(@id)"/>
        
        <xsl:variable name="all" select="$skippedActions, $frameworkOwnActions"/>
        <xsl:copy>
            <xsl:apply-templates 
                select="@* | text() | action[empty(index-of($all, field[@name='id']/String/text()))]" 
                mode="#current"/>
        </xsl:copy>
        

    </xsl:template>
    
</xsl:stylesheet>