<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    exclude-result-prefixes="xs s util"
    xmlns:s="http://www.oxygenxml.com/ns/framework/extend"
    xmlns:util="http://www.oxygenxml.com/ns/framework/extend/util"
    version="3.0">
    
    <xsl:output method="xml" exclude-result-prefixes="xs s util"></xsl:output>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>The URL pointing to the framework creation script.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:param name="scriptURL" as="xs:string"/>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>The URL pointing the the base framework *.framerwork file. Will be used if the script 
                specifies a base framework.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:param name="baseFrameworkURL" as="xs:string"/>
    
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>The framework creation script root element. </xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:variable name="script" select="doc($scriptURL)/s:script"/>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>The name of the base framework.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:variable name="baseFrameworkName" 
        select="if($script/@base and string-length($script/@base)) then $script/@base else 'Pristine'"/>
    
    <xsl:include href="module/utility.xsl"/>
    <xsl:include href="module/basic.xsl"/>
    <xsl:include href="module/associations.xsl"/>
    <xsl:include href="module/author-extensions-css.xsl"/>
    <xsl:include href="module/author-extensions-toolbar.xsl"/>
    <xsl:include href="module/author-extensions-cc.xsl"/>
    <xsl:include href="module/author-extensions-menu.xsl"/>
    <xsl:include href="module/copy-templates.xsl"/>
    <xsl:include href="module/scenarios.xsl"/>
    <xsl:include href="module/author-actions.xsl"/>
    
    <xsl:template name="main">
        <xsl:variable name="input" select="
            if($script/@base and string-length($script/@base)) then doc($baseFrameworkURL) else doc('pristine.framework')"/>
        <xsl:apply-templates select="$input" mode="copy-generic"/>
    </xsl:template>
    
    <xsl:template match="text()"></xsl:template>
    
</xsl:stylesheet>