<?xml version="1.0" encoding="UTF-8"?>
<!-- 
  Copyright 2001-2011 Syncro Soft SRL. All rights reserved.
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0"
    xmlns:func="http://www.oxygenxml.com/xsdDoc/functions"
    xmlns:util="http://www.jclark.com/xt/java/ro.sync.util.TextUtil">
    <xsl:output method="text" encoding="Cp1252"/>

    <xsl:variable name="schemaTypeLabels">
        <entry key="main">Main schema</entry>
        <entry key="included">Included schema</entry>
        <entry key="imported">Imported schema</entry>
    </xsl:variable>

    <xsl:variable name="tokenColor">
        <entry key="tokenElement">5</entry>
        <entry key="tokenAttrName">6</entry>
        <entry key="tokenAttrValue">7</entry>
        <entry key="tokenText">0</entry>
        <entry key="tokenComment">8</entry>
        <entry key="tokenCDATA">9</entry>
        <entry key="tokenPI">10</entry>
        <entry key="tokenEntity">11</entry>
    </xsl:variable>

    <xsl:variable name="componentsIndex">
        <xsl:for-each select="/schemaDoc/node()[@id]">
            <xsl:element name="entry">
                <xsl:attribute name="key" select="@id"/>
                <xsl:attribute name="value" select="position()"/>
            </xsl:element>
        </xsl:for-each>
    </xsl:variable>

    <xsl:variable name="componentsListsNumbers">
        <xsl:for-each select="/schemaDoc/node()[@id]">
            <xsl:if test="exists(typeHierarchy)">
                <xsl:element name="entry">
                    <xsl:attribute name="key"
                        select="func:getListName(@id, local-name(typeHierarchy))"/>
                    <xsl:attribute name="value" select="5 * position()"/>
                </xsl:element>
            </xsl:if>
            <xsl:if test="exists(./usedBy)">
                <xsl:element name="entry">
                    <xsl:attribute name="key" select="func:getListName(@id, local-name(usedBy))"/>
                    <xsl:attribute name="value" select="5 * position() + 1"/>
                </xsl:element>
            </xsl:if>
            <xsl:if test="exists(./substitutionGroup)">
                <xsl:element name="entry">
                    <xsl:attribute name="key"
                        select="func:getListName(@id, local-name(substitutionGroup))"/>
                    <xsl:attribute name="value" select="5 * position() + 2"/>
                </xsl:element>
            </xsl:if>
            <xsl:if test="exists(./substitutionGroupAffiliation)">
                <xsl:element name="entry">
                    <xsl:attribute name="key"
                        select="func:getListName(@id, local-name(substitutionGroupAffiliation))"/>
                    <xsl:attribute name="value" select="5 * position() + 3"/>
                </xsl:element>
            </xsl:if>
            <xsl:if test="exists(annotations)">
                <xsl:element name="entry">
                    <xsl:attribute name="key"
                        select="func:getListName(@id, local-name(annotations))"/>
                    <xsl:attribute name="value" select="5 * position() + 4"/>
                </xsl:element>
            </xsl:if>
        </xsl:for-each>
    </xsl:variable>

    <xsl:function name="func:getListName">
        <xsl:param name="componentId"/>
        <xsl:param name="propertyName"/>
        <xsl:value-of select="concat($componentId, '_', $propertyName)"/>
    </xsl:function>

    <xsl:variable name="componentTypeLabels">
        <entry key="Element">Element</entry>
        <entry key="Attribute">Attribute</entry>
        <entry key="Complex_Type">Complex Type</entry>
        <entry key="Element_Group">Element Group</entry>
        <entry key="Attribute_Group">Attribute Group</entry>
        <entry key="Simple_Type">Simple Type</entry>
        <entry key="Schema">Schema</entry>
    </xsl:variable>

    <xsl:template name="generateList">
        <xsl:param name="id"/>
        <xsl:text>{\list \listemplateid</xsl:text>
        <xsl:value-of select="$id"/>
        <xsl:text>{\listlevel \levelnfcn0 \leveljcn0 \levelfollow1 \levelstartat1{\leveltext \'01 ;}{\levelnumbers ;}}</xsl:text>
        <xsl:text>{\listlevel \levelnfcn0 \leveljcn0 \levelfollow1 \levelstartat1{\leveltext \'04    ;}{\levelnumbers ;}}</xsl:text>
        <xsl:text>{\listlevel \levelnfcn0 \leveljcn0 \levelfollow1 \levelstartat1{\leveltext \'09       \u-3913  ;}{\levelnumbers ;}\f3}</xsl:text>
        <xsl:text>\listrestarthdn0 \listid</xsl:text>
        <xsl:value-of select="$id"/>
        <xsl:text>{\listname ;}}</xsl:text>
    </xsl:template>

    <xsl:template name="generateListOverride">
        <xsl:param name="id"/>
        <xsl:text>{\listoverride\listid</xsl:text>
        <xsl:value-of select="$id"/>
        <xsl:text>\ls</xsl:text>
        <xsl:value-of select="$id"/>
        <xsl:text>}</xsl:text>
    </xsl:template>

    <xsl:template name="pageFormat">
        <xsl:text>\paperw11906\paperh16838\margl720\margr720\margt720\margb720\gutter0</xsl:text>
    </xsl:template>

    <xsl:template name="rowDeclaration">
        <!-- trql           Centers a table row with respect to its containing column -->
        <!-- trbrdrh    Table row border horizontal (inside). -->
        <!-- trbrdrv    Table row border vertical (inside). -->
        <!-- \brdrs      Single-thickness border. -->
        <!-- brdrcf     Color of the border -->
        <!-- \clwWidthN Cell width -->
        <!-- \clftsWidth2 Percentage -->
        <xsl:text>\trowd\trftsWidth2\trwWidth5000\trql\trgaph10</xsl:text>
        <xsl:text>\trbrdrh\brdrs\brdrw20\brdrcf0</xsl:text>
        <xsl:text>\trbrdrb\brdrs\brdrw20\brdrcf0</xsl:text>
        <xsl:text>\trbrdrv\brdrs\brdrw20\brdrcf0</xsl:text>
        <xsl:text>\trbrdrr\brdrs\brdrw20\brdrcf0</xsl:text>
        <xsl:text>\trbrdrt\brdrs\brdrw20\brdrcf0</xsl:text>
        <xsl:text>\trbrdrl\brdrs\brdrw20\brdrcf0</xsl:text>
        <!-- Padding for the cell -->
        <xsl:text>\trpaddl80\trpaddr0\trpaddfl3\trpaddfr3</xsl:text>
        <xsl:text>\clbrdrb\brdrs\brdrw10\brdrcf0</xsl:text>
        <xsl:text>\clbrdrr\brdrs\brdrw10\brdrcf0</xsl:text>
        <xsl:text>\clbrdrt\brdrs\brdrw10\brdrcf0</xsl:text>
        <xsl:text>\clbrdrl\brdrs\brdrw10\brdrcf0</xsl:text>
        <!-- Background color of the first cell -->
        <xsl:text>\clcbpat3</xsl:text>
        <xsl:text>\clftsWidth2\clwWidth1000\cellx2186</xsl:text>
        <xsl:text>\clbrdrb\brdrs\brdrw10\brdrcf0</xsl:text>
        <xsl:text>\clbrdrr\brdrs\brdrw10\brdrcf0</xsl:text>
        <xsl:text>\clbrdrt\brdrs\brdrw10\brdrcf0</xsl:text>
        <xsl:text>\clbrdrl\brdrs\brdrw10\brdrcf0</xsl:text>
        <xsl:text>\clcbpat4</xsl:text>
        <xsl:text>\clftsWidth2\clwWidth4000\cellx8372</xsl:text>
    </xsl:template>

    <xsl:template name="startRow">
        <!-- trftsWidth3 : twips -->
        <!-- \trgaphN	Half the space between the cells of a table row in twips. -->
        <!-- \brdrwN	N is the width in twips of the pen used to draw the paragraph border line. N cannot be greater than 255. To obtain a larger border width, the \brdrth control word can be used to obtain a width double that of N. -->
        <xsl:text>\pard</xsl:text>
        <xsl:call-template name="rowDeclaration"/>
    </xsl:template>

    <xsl:template name="endRow">
        <xsl:call-template name="rowDeclaration"/>
        <xsl:text>\row</xsl:text>
    </xsl:template>

    <xsl:template name="startCell">
        <xsl:text>\pard\plain\intbl </xsl:text>
    </xsl:template>

    <xsl:template name="endCell">
        <xsl:text>\cell</xsl:text>
    </xsl:template>

    <xsl:template name="nestCell">
        <xsl:text>\nestcell </xsl:text>
    </xsl:template>

    <xsl:template name="nestRowDefinition">
        <xsl:text>{\*\nesttableprops\trowd\trautofit1\trftsWidth1</xsl:text>
        <xsl:text>\clcbpat3</xsl:text>
        <xsl:text>\clftsWidth1\clwWidth2500\cellx3000</xsl:text>
        <xsl:text>\clftsWidth1\clwWidth2500\cellx6000</xsl:text>
        <xsl:text>\nestrow}</xsl:text>
    </xsl:template>

    <xsl:template name="nestRowDefinitionAttrs">
        <xsl:param name="index">0</xsl:param>
        <xsl:text>{\*\nesttableprops\trowd\trftsWidth2\trwWidth5000</xsl:text>
        <xsl:text>\clcbpat3</xsl:text>
        <xsl:text>\clftsWidth2\clwWidth833\cellx1000</xsl:text>
        <xsl:if test="$index = 1">
            <xsl:text>\clcbpat3</xsl:text>
        </xsl:if>
        <xsl:text>\clftsWidth2\clwWidth833\cellx2000</xsl:text>
        <xsl:if test="$index = 1">
            <xsl:text>\clcbpat3</xsl:text>
        </xsl:if>
        <xsl:text>\clftsWidth2\clwWidth833\cellx3000</xsl:text>
        <xsl:if test="$index = 1">
            <xsl:text>\clcbpat3</xsl:text>
        </xsl:if>
        <xsl:text>\clftsWidth2\clwWidth833\cellx4000</xsl:text>
        <xsl:if test="$index = 1">
            <xsl:text>\clcbpat3</xsl:text>
        </xsl:if>
        <xsl:text>\clftsWidth2\clwWidth833\cellx5000</xsl:text>
        <xsl:if test="$index = 1">
            <xsl:text>\clcbpat3</xsl:text>
        </xsl:if>
        <xsl:text>\clftsWidth2\clwWidth833\cellx6000</xsl:text>
        <xsl:text>\nestrow}</xsl:text>
    </xsl:template>

    <xsl:template name="nestRowDefinitionChildren">
        <xsl:param name="index">0</xsl:param>
        <xsl:text>{\*\nesttableprops\trowd\trftsWidth2\trwWidth5000</xsl:text>
        <xsl:text>\clcbpat3</xsl:text>
        <xsl:text>\clftsWidth2\clwWidth1650\cellx2000</xsl:text>
        <xsl:if test="$index = 1">
            <xsl:text>\clcbpat3</xsl:text>
        </xsl:if>
        <xsl:text>\clftsWidth2\clwWidth1650\cellx4000</xsl:text>
        <xsl:if test="$index = 1">
            <xsl:text>\clcbpat3</xsl:text>
        </xsl:if>
        <xsl:text>\clftsWidth2\clwWidth1650\cellx6000</xsl:text>
        <xsl:text>\nestrow}</xsl:text>
    </xsl:template>

    <xsl:template name="nestRowDefinitionConstraints">
        <xsl:param name="index">0</xsl:param>
        <xsl:text>{\*\nesttableprops\trowd\trftsWidth2\trwWidth5000</xsl:text>
        <xsl:text>\clcbpat3</xsl:text>
        <xsl:text>\clftsWidth2\clwWidth1000\cellx1250</xsl:text>
        <xsl:if test="$index = 1">
            <xsl:text>\clcbpat3</xsl:text>
        </xsl:if>
        <xsl:text>\clftsWidth2\clwWidth1000\cellx2500</xsl:text>
        <xsl:if test="$index = 1">
            <xsl:text>\clcbpat3</xsl:text>
        </xsl:if>
        <xsl:text>\clftsWidth2\clwWidth1000\cellx3750</xsl:text>
        <xsl:if test="$index = 1">
            <xsl:text>\clcbpat3</xsl:text>
        </xsl:if>
        <xsl:text>\clftsWidth2\clwWidth1000\cellx5000</xsl:text>
        <xsl:if test="$index = 1">
            <xsl:text>\clcbpat3</xsl:text>
        </xsl:if>
        <xsl:text>\clftsWidth2\clwWidth1000\cellx6000</xsl:text>
        <xsl:text>\nestrow}</xsl:text>
    </xsl:template>

    <xsl:template match="schemaDoc">
        <xsl:text>{\rtf1\ansi\ansicpg1252\uc0\deff0 </xsl:text>
        <!-- Font Table -->
        <xsl:text>{\fonttbl{\f0\fbidi \froman\fcharset238\fprq2{\*\panose 02020603050405020304}Times New Roman;}</xsl:text>
        <xsl:text>{\f2\fbidi \fmodern\fcharset238\fprq1{\*\panose 02070309020205020404}Courier New;}</xsl:text>
        <xsl:text>{\f3\fbidi \froman\fcharset2\fprq2{\*\panose 05050102010706020507}Symbol;}</xsl:text>
        <xsl:text>}</xsl:text>
        <!-- Color Table -->
        <xsl:text>{\colortbl\red0\green0\blue0;\red255\green255\blue255;\red0\green0\blue255;\red225\green225\blue225;\red250\green250\blue250;</xsl:text>
        <!-- element 5 -->
        <xsl:text>\red0\green0\blue150;</xsl:text>
        <!-- attr name 6 -->
        <xsl:text>\red245\green132\blue76;</xsl:text>
        <!-- attr value 7 -->
        <xsl:text>\red153\green51\blue0;</xsl:text>
        <!-- comment 8 -->
        <xsl:text>\red0\green100\blue0;</xsl:text>
        <!-- CDATA 9 -->
        <xsl:text>\red0\green140\blue0;</xsl:text>
        <!-- pi 10 -->
        <xsl:text>\red139\green38\blue201;</xsl:text>
        <!-- entity 11 -->
        <xsl:text>\red150\green150\blue0;</xsl:text>
        <xsl:text>}</xsl:text>
        <xsl:text>{\stylesheet </xsl:text>
        <xsl:text>{\style\s0 \ql\fi0\li0\ri0\f2\fs24\cf0 Normal;}</xsl:text>
        <xsl:text>{\style\s3 \ql\fi0\li0\ri0\f2\fs26\b\cf0 heading 3;}</xsl:text>
        <xsl:text>{\style\s2 \ql\fi0\li0\ri0\f2\fs28\b\i\cf0 heading 2;}</xsl:text>
        <xsl:text>{\style\s1 \ql\fi0\li0\ri0\f2\fs32\b\cf0 heading 1;}</xsl:text>
        <xsl:text>}</xsl:text>
        <!-- Generate listtable  and listtableoverride -->
        <xsl:text>{\*\listtable </xsl:text>
        <!-- INDEX -->
        <xsl:call-template name="generateList">
            <xsl:with-param name="id">1</xsl:with-param>
        </xsl:call-template>
        <!-- Other list used for the properties of the components -->
        <xsl:for-each select="$componentsListsNumbers/*">
            <xsl:call-template name="generateList">
                <xsl:with-param name="id" select="@value"/>
            </xsl:call-template>
        </xsl:for-each>
        <xsl:text>}</xsl:text>
        <xsl:text>{\listoverridetable</xsl:text>
        <!-- INDEX -->
        <xsl:call-template name="generateListOverride">
            <xsl:with-param name="id">1</xsl:with-param>
        </xsl:call-template>
        <!-- Other list used for the properties of the components -->
        <xsl:for-each select="$componentsListsNumbers/*">
            <xsl:call-template name="generateListOverride">
                <xsl:with-param name="id" select="@value"/>
            </xsl:call-template>
        </xsl:for-each>
        <xsl:text>}</xsl:text>
        <xsl:call-template name="pageFormat"/>
        <xsl:apply-templates/>
        <xsl:text>}</xsl:text>
    </xsl:template>

    <xsl:template name="reference">
        <xsl:param name="ref" select="."/>
        <xsl:choose>
            <xsl:when test="exists($ref/@refId)">
                <xsl:text>{\field{\*\fldinst HYPERLINK \\l "</xsl:text>
                <xsl:value-of select="$componentsIndex/entry[@key = $ref/@refId]/@value"/>
                <xsl:text>" \\o "</xsl:text>
                <xsl:choose>
                    <xsl:when test="compare('', $ref/@ns) = 0">
                        <xsl:text>No namespace</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="util:escapeRTFControlChars($ref/@ns)"/>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:text>"}{\fldrslt {\cf2</xsl:text>
                <xsl:value-of select="util:escapeRTFControlChars($ref/text())"/>
                <xsl:text>}}}</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="util:escapeRTFControlChars(normalize-space($ref/text()))"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="listEntry">
        <xsl:param name="level" select="0"/>
        <xsl:param name="index" select="0" as="xs:integer"
            xmlns:xs="http://www.w3.org/2001/XMLSchema"/>
        <xsl:param name="intbl" as="xs:boolean" xmlns:xs="http://www.w3.org/2001/XMLSchema"
            >true</xsl:param>
        <xsl:param name="listName"/>
        <xsl:if test="$index != 1">
            <xsl:text>\par</xsl:text>
        </xsl:if>
        <xsl:text>\pard</xsl:text>
        <xsl:if test="$intbl">
            <xsl:text>\intbl</xsl:text>
        </xsl:if>
        <xsl:text>\ilvl</xsl:text>
        <xsl:value-of select="$level"/>
        <xsl:text>\ls</xsl:text>
        <xsl:value-of select="$listName"/>
    </xsl:template>

    <xsl:template match="index">
        <xsl:text>\pard\par{\*\bkmkstart </xsl:text>
        <xsl:text>_top</xsl:text>
        <xsl:text>}</xsl:text>
        <xsl:text>\b Index\b0\par</xsl:text>
        <xsl:text>{\*\bkmkend </xsl:text>
        <xsl:text>_top</xsl:text>
        <xsl:text>}</xsl:text>
        <!-- Generate links grouped by the namespace of the component-->
        <xsl:if test="contains(@groupBy, 'namespace')">
            <xsl:variable name="boxId">groupByNs</xsl:variable>
            <xsl:call-template name="listEntry">
                <xsl:with-param name="level">0</xsl:with-param>
                <xsl:with-param name="listName">1</xsl:with-param>
                <xsl:with-param name="intbl">false</xsl:with-param>
            </xsl:call-template>
            <xsl:text>\b Group by Namespace\b0</xsl:text>
            <xsl:for-each-group select="ref" group-by="@ns">
                <xsl:variable name="ns">
                    <xsl:choose>
                        <xsl:when test="compare('', @ns) = 0">
                            <xsl:text>No namespace</xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="util:escapeRTFControlChars(@ns)"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                <xsl:call-template name="listEntry">
                    <xsl:with-param name="level">1</xsl:with-param>
                    <xsl:with-param name="listName">1</xsl:with-param>
                    <xsl:with-param name="intbl">false</xsl:with-param>
                </xsl:call-template>
                <xsl:text>\b </xsl:text>
                <xsl:value-of select="$ns"/>
                <xsl:text>\b0</xsl:text>

                <xsl:for-each select="current-group()">
                    <xsl:call-template name="listEntry">
                        <xsl:with-param name="level">2</xsl:with-param>
                        <xsl:with-param name="listName">1</xsl:with-param>
                        <xsl:with-param name="intbl">false</xsl:with-param>
                    </xsl:call-template>
                    <xsl:call-template name="reference"/>
                </xsl:for-each>
            </xsl:for-each-group>
        </xsl:if>

        <!-- Generate links grouped by the type of the component-->
        <xsl:if test="contains(@groupBy, 'component')">
            <xsl:call-template name="listEntry">
                <xsl:with-param name="level">0</xsl:with-param>
                <xsl:with-param name="listName">1</xsl:with-param>
                <xsl:with-param name="intbl">false</xsl:with-param>
            </xsl:call-template>
            <xsl:text>\b Group by Component Type \b0</xsl:text>
            <xsl:for-each-group select="ref" group-by="@refType">
                <xsl:variable name="refType" select="@refType"/>
                <xsl:variable name="currentComponent" select="."/>
                <xsl:call-template name="listEntry">
                    <xsl:with-param name="level">1</xsl:with-param>
                    <xsl:with-param name="listName">1</xsl:with-param>
                    <xsl:with-param name="intbl">false</xsl:with-param>
                </xsl:call-template>
                <xsl:text>\b </xsl:text>
                <xsl:value-of select="$componentTypeLabels/*[@key=$currentComponent/@refType]"/>
                <xsl:text>\b0</xsl:text>
                <xsl:for-each select="current-group()">
                    <xsl:call-template name="listEntry">
                        <xsl:with-param name="level">2</xsl:with-param>
                        <xsl:with-param name="listName">1</xsl:with-param>
                        <xsl:with-param name="intbl">false</xsl:with-param>
                    </xsl:call-template>
                    <xsl:call-template name="reference"/>
                </xsl:for-each>
            </xsl:for-each-group>
        </xsl:if>
        <xsl:text>\par\pard</xsl:text>
    </xsl:template>

    <xsl:template name="component">
        <xsl:param name="type"/>
        <xsl:variable name="id" select="@id"/>
        <!-- Create link to index -->
        <xsl:text>\pard\par{\field{\*\fldinst HYPERLINK \\l "_top" \\o "Go to top"}{\fldrslt \cf2Go to Index}}</xsl:text>
        <!-- Create the title with the bookmark -->
        <xsl:text>\pard\par{\*\bkmkstart </xsl:text>
        <xsl:value-of select="$componentsIndex/entry[@key = $id]/@value"/>
        <xsl:text>}</xsl:text>
        <xsl:value-of select="$type"/>
        <xsl:text> {\cf6 </xsl:text>
        <xsl:value-of select="util:escapeRTFControlChars(qname/text())"/>
        <xsl:text>}</xsl:text>
        <xsl:text>{\*\bkmkend </xsl:text>
        <xsl:value-of select="$componentsIndex/entry[@key = $id]/@value"/>
        <xsl:text>}</xsl:text>
        <xsl:text>\par\pard</xsl:text>
        <xsl:apply-templates/>
    </xsl:template>

    <xsl:template match="qname">
        <xsl:variable name="path" select="./parent::node()/declarationPath/ref"/>
        <xsl:call-template name="startRow"/>
        <xsl:call-template name="startCell"/>
        <xsl:text>{\b QName\b0}</xsl:text>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="startCell"/>
        <xsl:value-of select="util:escapeRTFControlChars(text())"/>
        <xsl:if test="exists($path)"> from </xsl:if>
        <xsl:for-each select="$path">
            <xsl:if test="position() != 1">/</xsl:if>
            <xsl:call-template name="reference"/>
        </xsl:for-each>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="endRow"/>
    </xsl:template>


    <xsl:template match="namespace">
        <xsl:call-template name="startRow"/>
        <xsl:call-template name="startCell"/>
        <xsl:text>{\b Namespace\b0}</xsl:text>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="startCell"/>
        <xsl:choose>
            <xsl:when test="compare('', text()) != 0">
                <xsl:value-of select="util:escapeRTFControlChars(text())"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>No namespace</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="endRow"/>
    </xsl:template>

    <xsl:template match="properties">
        <xsl:call-template name="startRow"/>
        <xsl:call-template name="startCell"/>
        <xsl:text>{\b Properties\b0}</xsl:text>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="startCell"/>
        <xsl:text>\itap2 {</xsl:text>
        <xsl:for-each select="./property">
            <xsl:value-of select="name"/>
            <xsl:call-template name="nestCell"/>
            <xsl:value-of select="value"/>
            <xsl:call-template name="nestCell"/>
            <xsl:call-template name="nestRowDefinition"/>
        </xsl:for-each>
        <xsl:text>}</xsl:text>
        <xsl:call-template name="startRow"/>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="endRow"/>
    </xsl:template>

    <xsl:template match="attributes">
        <xsl:call-template name="startRow"/>
        <xsl:call-template name="startCell"/>
        <xsl:text>{\b Attributes\b0}</xsl:text>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="startCell"/>
        <xsl:text>\itap2 {</xsl:text>
        <xsl:text>{\b QName\b0}</xsl:text>
        <xsl:call-template name="nestCell"/>
        <xsl:text>{\b Type\b0}</xsl:text>
        <xsl:call-template name="nestCell"/>
        <xsl:text>{\b Fixed\b0}</xsl:text>
        <xsl:call-template name="nestCell"/>
        <xsl:text>{\b Default\b0}</xsl:text>
        <xsl:call-template name="nestCell"/>
        <xsl:text>{\b Use\b0}</xsl:text>
        <xsl:call-template name="nestCell"/>
        <xsl:text>{\b Annotation\b0}</xsl:text>
        <xsl:call-template name="nestCell"/>
        <xsl:call-template name="nestRowDefinitionAttrs">
            <xsl:with-param name="index">1</xsl:with-param>
        </xsl:call-template>
        <xsl:for-each select="attr">
            <xsl:call-template name="reference">
                <xsl:with-param name="ref" select="ref"/>
            </xsl:call-template>
            <xsl:call-template name="nestCell"/>
            <xsl:value-of select="util:escapeRTFControlChars(type)"/>
            <xsl:call-template name="nestCell"/>
            <xsl:value-of select="fixed"/>
            <xsl:call-template name="nestCell"/>
            <xsl:value-of select="default"/>
            <xsl:call-template name="nestCell"/>
            <xsl:value-of select="use"/>
            <xsl:call-template name="nestCell"/>
            <xsl:value-of select="util:escapeRTFControlChars(normalize-space(annotation))"/>
            <xsl:call-template name="nestCell"/>
            <xsl:call-template name="nestRowDefinitionAttrs"/>
        </xsl:for-each>
        <xsl:text>}</xsl:text>
        <xsl:call-template name="startRow"/>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="endRow"/>
    </xsl:template>

    <xsl:template match="children">
        <xsl:call-template name="startRow"/>
        <xsl:call-template name="startCell"/>
        <xsl:text>{\b Children\b0}</xsl:text>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="startCell"/>
        <xsl:text>\itap2 {</xsl:text>
        <xsl:text>{\b QName\b0}</xsl:text>
        <xsl:call-template name="nestCell"/>
        <xsl:text>{\b MinOccurs\b0}</xsl:text>
        <xsl:call-template name="nestCell"/>
        <xsl:text>{\b MaxOccurs\b0}</xsl:text>
        <xsl:call-template name="nestCell"/>
        <xsl:call-template name="nestRowDefinitionChildren">
            <xsl:with-param name="index" select="1"/>
        </xsl:call-template>
        <xsl:for-each select="child">
            <xsl:call-template name="reference">
                <xsl:with-param name="ref" select="ref"/>
            </xsl:call-template>
            <xsl:call-template name="nestCell"/>
            <xsl:value-of select="minOccurs"/>
            <xsl:call-template name="nestCell"/>
            <xsl:value-of select="maxOccurs"/>
            <xsl:call-template name="nestCell"/>
            <xsl:call-template name="nestRowDefinitionChildren"/>
        </xsl:for-each>
        <xsl:text>}</xsl:text>
        <xsl:call-template name="startRow"/>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="endRow"/>
    </xsl:template>

    <xsl:template match="constraints">
        <xsl:call-template name="startRow"/>
        <xsl:call-template name="startCell"/>
        <xsl:text>{\b Constraints\b0}</xsl:text>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="startCell"/>
        <xsl:text>\itap2 {</xsl:text>
        <xsl:text>{\b Type\b0}</xsl:text>
        <xsl:call-template name="nestCell"/>
        <xsl:text>{\b QName\b0}</xsl:text>
        <xsl:call-template name="nestCell"/>
        <xsl:text>{\b Refer\b0}</xsl:text>
        <xsl:call-template name="nestCell"/>
        <xsl:text>{\b Selector\b0}</xsl:text>
        <xsl:call-template name="nestCell"/>
        <xsl:text>{\b Field(s)\b0}</xsl:text>
        <xsl:call-template name="nestCell"/>
        <xsl:call-template name="nestRowDefinitionConstraints">
            <xsl:with-param name="index" select="1"/>
        </xsl:call-template>
        <xsl:for-each select="constraint">
            <xsl:value-of select="util:escapeRTFControlChars(type)"/>
            <xsl:call-template name="nestCell"/>
            <xsl:value-of select="util:escapeRTFControlChars(name)"/>
            <xsl:call-template name="nestCell"/>
            <xsl:value-of select="util:escapeRTFControlChars(refer)"/>
            <xsl:call-template name="nestCell"/>
            <xsl:value-of select="util:escapeRTFControlChars(selector)"/>
            <xsl:call-template name="nestCell"/>
            <xsl:value-of select="util:escapeRTFControlChars(fields)"/>
            <xsl:call-template name="nestCell"/>
            <xsl:call-template name="nestRowDefinitionConstraints"/>
        </xsl:for-each>
        <xsl:text>}</xsl:text>
        <xsl:call-template name="startRow"/>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="endRow"/>
    </xsl:template>

    <xsl:template match="annotations">
        <xsl:call-template name="startRow"/>
        <xsl:call-template name="startCell"/>
        <xsl:text>{\b Annotations\b0}</xsl:text>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="startCell"/>
        <xsl:variable name="id">
            <xsl:value-of select="./parent::node()/@id"/>
        </xsl:variable>
        <xsl:variable name="name" select="local-name(.)"/>
        <xsl:for-each select="annotation">
            <xsl:call-template name="listEntry">
                <xsl:with-param name="level">2</xsl:with-param>
                <xsl:with-param name="index" select="position()"/>
                <xsl:with-param name="listName"
                    select="$componentsListsNumbers/entry[@key = func:getListName($id, $name)]/@value"
                />
            </xsl:call-template>
            <xsl:value-of select="util:escapeRTFControlChars(normalize-space(text()))"/>
        </xsl:for-each>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="endRow"/>
    </xsl:template>

    <xsl:template match="model">
        <xsl:call-template name="startRow"/>
        <xsl:call-template name="startCell"/>
        <xsl:text>{\b Model\b0}</xsl:text>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="startCell"/>
        <xsl:call-template name="groupTemplate">
            <xsl:with-param name="group" select="group[1]"/>
        </xsl:call-template>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="endRow"/>
    </xsl:template>

    <xsl:template name="groupTemplate">
        <xsl:param name="group" select="."/>
        <xsl:variable name="compositor">
            <xsl:value-of select="$group/@compositor"/>
        </xsl:variable>
        <xsl:variable name="separator">
            <xsl:if test="compare($compositor, 'sequence') = 0">
                <xsl:text> , </xsl:text>
            </xsl:if>
            <xsl:if test="compare($compositor, 'choice') = 0">
                <xsl:text> | </xsl:text>
            </xsl:if>
            <xsl:if test="compare($compositor, 'all') = 0">
                <xsl:text> </xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:if test="compare($compositor, 'all') = 0">
            <xsl:text>ALL(</xsl:text>
        </xsl:if>
        <xsl:for-each
            select="$group/*[compare(local-name(.), 'group') = 0 or compare(local-name(.), 'ref') = 0]">
            <xsl:if test="position() != 1">
                <xsl:value-of select="$separator"/>
            </xsl:if>
            <xsl:choose>
                <xsl:when test="compare(local-name(.), 'ref') = 0">
                    <xsl:call-template name="reference"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="nextCompositor">
                        <xsl:value-of select="@compositor"/>
                    </xsl:variable>
                    <xsl:if test="compare($compositor, $nextCompositor) != 0">
                        <xsl:text>(</xsl:text>
                    </xsl:if>
                    <xsl:call-template name="groupTemplate"/>
                    <xsl:if test="compare($compositor, $nextCompositor) != 0">
                        <xsl:text>)</xsl:text>
                    </xsl:if>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>
        <xsl:if test="compare($compositor, 'all') = 0">
            <xsl:text>)</xsl:text>
        </xsl:if>
    </xsl:template>

    <xsl:template match="schemaLocation">
        <xsl:call-template name="startRow"/>
        <xsl:call-template name="startCell"/>
        <xsl:text>{\b Schema Location\b0}</xsl:text>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="startCell"/>
        <xsl:value-of select="util:escapeRTFControlChars(text())"/>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="endRow"/>
    </xsl:template>

    <xsl:template match="element/type | complexType/type | attribute/type | simpleType/type">
        <xsl:call-template name="startRow"/>
        <xsl:call-template name="startCell"/>
        <xsl:text>{\b Type\b0}</xsl:text>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="startCell"/>
        <xsl:if test="exists(@derivationType)">
            <xsl:value-of select="@derivationType"/>
            <xsl:text> of </xsl:text>
        </xsl:if>
        <xsl:call-template name="reference">
            <xsl:with-param name="ref" select="ref"/>
        </xsl:call-template>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="endRow"/>
    </xsl:template>

    <xsl:template match="typeHierarchy">
        <xsl:call-template name="startRow"/>
        <xsl:call-template name="startCell"/>
        <xsl:text>{\b Type Hierarchy\b0}</xsl:text>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="startCell"/>
        <xsl:call-template name="hierarchyOutput">
            <xsl:with-param name="refs" select="ref"/>
        </xsl:call-template>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="endRow"/>
    </xsl:template>

    <xsl:template match="source | instance">
        <xsl:call-template name="startRow"/>
        <xsl:call-template name="startCell"/>
        <xsl:text>{\b </xsl:text>
        <xsl:choose>
            <xsl:when test="compare(local-name(.), 'source') = 0">
                <xsl:text>Source</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>Instance</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:text>\b0}</xsl:text>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="startCell"/>
        <xsl:for-each select="token">
            <xsl:variable name="tokenType" select="@type"/>
            <xsl:text>{\cf</xsl:text>
            <xsl:value-of select="$tokenColor/*[@key=$tokenType]"/>
            <xsl:text> </xsl:text>
            <xsl:value-of select="util:escapeRTFControlChars(text())"/>
            <xsl:text>}</xsl:text>
        </xsl:for-each>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="endRow"/>
    </xsl:template>

    <xsl:template match="substitutionGroup | substitutionGroupAffiliation">
        <xsl:call-template name="startRow"/>
        <xsl:call-template name="startCell"/>
        <xsl:text>{\b </xsl:text>
        <xsl:choose>
            <xsl:when test="compare(local-name(.), 'substitutionGroup') = 0">
                <xsl:text>Substitution Group</xsl:text>
            </xsl:when>
            <xsl:otherwise>Substitution Group Affiliation</xsl:otherwise>
        </xsl:choose>
        <xsl:text>\b0}</xsl:text>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="startCell"/>
        <xsl:variable name="id">
            <xsl:value-of select="./parent::node()/@id"/>
        </xsl:variable>
        <xsl:variable name="name" select="local-name(.)"/>
        <xsl:variable name="listName"
            select="$componentsListsNumbers/entry[@key = func:getListName($id, $name)]/@value"/>
        <xsl:for-each select="ref">
            <xsl:variable name="currentRef" select="."/>
            <xsl:call-template name="listEntry">
                <xsl:with-param name="level">1</xsl:with-param>
                <xsl:with-param name="index" select="position()"/>
                <xsl:with-param name="listName" select="$listName"/>
            </xsl:call-template>
            <xsl:call-template name="reference"/>
        </xsl:for-each>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="endRow"/>
    </xsl:template>

    <xsl:template match="usedBy">
        <xsl:call-template name="startRow"/>
        <xsl:call-template name="startCell"/>
        <xsl:text>{\b Used By\b0}</xsl:text>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="startCell"/>
        <xsl:variable name="id">
            <xsl:value-of select="./parent::node()/@id"/>
        </xsl:variable>
        <xsl:variable name="name" select="local-name(.)"/>
        <xsl:variable name="listName"
            select="$componentsListsNumbers/entry[@key = func:getListName($id, $name)]/@value"/>
        <xsl:for-each-group select="./ref" group-by="@refType">
            <xsl:variable name="currentRef" select="."/>
            <xsl:call-template name="listEntry">
                <xsl:with-param name="level">1</xsl:with-param>
                <xsl:with-param name="index" select="position()"/>
                <xsl:with-param name="listName" select="$listName"/>
            </xsl:call-template>
            <xsl:text>{\b </xsl:text>
            <xsl:value-of select="$componentTypeLabels/*[@key=$currentRef/@refType]"/>
            <xsl:text>\b0}</xsl:text>
            <xsl:for-each select="current-group()">
                <xsl:call-template name="listEntry">
                    <xsl:with-param name="level">2</xsl:with-param>
                    <xsl:with-param name="listName" select="$listName"/>
                </xsl:call-template>
                <xsl:call-template name="reference"/>
            </xsl:for-each>
        </xsl:for-each-group>
        <xsl:call-template name="endCell"/>
        <xsl:call-template name="endRow"/>
    </xsl:template>

    <!-- Show the hierarchy type  -->
    <xsl:template name="hierarchyOutput">
        <xsl:param name="refs"/>
        <xsl:param name="index" as="xs:integer" select="1"
            xmlns:xs="http://www.w3.org/2001/XMLSchema"/>
        <xsl:variable name="id">
            <xsl:value-of select="./parent::node()/@id"/>
        </xsl:variable>
        <xsl:variable name="name" select="local-name(.)"/>
        <xsl:call-template name="listEntry">
            <xsl:with-param name="level">2</xsl:with-param>
            <xsl:with-param name="index" select="$index"/>
            <xsl:with-param name="listName"
                select="$componentsListsNumbers/entry[@key = func:getListName($id, $name)]/@value"/>
        </xsl:call-template>
        <xsl:call-template name="reference">
            <xsl:with-param name="ref" select="$refs[$index]"/>
        </xsl:call-template>
        <xsl:if test="$index &lt; count($refs)">
            <xsl:call-template name="hierarchyOutput">
                <xsl:with-param name="refs" select="$refs"/>
                <xsl:with-param name="index" select="$index + 1"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>

    <xsl:template match="schema">
        <xsl:call-template name="component">
            <xsl:with-param name="type">
                <xsl:variable name="currentSchema" select="."/>
                <xsl:value-of select="$schemaTypeLabels/*[@key=$currentSchema/@type]"/>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="element">
        <xsl:call-template name="component">
            <xsl:with-param name="type">Element</xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="complexType">
        <xsl:call-template name="component">
            <xsl:with-param name="type">Complex Type</xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="simpleType">
        <xsl:call-template name="component">
            <xsl:with-param name="type">Simple Type</xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="attribute">
        <xsl:call-template name="component">
            <xsl:with-param name="type">Attribute</xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="attributeGroup">
        <xsl:call-template name="component">
            <xsl:with-param name="type">Attribute Group</xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="elementGroup">
        <xsl:call-template name="component">
            <xsl:with-param name="type">Element Group</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    <xsl:template match="text()"/>
</xsl:stylesheet>
