<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs a"
    xpath-default-namespace="http://www.oxygenxml.com/ns/author/external-action"
    xmlns:a="http://www.oxygenxml.com/ns/author/external-action" version="3.0">

    <xsl:output method="xml" exclude-result-prefixes="a" cdata-section-elements="String"/>
    
    <xsl:template match="authorAction">
        <serialized xml:space="preserve">
         <externalAction>
            <xsl:call-template name="generateStringField">
                <xsl:with-param name="name">id</xsl:with-param>
                <xsl:with-param name="value" select="@id"/>
            </xsl:call-template>
             <xsl:apply-templates select="node()" mode="convert"/>
         </externalAction>
        </serialized>
    </xsl:template>

    <xsl:template match="arguments" mode="convert">
        <field name="argValues">
            <serializableOrderedMap>
                <xsl:apply-templates select="node() | @*" mode="convert"/>
            </serializableOrderedMap>
        </field>
    </xsl:template>

    <xsl:template match="argument" mode="convert">
        <entry>
        <String>
            <xsl:value-of select="@name"/>
        </String>

        <String>

            <xsl:choose>
                <!-- Either simple text or text that came from a CDATA. -->
                <xsl:when test="count(node()) = 1 and count(text()) = 1">
                    <xsl:value-of select="text()"/>
                </xsl:when>
                <xsl:otherwise>
                    <!--
                        Drop any unnecessary samespaces that that are inherited. For example:
                        xmlns:a="http://www.oxygenxml.com/ns/author/external-action" 
                        xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
                    -->
                    <xsl:variable name="dropNs">
                        <xsl:apply-templates mode="copy-no-ns" select="node()"/>
                    </xsl:variable>
                    
                    <xsl:value-of select="serialize($dropNs)"/>
                </xsl:otherwise>
            </xsl:choose>

        </String>
        </entry>
    </xsl:template>

    <!--
    Drop any unnecessary samespaces that that are inherited. For example:
    xmlns:a="http://www.oxygenxml.com/ns/author/external-action" 
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
    -->
    <xsl:template match="*" mode="copy-no-ns">
        <xsl:element name="{local-name(.)}" namespace="{namespace-uri()}">
            <xsl:apply-templates select="node() | @*" mode="copy-no-ns"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="@*" mode="copy-no-ns">
        <xsl:copy/>
    </xsl:template>


    <xsl:template match="operations" mode="convert">
        <field name="actionModes">
            <actionMode-array>
                <xsl:apply-templates select="node() | @*" mode="convert"/>
            </actionMode-array>
        </field>
    </xsl:template>

    <xsl:template match="operation" mode="convert">
        <!-- If its a short form lacking the package, it's probably a built-in operation. -->
        <xsl:variable name="qName">
            <xsl:variable name="candidate" select="@id"/>
            <xsl:choose>
                <xsl:when test="contains($candidate, '.')">
                    <!-- Probably already a qualified name. -->
                    <xsl:value-of select="$candidate"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat('ro.sync.ecss.extensions.commons.operations.', $candidate)"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <actionMode>
            <xsl:call-template name="generateStringField">
                <xsl:with-param name="name">operationID</xsl:with-param>
                <xsl:with-param name="value" select="$qName"/>
            </xsl:call-template>
            
            <xsl:if test="empty(*:xpathCondition)">
                <!-- No XPath conditions. generate an empty one. -->
                <field name="xpathCondition">
                    <String></String>
                </field>
            </xsl:if>
            
            <xsl:apply-templates select="node() | @* except @id" mode="convert"/>
        </actionMode>
    </xsl:template>

    <xsl:template match="smallIconPath | largeIconPath" mode="convert">
        <xsl:call-template name="generateStringField">
            <xsl:with-param name="name" select="local-name(.)"/>
            <xsl:with-param name="value" select="@href"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="*" mode="convert">
        <xsl:call-template name="generateStringField">
            <xsl:with-param name="name" select="local-name(.)"/>
            <xsl:with-param name="value" select="text()"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="enabledInReadOnlyContext" mode="convert">
        <field name="{local-name(.)}">
            <Boolean>
                <xsl:value-of select="text()"/>
            </Boolean>
        </field>
    </xsl:template>

    <!-- Generates a String field. -->
    <xsl:template name="generateStringField">
        <xsl:param name="name" as="xs:string"/>
        <xsl:param name="value" as="node()*"/>
        <field name="{$name}">
            <xsl:choose>
                <xsl:when test="$value">
                    <xsl:call-template name="writeStringValue">
                        <xsl:with-param name="value" select="$value"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise><String></String></xsl:otherwise>
            </xsl:choose>
        </field>
    </xsl:template>
    
    <!-- Generates a String value. -->
    <xsl:template name="writeStringValue">
        <xsl:param name="value" as="node()"/>
        <String><xsl:value-of select="$value"/></String>
    </xsl:template>

</xsl:stylesheet>
