<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:a="http://www.oxygenxml.com/ns/author/external-action"
    exclude-result-prefixes="xs"
    version="3.0">
    
    <xsl:output method="xml"/>
    

    <xsl:template match="serialized">
        <xsl:apply-templates select="externalAction"/>
    </xsl:template>
    
    <xsl:template match="externalAction">
        <a:authorAction 
            xmlns:a="http://www.oxygenxml.com/ns/author/external-action"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xsi:schemaLocation="http://www.oxygenxml.com/ns/author/external-action http://www.oxygenxml.com/ns/author/external-action/authorAction.xsd"
            id="{field[@name='id']/String/text()}">
            
            <xsl:apply-templates select="field[@name='name']" />
            <xsl:apply-templates select="field[@name='description']" />
            <xsl:apply-templates select="field[@name='smallIconPath']" />
            <xsl:apply-templates select="field[@name='largeIconPath']" />
            <xsl:apply-templates select="field[@name='actionModes']" />
            <xsl:apply-templates select="field[@name='accelerator']" />
            <xsl:apply-templates select="field[@name='accessKey']" />
            
                    
            <xsl:apply-templates 
                select="node() except
                field[
                @name = 'id' or
                @name = 'name' or
                @name = 'description' or
                @name = 'smallIconPath' or
                @name = 'largeIconPath' or
                @name = 'smallIconPath' or
                @name = 'actionModes' or
                @name = 'accessKey' or
                @name = 'accelerator'] | @*"/>
        </a:authorAction>
    </xsl:template>
    
    <xsl:template match="field[@name='smallIconPath']">
        <xsl:if test="string-length(String/text()) &gt; 0">
            <a:smallIconPath href="{String/text()}"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="field[@name='largeIconPath']">
        <xsl:if test="string-length(String/text()) &gt; 0">
            <a:largeIconPath href="{String/text()}"/>
        </xsl:if>
    </xsl:template>

    <xsl:template match="field[@name='argValues']">
        <a:arguments>
            <xsl:apply-templates select="serializableOrderedMap/entry"/>
        </a:arguments>
    </xsl:template>
    
    <xsl:template match="field[@name='argValues']/serializableOrderedMap/entry">
        <a:argument name="{String[1]/text()}">
            <!-- Try parsing the fragment. if it succeeds, we basically unwrap it from the CDATA. -->
            <xsl:try
                select="parse-xml-fragment(String[2]/node())">
                <xsl:catch>
                    <!-- Parsing failed. It might have unresolved entities. Keep it in a CDATA. -->
                    <xsl:text disable-output-escaping="yes">&lt;![CDATA[</xsl:text>
                    <xsl:value-of disable-output-escaping="true" select="String[2]/node()" ></xsl:value-of>
                    <xsl:text disable-output-escaping="yes">]]&gt;</xsl:text>
                </xsl:catch>
            </xsl:try>
        </a:argument>
    </xsl:template>
    
    
    <xsl:template match="field[@name='actionModes']">
        <a:operations>
            <xsl:apply-templates select="actionMode-array/*"/>
        </a:operations>
    </xsl:template>
    
    <xsl:template match="actionMode">
        <xsl:variable name="op" select="field[@name='operationID']/String/text()"/>
        <xsl:variable name="short">
            <xsl:variable name="candidate" 
                select="substring-after($op, 'ro.sync.ecss.extensions.commons.operations.')"/>
            <xsl:choose>
                <xsl:when test="contains($candidate, '.') or string-length($candidate) = 0">
                    <!-- Probably a sub package exists. Keep the qname form. -->
                    <xsl:value-of select="$op"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$candidate"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <a:operation id="{$short}">
            <xsl:apply-templates select="node() except field[@name='operationID'] | @*" />
        </a:operation>
    </xsl:template>
    
    <xsl:template match="field">
        <xsl:if test="not(null) and string-length(*/text()) &gt; 0">
            <xsl:element name="a:{@name}"><xsl:value-of select="*/text()"/></xsl:element>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="text()"></xsl:template>
    
</xsl:stylesheet>