<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:map="http://www.w3.org/2005/xpath-functions/map"
    xmlns:f="http://www.oxygenxml.com/xsl/functions" exclude-result-prefixes="xs f map"
    version="2.0">
    
    <!-- Generate DITA for OpenAPI servers. -->
    <xsl:template name="servers">
        <xsl:param name="servers" required="no"/>
        <xsl:if test="$servers">
            <section outputclass="openapi-servers">
                <title>Servers</title>
                <xsl:if test="f:arrayHasElements($servers)">
                    <dl outputclass="openapi-servers-list">
                        <xsl:for-each select="$servers[not(array)], $servers[array]/array">
                            <xsl:call-template name="server">
                                <xsl:with-param name="serverObject" select="."/>
                            </xsl:call-template>
                        </xsl:for-each>
                    </dl>
                </xsl:if>
            </section>
        </xsl:if>
    </xsl:template>
    
    <!-- Generate DITA for Server object. -->
    <xsl:template name="server">
        <xsl:param name="serverObject"/>
        <dlentry  outputclass="openapi-server">
            <dt>
                <filepath outputclass="openapi-server-url"><xsl:value-of select="$serverObject/url"/></filepath>
            </dt>
            <dd>
                <xsl:if test="$serverObject/description">
                    <div>
                        <xsl:attribute name="outputclass" select="concat('openapi-server-description ', $markdownContentOutputClass)"/>
                        <xsl:value-of select="$serverObject/description"/>
                    </div>   
                </xsl:if>
                <xsl:call-template name="serverVariables">
                    <xsl:with-param name="variables" select="$serverObject/variables/*"></xsl:with-param>
                </xsl:call-template>
                
                <xsl:call-template name="extensionsHandlerAsList">
                    <xsl:with-param name="element" select="$serverObject"/>
                </xsl:call-template>
            </dd>
        </dlentry>
    </xsl:template>
    
    <!-- Handle server variables information -->
    <xsl:template name="serverVariables">
        <xsl:param name="variables" required="no"/>
        <xsl:if test="$variables and count($variables) > 0">
            <table frame="all" rowsep="1" colsep="1"  outputclass="openapi-server-variables">
                <title>Server variables</title>
                <tgroup cols="2">
                    <colspec colname="c1" colnum="1" colwidth="1*"/>
                    <colspec colname="c2" colnum="2" colwidth="3*"/>
                    <thead>
                        <row>
                            <entry>Name</entry>
                            <entry>Description</entry>
                        </row>
                    </thead>
                    <tbody>
                        <xsl:for-each select="$variables[not(array)], $variables[array]/array">
                            <row>
                                <entry>
                                    <xsl:attribute name="outputclass" select="concat('openapi-server-variable-name ', $toUnescapeOutputClass)"/>
                                    <xsl:value-of select="local-name()"/>
                                </entry>
                                <entry>
                                    <xsl:if test="./description">
                                        <div>
                                            <xsl:attribute name="outputclass" select="concat('openapi-server-variable-description ',$markdownContentOutputClass)"/>
                                            <xsl:value-of select="./description"/>
                                        </div>
                                    </xsl:if>
                                    <xsl:if test="./enum and count(./enum) > 0">
                                        <ul outputclass="openapi-server-enum-list">
                                            <xsl:for-each select="./enum">
                                                <li outputclass="openapi-server-enum"><xsl:value-of select="."/></li>
                                            </xsl:for-each>
                                        </ul>
                                    </xsl:if>
                                    <xsl:if test="./default">
                                        <p>
                                            <b>Default: </b><ph outputclass="openapi-server-default"><xsl:value-of select="./default"/></ph>
                                        </p>
                                    </xsl:if>
                                    
                                    <xsl:call-template name="extensionsHandlerAsList">
                                        <xsl:with-param name="element" select="."/>
                                    </xsl:call-template>
                                </entry>
                            </row>
                        </xsl:for-each>
                    </tbody>
                </tgroup>
            </table>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>