<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:map="http://www.w3.org/2005/xpath-functions/map"
    xmlns:f="http://www.oxygenxml.com/xsl/functions" exclude-result-prefixes="xs f map"
    version="2.0">
    
    <xsl:include href="handleServers.xsl"/>
    <xsl:include href="handleSecurityRequirements.xsl"/>
    <xsl:include href="handleExtensions.xsl"/>
    
    <!-- Generate intro for OpenAPI spec. -->
    <xsl:template name="intro">
        <xsl:param name="info" as="node()"/>
        <xsl:param name="jsonSchemaDialect" required="no"/>
        <xsl:param name="servers"  required="no"/>
        <xsl:param name="security"  required="no"/>
        <xsl:param name="externalDocs" required="no"/>
        <topic id="introTopic" outputclass="openapi-introduction">
            <title outputclass="openapi-title">
                <xsl:value-of select="$info/title"/>
            </title>
            
            <xsl:if test="$info/summary">
                <shortdesc outputclass="openapi-summary">
                    <xsl:value-of select="$info/summary"/>
                </shortdesc>
            </xsl:if>
            <body>
                <p>
                    <ph>Version:</ph>
                    <xsl:text> </xsl:text>
                    <b outputclass="openapi-version"><xsl:value-of select="$info/version"/></b>
                </p>
                <xsl:if test="$info/description">
                    <bodydiv>
                        <xsl:attribute name="outputclass" select="concat('openapi-description ', $markdownContentInBodydivOutputClass)"/>
                        <xsl:value-of select="$info/description"/>
                    </bodydiv>
                </xsl:if>
                <xsl:if test="$info/termsOfService">
                    <p outputclass="termsOfService">
                        <ph>Terms of Service:</ph>
                        <xsl:text> </xsl:text>
                        <xref format="html" scope="external" outputclass="openapi-termsOfService">
                            <xsl:attribute name="href">
                                <xsl:value-of select="$info/termsOfService"/>
                            </xsl:attribute></xref>
                    </p>
                </xsl:if>
                <xsl:if test="$info/contact">
                    <xsl:call-template name="introContacts">
                        <xsl:with-param name="contact" select="$info/contact"/>
                    </xsl:call-template>
                </xsl:if>
                <xsl:if test="$info/license">
                    <xsl:call-template name="introLicense">
                        <xsl:with-param name="license" select="$info/license"/>
                    </xsl:call-template>
                </xsl:if>
                <xsl:if test="$externalDocs">
                    <xsl:call-template name="externalDocumentation">
                        <xsl:with-param name="externalDocsElement" select="$externalDocs"/>
                    </xsl:call-template>
                </xsl:if>
                <xsl:call-template name="servers">
                    <xsl:with-param name="servers" select="$servers"/>
                </xsl:call-template>
                <xsl:if test="$security">
                    <xsl:call-template name="securityRequirementObject">
                        <xsl:with-param name="securityReqNodes" select="$security/*"/>
                    </xsl:call-template>
                </xsl:if>
                
                <!-- OpenAPI 3.1 jsonSchemaDialect field -->
                <xsl:if test="$jsonSchemaDialect">
                    <p outputclass="openapi-jsonSchemaDialect">
                        <ph>Default JSON schema dialect:</ph>
                        <xsl:text> </xsl:text>
                        <xref format="html" scope="external" outputclass="openapi-jsonSchemaDialect-uri">
                            <xsl:attribute name="href">
                                <xsl:value-of select="$jsonSchemaDialect"/>
                            </xsl:attribute>
                        </xref>
                    </p>
                </xsl:if>
                
                <xsl:call-template name="extensionsHandlerAsList">
                    <xsl:with-param name="element" select="$info"/>
                </xsl:call-template>
            </body>
        </topic>
    </xsl:template>
    
    <!-- Handle contacts information -->
    <xsl:template name="introContacts">
        <xsl:param name="contact" as="node()"/>
        <p outputclass="openapi-contact-name">
            <xsl:choose>
                <xsl:when test="$contact/name">
                    <xsl:value-of select="$contact/name"/>
                </xsl:when>
                <xsl:otherwise>Contacts:</xsl:otherwise>
            </xsl:choose>
        </p>  
        <xsl:if test="$contact/url or $contact/email">
            <ul outputclass="openapi-contact">
                <xsl:if test="$contact/url">
                    <li outputclass="openapi-contact-url">
                        <xref format="html" scope="external">
                            <xsl:attribute name="href">
                                <xsl:value-of select="$contact/url"/>
                            </xsl:attribute>
                        </xref>
                    </li>
                </xsl:if>
                <xsl:if test="$contact/email">
                    <li outputclass="openapi-contact-email">
                        <xref format="mail" scope="external">
                            <xsl:attribute name="href">
                                <xsl:value-of select="concat('mailto:', $contact/email)"/>
                            </xsl:attribute>
                        </xref>
                    </li>
                </xsl:if>
            </ul>
        </xsl:if>
        
        <xsl:call-template name="extensionsHandlerAsList">
            <xsl:with-param name="element" select="$contact"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- Handle license information -->
    <xsl:template name="introLicense">
        <xsl:param name="license" as="node()"/>
        <p outputclass="openapi-license">
            <ph>License:</ph>
            <xsl:text> </xsl:text>
            <xsl:choose>
                <xsl:when test="$license/url">
                    <xref format="html" scope="external" outputclass="openapi-license-url">
                        <xsl:attribute name="href">
                            <xsl:value-of select="$license/url"/>
                        </xsl:attribute>
                        <xsl:value-of select="$license/name"/>
                    </xref>
                </xsl:when>
                <xsl:when test="$license/identifier">
                    <xref format="html" scope="external" outputclass="openapi-license-url">
                        <xsl:attribute name="href">
                            <xsl:value-of select="concat('https://spdx.org/licenses/', $license/identifier, '.html')"/>
                        </xsl:attribute>
                        <xsl:value-of select="$license/name"/>
                    </xref>
                </xsl:when>
                <xsl:otherwise>
                    <ph outputclass="openapi-license-name">
                        <xsl:value-of select="$license/name"/>
                    </ph>
                </xsl:otherwise>
            </xsl:choose>
        </p>
        
        <xsl:call-template name="extensionsHandlerAsList">
            <xsl:with-param name="element" select="$license"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- Handle external documentation object -->
    <xsl:template name="externalDocumentation">
        <xsl:param name="externalDocsElement" as="node()"/>
        <bodydiv outputclass="openapi-externalDocs">
            <xsl:attribute name="outputclass" select="concat('openapi-externalDocs ', $markdownContentInBodydivOutputClass)"/>
            <xsl:value-of select="$externalDocsElement/description"/>
            <xsl:text> [](</xsl:text>
            <xsl:value-of select="$externalDocsElement/url"/>
            <xsl:text>)</xsl:text>
        </bodydiv>
        <xsl:call-template name="extensionsHandlerAsList">
            <xsl:with-param name="element" select="$externalDocsElement"/>
        </xsl:call-template>
    </xsl:template>
</xsl:stylesheet>