<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:f="http://www.oxygenxml.com/xsl/functions"
    exclude-result-prefixes="xs f"
    version="2.0">
    
    <!-- Generate DITA topic for OpenAPI Specification Extensions. -->
    <xsl:template name="extensionsHandlerAsTopic">
        <xsl:param name="element"/>
        
        <xsl:if test="count($element/*[starts-with(local-name(), 'x-')]) > 0">
            <topic outputclass="openapi-specification-extensions-topic">
                <xsl:attribute name="id">
                    <xsl:value-of select="concat('openapi-specification-extensions-', generate-id($element))"/>
                </xsl:attribute>
                
                <title>Extensions</title>
                <body>
                    <xsl:call-template name="specificationExtensionItems">
                        <xsl:with-param name="extensionItems" select="$element/*[starts-with(local-name(), 'x-')]"/>
                    </xsl:call-template>
                </body>
            </topic>
        </xsl:if>
    </xsl:template>
    
    <!-- Generate DITA list for OpenAPI Specification Extensions. -->
    <xsl:template name="extensionsHandlerAsList">
        <xsl:param name="element"/>
        <xsl:if test="count($element/*[starts-with(local-name(), 'x-')]) > 0">
            <xsl:call-template name="specificationExtensionItems">
                <xsl:with-param name="extensionItems" select="$element/*[starts-with(local-name(), 'x-')]"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <!-- Generate DITA for OpenAPI Specification Extensions. -->
    <xsl:template name="specificationExtensionItems">
        <xsl:param name="extensionItems"/>
        <dl>
            <xsl:attribute name="outputclass" select="'openapi-specification-extensions'"/>
            <xsl:for-each select="$extensionItems">
                <dlentry>
                    <xsl:attribute name="outputclass" select="'openapi-specification-extension'"/>
                    <dt>
                        <xsl:attribute name="outputclass" select="concat('openapi-specification-extension-name ', $toUnescapeOutputClass)"/>
                        <xsl:value-of select="local-name(.)"/>
                    </dt>
                    <dd>
                        <xsl:attribute name="outputclass" select="'openapi-specification-extension-value'"/>
                        <xsl:call-template name="specificationExtensionValue">
                            <xsl:with-param name="extensionValue" select="."/>
                        </xsl:call-template>
                    </dd>
                </dlentry>
            </xsl:for-each>
        </dl>
    </xsl:template>
    
    <!-- Handle OpenAPI Specification Extension value. -->
    <xsl:template name="specificationExtensionValue">
        <xsl:param name="extensionValue"/>
       
        <xsl:choose>
            <xsl:when test="count($extensionValue/*) > 0">
                <xsl:call-template name="specificationExtensionItems">
                    <xsl:with-param name="extensionItems" select="./*"></xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$extensionValue"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>