<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:xs="http://www.w3.org/2001/XMLSchema"
  xmlns:f="http://www.oxygenxml.com/xsl/functions"
  exclude-result-prefixes="xs f"
  version="2.0">
  
  <xsl:template match="node() | @*">
    <xsl:copy>
      <xsl:apply-templates select="node() | @*"/>
    </xsl:copy>
  </xsl:template>
  
  <!-- 
      Format value to be used on local references
     -->   
  <xsl:param name="local.references.format" select="''"/>
  
  <xsl:template match="xref[starts-with(@href,'#')]">
    <xsl:variable name="currentHref" select="@href"/>
    <xsl:variable name="currentId">
      <xsl:choose>
        <xsl:when test="starts-with(@href,'#./')">
          <xsl:value-of select="normalize-space(substring(@href, 4))"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="normalize-space(substring(@href, 2))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="elementWithId" select="(//*[@id = $currentId or (@name and f:correctId(@name) = $currentId)])[1]"/>

    <xsl:copy>
      <xsl:attribute name="href">
        <xsl:choose>
          <xsl:when test="$elementWithId">
            <xsl:choose>
              <xsl:when test="local-name($elementWithId) = 'topic'">
                <xsl:value-of select="concat('#', $currentId)"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:variable name="parentTopic" select="$elementWithId/ancestor::topic[1]"></xsl:variable>
                <xsl:choose>
                  <xsl:when test="$parentTopic/@id">
                    <xsl:value-of select="concat('#', $parentTopic/@id, '/', $currentId)"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="concat('#./', $currentId)"/>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="concat('#./', $currentId)"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      
      <xsl:if test="$local.references.format and not(@format)">
        <xsl:attribute name="format" select="$local.references.format"/>
      </xsl:if>
      
      <xsl:apply-templates select="@* except @href | node()"/>
    </xsl:copy>
  </xsl:template>
  
  
  <!--
    Corrects id of a topic such as it will NCName.
    Moreover it eliminates "%20".</xd:desc>
    Para "text": Text to be corrected</xd:param>
    Return: The corrected text which can be used as id</xd:return>
  -->
  <xsl:function name="f:correctId" as="xs:string">
    <xsl:param name="text" as="xs:string"/>
    <xsl:variable name="tempId" select="replace(xs:string($text), '%20', '_')"/>
    <xsl:variable name="tempId2" select="replace($tempId, '[^\c_-]|[+:]', '_')"/>
    <xsl:variable name="tempId3" select="replace($tempId2,'[_]+', '_')"/>
    <xsl:variable name="tempId4" select="replace($tempId3,'_$', '')"/>
    <xsl:value-of select="replace($tempId4, '^[0-9.-/_]+', '')"/>
  </xsl:function>
</xsl:stylesheet>