<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:xhtml="http://www.w3.org/1999/xhtml"
    xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl"
    xmlns:util="http://oxygenxml.com/ns/dita/confluence"
    exclude-result-prefixes="xs xhtml xd util"
    version="2.0">
    
    <xsl:output indent="yes"/>

	<!-- The output base directory. -->
    <xsl:param name="output.base.uri" as="xs:string"  select="base-uri()"/>
    
    <xsl:variable name="timeStamp" select="( current-dateTime() - xs:dateTime('1970-01-01T00:00:00')) div xs:dayTimeDuration('PT1S') * 1000"/>
    
    <xsl:template match="/">
        <map>
            <xsl:apply-templates select="node()"/>
        </map>
        
        <xsl:variable name="mapping">
            <xsl:apply-templates select="node()" mode="mapping"/>
        </xsl:variable>
        
        <xsl:variable name="ouputMappingFile" select="resolve-uri('oxy-confluence-topics-mapping.xml', $output.base.uri)"/>
        <xsl:result-document href="{$ouputMappingFile}" doctype-public="" doctype-system="">
            <root>
                <xsl:copy-of select="$mapping"/>
            </root>
        </xsl:result-document>
    </xsl:template>
    
    <xsl:template match="xhtml:li" mode="mapping">
        <xsl:if test="xhtml:a">
            <xsl:variable name="varName" select="util:generateTopicFilePathRelativeToMap(xhtml:a/@href)"/>
            <mapping in="{xhtml:a/@href}" out="{$varName}"/>
            <xsl:apply-templates select="node()" mode="mapping"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="text()" mode="#all">
        <!-- ignore text -->
    </xsl:template>
    
    <xsl:template match="xhtml:div[@id='main-content']/xhtml:table/xhtml:tr/xhtml:th[text() = 'Name']">
        <xsl:if test="following-sibling::xhtml:td[1]">
            <title>
                <xsl:copy-of select="following-sibling::xhtml:td[1]/text()"></xsl:copy-of>
            </title>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="xhtml:div[@class='pageSection']/xhtml:ul/xhtml:li">
        <xsl:if test="xhtml:a">
            <xsl:variable name="ditaTopicFile" 
                select="util:generateTopicFilePathRelativeToMap(xhtml:a/@href)"/>
            <topicref href="{$ditaTopicFile}">
                <xsl:if test="string-length(normalize-space(xhtml:a/text())) > 0">
                  <xsl:attribute name="navtitle">
                      <xsl:value-of select="normalize-space(xhtml:a/text())"/>
                  </xsl:attribute>  
                </xsl:if>
            </topicref>
        </xsl:if>
        <xsl:apply-templates select="node() | @*"/>
    </xsl:template>
    
    <xsl:template match="xhtml:li">
        <xsl:if test="xhtml:a">
            <topicref>
                <xsl:variable name="varName" select="util:generateTopicFilePathRelativeToMap(xhtml:a/@href)"/>
                <xsl:attribute name="href" select="$varName"/>
                <xsl:if test="string-length(normalize-space(xhtml:a/text())) > 0">
                    <xsl:attribute name="navtitle">
                        <xsl:value-of select="normalize-space(xhtml:a/text())"/>
                    </xsl:attribute>  
                </xsl:if>
           <xsl:apply-templates select="node() | @*"/>
       </topicref>
       </xsl:if>
   </xsl:template>
    
  
    <xd:doc>
        <xd:desc>Generate name for DITA topic file using the given HTML Confluence file name.</xd:desc>
        <xd:param name="htmlFileName">the HTML Confluence file name</xd:param>
        <xd:return>A name for DITA topic file.</xd:return>
    </xd:doc>
    <xsl:function name="util:generateTopicFilePathRelativeToMap">
        <xsl:param name="htmlFileName" as="xs:string"/>
        
        <xsl:variable name="currentExtension" select="(tokenize($htmlFileName, '\.'))[last()]"/>
        <xsl:variable name="fNameNoExtension" select="substring-before($htmlFileName, concat('.', $currentExtension))"/>
        <xsl:variable name="fileNameCandidate"  select="concat('topics/', $fNameNoExtension, '.dita')"/>
        
        <!-- check if file exists on file system -->
        <xsl:variable name="generatedFileSystemID" select="resolve-uri($fileNameCandidate, $output.base.uri)"/>
        <xsl:choose>
            <xsl:when test="doc-available($generatedFileSystemID)">
                <!-- NEW FILE -->
                <xsl:value-of select="concat('topics/', $fNameNoExtension, '_', $timeStamp, '.dita')"/>
            </xsl:when>
            <xsl:otherwise>
                <!-- save that file -->
                <xsl:value-of select="$fileNameCandidate"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>
    
</xsl:stylesheet>