This project is an Open Source project and welcomes contributions from everyone who finds it useful or lacking. 

The Project has selected the MPL 2.0 license, popular for its permissive and flexible properties, while still encouraging a collaborative
community.

The license tells you what rights you have that are provided by the copyright holder. It is important that the contributor fully understands what rights they are licensing and agrees to them. Sometimes the copyright holder isn't the contributor, such as when the contributor is doing work on behalf of a company. To make a good faith effort to ensure these criteria are met, Syncro Soft requires the Developer Certificate of Origin (DCO) process to be followed. 

The DCO is an attestation attached to every contribution made by every developer. In the commit message of the contribution, the developer simply adds a Signed-off-by statement and thereby agrees to the DCO, which you can find below or at <http://developercertificate.org/>.

```
Developer's Certificate of Origin 1.1

By making a contribution to this project, I certify that:

(a) The contribution was created in whole or in part by me and I
    have the right to submit it under the open source license
    indicated in the file; or

(b) The contribution is based upon previous work that, to the
    best of my knowledge, is covered under an appropriate open
    source license and I have the right under that license to
    submit that work with modifications, whether created in whole
    or in part by me, under the same open source license (unless
    I am permitted to submit under a different license), as
    Indicated in the file; or

(c) The contribution was provided directly to me by some other
    person who certified (a), (b) or (c) and I have not modified
    it.

(d) I understand and agree that this project and the contribution
    are public and that a record of the contribution (including
    all personal information I submit with it, including my
    sign-off) is maintained indefinitely and may be redistributed
    consistent with this project or the open source license(s)
    involved.
```
The DCO requires a sign-off message in the following format appear on each commit in the pull request: 

```
Signed-off-by: Stefan Vasile <stefan@sync.ro> 
```
Use your real name (sorry, no pseudonyms or anonymous contributions.). If you set your user.name and user.email git configs, you can sign your commit automatically with **git commit -s** If you forget to add the sign-off you can also amend a previous commit with the sign-off by running **git commit --amend -s**. If you've pushed your changes to GitHub already you'll need to force push your branch after this with **git push -f**.
