package ro.sync.util.editorvars.parser.model;

import java.util.ArrayList;
import java.util.List;

/**
 * A parameter of an editor variable. It can contain a list of 
 * text parts and editor variables.
 */
public class CompoundLexicalItem extends LexicalItem {
  
  /**
   * The lexical units that form the parameter.
   */
  private final List<LexicalItem> lexicalItems;
  
  /**
   * Constructor.
   * 
   * @param lexicalItems The lexical units that form the parameter.
   */
  public CompoundLexicalItem(List<LexicalItem> lexicalItems) {
    super(Type.COMPOUND_ITEM);
    this.lexicalItems = new ArrayList<>(lexicalItems);
  }

  /**
   * @return The lexical units that form the parameter.
   */
  public List<LexicalItem> getLexicalItems() {
    return new ArrayList<>(lexicalItems);
  }

  @Override
  public String toString() {
    return "'" + lexicalItems + "', type: " + getType();
  }
  
  @Override
  public String getStringValue() {
    StringBuilder sb = new StringBuilder();
    for (LexicalItem item : lexicalItems) {
      sb.append(item.getStringValue());
    }
    
    return sb.toString();
  }
}