package ro.sync.util.editorvars.expander;

import java.util.regex.Pattern;

/**
 * Utility class for process URLs
 * 
 * @author cosmin_duna
 */
public final class URLUtil {

  /**
   * Constructor.
   *
   * @throws UnsupportedOperationException when invoked.
   */
  private URLUtil() {
    // Private to avoid instantiations
    throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
  }

  /**
   * Pattern used to filter passwords.
   */
  @SuppressWarnings("java:S4784")
  // Safe here
  private static final Pattern TO_REPLACE = Pattern.compile("://([^\\:\\/\\@]*?):([^\\:\\/]*?)@");

  /**
   * Filters the eventual url passwords from the given string.
   * 
   * @param message The message to be filtered.
   * @return The cleaned message.
   */
  public static String filterPasswords(String message) {
    if (message != null
        //Faster filter passwords
        && message.indexOf('@') > -1) {
      message = TO_REPLACE.matcher(message).replaceAll("://$1:******@");
    }
    return message;
  }
}
