<?xml version="1.0" encoding="UTF-8"?>
<!--
    Converts the XML intermediate format to FO.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:chfox="http://www.oxygenxml.com/chemistry/extensions/fop"
    xmlns:css="http://www.w3.org/1998/CSS"
    xmlns:fo="http://www.w3.org/1999/XSL/Format"
    exclude-result-prefixes="xs css chfox"
    version="2.0">

    <xsl:import href="xmltofo-functions-library.xsl"/>
    <xsl:import href="xmltofo-copy-engine.xsl"/>
    <xsl:import href="xmltofo-named-destinations.xsl"/>
    <xsl:import href="xmltofo-display-basic.xsl"/>
    <xsl:import href="xmltofo-display-changebars.xsl"/>
    <xsl:import href="xmltofo-display-none.xsl"/>
    <xsl:import href="xmltofo-display-inlines.xsl"/>
    <xsl:import href="xmltofo-display-blocks.xsl"/>
    <xsl:import href="xmltofo-display-lists.xsl"/>
    <xsl:import href="xmltofo-display-table.xsl"/>
    <xsl:import href="xmltofo-static-content.xsl"/>
    <xsl:import href="xmltofo-font-variant.xsl"/>
    <xsl:import href="xmltofo-hyphenation.xsl"/>
    <xsl:import href="xmltofo-overflow-wrap.xsl"/>       
    <xsl:import href="xmltofo-white-space.xsl"/>
  
    <xsl:import href="xmltofo-pages.xsl"/>
    <xsl:import href="xmltofo-footnotes.xsl"/>
    <xsl:import href="xmltofo-margin-border-padding.xsl"/>
    <xsl:import href="xmltofo-reference-orientation.xsl"/>
    <xsl:import href="xmltofo-background-images.xsl"/>
    <xsl:import href="xmltofo-links.xsl"/>
    
    <xsl:import href="xmltofo-svg.xsl"/>
    <xsl:import href="xmltofo-mathml.xsl"/>

    <xsl:import href="xmltofo-metadata.xsl"/>
    <xsl:import href="xmltofo-bookmarks.xsl"/>
    <xsl:import href="xmltofo-accessibility.xsl"/>
    
    <xsl:import href="xmltofo-bidi.xsl"/>
    <xsl:import href="xmltofo-i18n.xsl"/>
    
    <xsl:import href="xmltofo-pseudo-first-line.xsl"/>
    <xsl:import href="xmltofo-pseudo-first-letter.xsl"/>

    <xsl:import href="xmltofo-floats.xsl"/>
    <xsl:import href="xmltofo-breaks.xsl"/>
    
<!--    <xsl:output indent="yes"/>  -->
    
    <!-- Metadata about the PDF engine, passed from the Java code. -->
    <xsl:param name="application-name" select="'oXygen PDF Chemistry'"/>
    <xsl:param name="application-version" />
    <xsl:param name="application-build-timestamp"/>
      
</xsl:stylesheet>