<?xml version="1.0" encoding="UTF-8"?>
<!-- 
   The CSS white-space property. Converted to FO attributes.  
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:css="http://www.w3.org/1998/CSS"
  exclude-result-prefixes="css"
  version="2.0">
  
  <xsl:template match="@css:white-space[. = 'pre-wrap']" priority="2">
    <xsl:attribute name="linefeed-treatment" select="'preserve'"/>
    <xsl:attribute name="white-space-collapse" select="'false'"/>
    <xsl:attribute name="white-space-treatment" select="'preserve'"/>
    <xsl:attribute name="wrap-option" select="'wrap'"/>
  </xsl:template>
  
  <xsl:template match="*[@css:white-space[. = 'pre-wrap']]/descendant::text()">
    <xsl:value-of select="replace(.,'[ \t]*\n','&#10;')"/>
  </xsl:template>

  <xsl:template match="@css:white-space[. = 'nowrap']" priority="2">
    <xsl:attribute name="keep-together.within-line" select="'always'"/>
    <xsl:attribute name="wrap-option" select="'no-wrap'"/>
  </xsl:template>
  
</xsl:stylesheet>