<?xml version="1.0" encoding="UTF-8"?>
<!--
    This stylesheet deals with static content.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:css="http://www.w3.org/1998/CSS"    
    xmlns:fo="http://www.w3.org/1999/XSL/Format" 
    xmlns:oxy="http://www.oxygenxml.com/css2fo"
    exclude-result-prefixes="xs oxy"
    version="2.0">
    
    <xsl:import href="xmltofo-static-content-string-sets.xsl"/>
    <xsl:import href="xmltofo-static-content-images.xsl"/>
    <xsl:import href="xmltofo-static-content-video.xsl"/>
    
    <!--
        General counters. The value is already computed in the intermediate format.
    -->
    <xsl:template match="css:counter">
        <xsl:value-of select="@value"/>
    </xsl:template>
    
    <!-- 
        Page counter. 
    -->
    <xsl:template match="css:counter[@name='page']">
        <fo:page-number/>
    </xsl:template>
    
    <!-- 
        Total number of pages counter.         
    -->
    <xsl:template match="css:counter[@name='pages']">
        <fo:page-number-citation-last ref-id="last-page-sequence"/>
    </xsl:template>
    
    <!-- 
        Static text.
    -->
    <xsl:template match="css:text">
        <xsl:apply-templates/>
    </xsl:template>
    
    <!-- 
        Styled static text, we need a wrapper for it.
    -->
    <xsl:template match="css:text[@css:*]">
        <fo:inline>
            <xsl:apply-templates select="@*"/>
            <xsl:apply-templates/>
        </fo:inline>
    </xsl:template>
    
    <!-- 
        Target counter (page number citation).
    -->
    <xsl:template match="css:target-counter">
        <fo:page-number-citation ref-id="{@url-fragment}"/>
    </xsl:template>
    
    <!--
        Leaders.
    -->
    
    <!-- The CSS leaders have only a string pattern. -->
    <xsl:template match="css:leader">
        <xsl:choose>
            <xsl:when test="@pattern = ' '">
                <fo:leader leader-pattern="space"/>
            </xsl:when>
            <xsl:when test="@pattern = '.'">
                <fo:leader leader-pattern="dots"/>
            </xsl:when>
            <xsl:otherwise>
                <fo:leader leader-pattern="use-content"><xsl:value-of select="@pattern"/></fo:leader>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!--
        This element represents the value of the 'content' CSS property set directly on an element, not on a pseudo.
        The css:before and css:after are processes by the generic template from xmltofo-display-basics.    
    -->
    <xsl:template match="css:content-on-element">
        <fo:inline><xsl:apply-templates/></fo:inline>
    </xsl:template>
    
    <!-- 
        Discard any real content of the elements that have a content property set directly on them not on a pseudo.
        Make sure it does not discards the 'after' pseudos.
    -->
    <xsl:template match="node()[preceding-sibling::css:content-on-element][not(self::css:after)]" priority="5"/>
    
    <xsl:template match="css:form-control" priority="5"/>
    
</xsl:stylesheet>