<?xml version="1.0" encoding="UTF-8"?>
<!--
    This stylesheet deals with HTML image maps.
    It is a kind of a hack, we need some CSS properties 
    to define an element as being an image map for another 
    image element, but is way too complicated and seldom 
    use except HTML.     
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:css="http://www.w3.org/1998/CSS"    
    xmlns:fo="http://www.w3.org/1999/XSL/Format" 
    xmlns:oxy="http://www.oxygenxml.com/css2fo"
    xmlns:fox="http://xmlgraphics.apache.org/fop/extensions"
    xmlns:chfox="http://www.oxygenxml.com/chemistry/extensions/fop" 
    xmlns:svg="http://www.w3.org/2000/svg"
    xmlns:xlink="http://www.w3.org/1999/xlink"    
    exclude-result-prefixes="xs oxy fox svg xlink chfox"
    version="2.0">
    
    
    <!-- 
      Discard the map element, it will be converted into a set of attributes on the graphic.
     -->
    <xsl:template match="/css:root/css:page-sequence/*:html//*:map" />
    
    
    <!-- 
      Match an element that makes use of a map.
     -->
    <xsl:template match="/css:root/css:page-sequence/*:html//*:img[@usemap][@src]">
      <xsl:variable name="produced">
        <xsl:next-match/>
      </xsl:variable>
      
      <!-- Get the name of the map. -->
      <xsl:variable name="map-name" select="if (starts-with(@usemap, '#')) then substring-after(@usemap,'#') else @usemap"/>
      
      <xsl:apply-templates select="$produced" mode="imagemap">
        <xsl:with-param name="map" select="/css:root/css:page-sequence/*:html//*:map[@id = $map-name or @name = $map-name]" tunnel="yes"/>        
      </xsl:apply-templates>
      
    </xsl:template>
    
    <!-- 
      A recursive copy template.
     -->
    <xsl:template match="node() | @*" mode="imagemap">
      <xsl:copy>
        <xsl:apply-templates select="node() | @*" mode="#current"/>
      </xsl:copy>
    </xsl:template>
  
    <!-- 
      Match the external graphic and encode the map information in some attributes
      that will end up in the Area Tree.
     -->
    <xsl:template match="fo:external-graphic" mode="imagemap">
      <xsl:param name="map" tunnel="yes"/>
      <xsl:copy>
        <xsl:apply-templates select="$map" mode="imagemap"/>
        <xsl:apply-templates select="node() | @*" mode="#current"/>
      </xsl:copy>
    </xsl:template>
  
    <!-- 
      Creates attributes.
     -->
    <xsl:template match="*:map" mode="imagemap">
      <xsl:attribute name="chfox:map-areas-count" select="count(*:area)"/>
      <xsl:for-each select="*:area">
        <xsl:attribute name="chfox:map-area-href-{position()}" select="@href"/>
        <xsl:attribute name="chfox:map-area-alt-{position()}" select="@alt"/>
        <xsl:attribute name="chfox:map-area-shape-{position()}" select="@shape"/>
        <xsl:attribute name="chfox:map-area-coords-{position()}" select="@coords"/>
      </xsl:for-each>
    </xsl:template>
    
</xsl:stylesheet>