<?xml version="1.0" encoding="UTF-8"?>
<!--
    
    This stylesheet deals with reference-orientation properties..
    
-->
<xsl:stylesheet version="2.0"
    xmlns:css="http://www.w3.org/1998/CSS" 
    xmlns:fo="http://www.w3.org/1999/XSL/Format"
    xmlns:oxy="http://www.oxygenxml.com/css2fo" 
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    
    exclude-result-prefixes="xs oxy">

    <!-- 
		The reference orientation is taken care in the table templates. 
		No need to generate a block container, as it is generated one already around the table.		
	-->
    <xsl:template match="css:reference-orientation-container[*[@css:display = 'table']]">
        <xsl:apply-templates/>
    </xsl:template>

    <!--  
		The reference orientation container is transformed to a fo:block-container.
		The fo:block-container can be used then to rotate the content.
	 -->
    <xsl:template match="css:reference-orientation-container[*[@css:display = 'block']]">
       <fo:block-container>
         <xsl:copy-of select="@reference-orientation"/>

	       <!-- Move here the margin top and bottom, they are not to be rotated. The left and right are discarded (the CSS does).  -->  
         <xsl:if test="*[1]/@css:margin-top">
            <xsl:attribute name="margin-top" select="*[1]/@css:margin-top"/>
         </xsl:if>
         <xsl:if test="*[1]/@css:margin-bottom">
            <xsl:attribute name="margin-bottom" select="*[1]/@css:margin-bottom"/>
         </xsl:if>
         
           
         <xsl:apply-templates select="*[1]"/>
     </fo:block-container>
    </xsl:template>
    
    <!--  
      For the cells marked for rotation, that do not have a block inside them,
      generate structure.
    -->
    <xsl:template match="*[@css:display = 'table-cell']/css:reference-orientation-container[not(*[@css:display = 'block'] or *[@css:display = 'table'])]">
       <fo:block-container>
         <xsl:copy-of select="@reference-orientation"/>

         <!-- Move here the margin top and bottom, they are not to be rotated. The left and right are discarded (the CSS does).  -->  
         <xsl:if test="*[1]/@css:margin-top">
            <xsl:attribute name="margin-top" select="*[1]/@css:margin-top"/>
         </xsl:if>
         <xsl:if test="*[1]/@css:margin-bottom">
            <xsl:attribute name="margin-bottom" select="*[1]/@css:margin-bottom"/>
         </xsl:if>

         <!-- Emulate a block container, we set on this the width and height of the cell. -->  
         <fo:block-container reference-orientation="0">
           <xsl:if test="../@css:width">
               <xsl:attribute name="width" select="../@css:width"/>
           </xsl:if>
           <xsl:if test="../@css:height">
               <xsl:attribute name="height" select="../@css:height"/>
           </xsl:if>
           <fo:block start-indent="0" end-indent="0">
            <xsl:apply-templates/>
           </fo:block>
         </fo:block-container>
       
     </fo:block-container>
    </xsl:template>

    <!-- 
       Generate the reference-orientation on all rotated containers,
       except for the table cells, where the reference orientation 
       is moved on a synthetic element.
     -->
    <xsl:template match="@css:transform-rotation">
      <xsl:attribute name="reference-orientation" select="."/>
    </xsl:template>
    <xsl:template match="*[@css:display = 'table-cell']/@css:transform-rotation" priority="2"/>
    
    <!-- 
      The cells marked for rotation have their width and height migrated to the 
      synthetic block that is effectively rotated.
     -->
    <xsl:template match="*[@css:display='table-cell'][@css:transform-rotation]/@css:width"/>
    <xsl:template match="*[@css:display='table-cell'][@css:transform-rotation]/@css:height"/>
    <xsl:template match="*[@css:display = 'table-cell']/@css:transform-rotation"/>


    <!--  
      The reference orientation container for a page margin box is transformed to a fo:block-container.
      The size of the container is taken from the sizes of the page margin box.     
    -->
    <xsl:template match="css:reference-orientation-container-pmb">
       <xsl:param name="margin-box-width" tunnel="yes"/>
       <xsl:param name="margin-box-height" tunnel="yes"/>
        
       <fo:block-container>
         <xsl:copy-of select="@reference-orientation"/>

         <!--  The width and height are important for the rotation. Switch them. -->
         <xsl:attribute name="height" select="$margin-box-width"/>
         <xsl:attribute name="width" select="$margin-box-height"/>
           
         <fo:block start-indent="0" end-indent="0">
            <xsl:apply-templates/>
         </fo:block>
     </fo:block-container>
    </xsl:template>

</xsl:stylesheet>
