<?xml version="1.0" encoding="UTF-8"?>
<!-- 
    Deals with the overflow-wrap property. For break-word, it introduces soft 
    hyphens between the letters, but only for long words. The best implementation 
    would be at the FOP layout manager level.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fo="http://www.w3.org/1999/XSL/Format"
    xmlns:oxy="http://www.oxygenxml.com/css2fo" xmlns:css="http://www.w3.org/1998/CSS"
    xmlns:chfox="http://www.oxygenxml.com/chemistry/extensions/fop" 
    exclude-result-prefixes="xs oxy css" version="2.0">

    <xsl:template match="@css:overflow-wrap">
      <xsl:attribute name="chfox:overflow-wrap" select="."/>
      
        <!-- When turning on overflow-wrap, turn off the hyphenation, if set on one of the parents.-->
        <xsl:if test="ancestor::*[@css:hyphens]">
          <xsl:attribute name="hyphenate" select="'false'"/>      
        </xsl:if>
        
    </xsl:template>

</xsl:stylesheet>

