<?xml version="1.0" encoding="UTF-8"?>
<!-- 
    Templates that generate blocks or inlines - targets of named destinations.
    
    By default all id attributes are declared as named destinations.
    
    However, the nd-id attributes are used to generate targets. We needed this support
    for DITA, since the id attributes are rewritten, and the original id value 
    is stored in the nd-id attribute. 
    
    In order to keep working the internal linking, we leave the id attribute untouched, 
    and we generate additional structures for the nd-id attribute. 
        
-->
<xsl:stylesheet 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:fo="http://www.w3.org/1999/XSL/Format" 
    xmlns:css="http://www.w3.org/1998/CSS" 
    xmlns:nd="http://www.oxygenxml.com/css2fo/named-destinations"
    xmlns:chfox="http://www.oxygenxml.com/chemistry/extensions/fop"
    xmlns:fox="http://xmlgraphics.apache.org/fop/extensions"
    xmlns:oxy="http://www.oxygenxml.com/css2fo" 
    exclude-result-prefixes="#all" 
    version="2.0">
    <!-- Forward the attribute as a Chemistry FOP extension attribute -->
    <xsl:template match="@nd:nd-id">
      <xsl:attribute name="chfox:nd-id" select="."/>
    </xsl:template>
    
    
    <!-- 
      Dumps the list of fox:destinations for all ids and nd-ids. 
      The nd-id take precedence if id is set on the same element. 
    -->
    <xsl:template name="generate-named-destination-list">
       <xsl:for-each select="//*[@id != ''][not(@nd:nd-id)][not(@css:display='none')]" exclude-result-prefixes="fox">
          <fox:destination internal-destination="{@id}"/>
       </xsl:for-each>
       <xsl:for-each select="//*[@nd:nd-id != ''][not(@css:display='none')]" exclude-result-prefixes="fox">
          <fox:destination internal-destination="{@nd:nd-id}"/>
       </xsl:for-each>    
    </xsl:template>
    
</xsl:stylesheet>
