<!--
  
    Deals with language information.
    
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:xs="http://www.w3.org/2001/XMLSchema"
  xmlns:css="http://www.w3.org/1998/CSS"
  xmlns:fo="http://www.w3.org/1999/XSL/Format"
  xmlns:oxy="http://www.oxygenxml.com/css2fo" 
  
  exclude-result-prefixes="xs css oxy"
  version="2.0">
  
  <!-- 
    Propagate the xml:lang on the FO elements. 
  -->
  <xsl:template match="@xml:lang" priority="3">
    <xsl:copy-of select="."/>
  </xsl:template>
  
  
  <!-- 
  	Convert the HTML lang attributes to xml:lang.
   -->
  <xsl:template match="@lang" priority="3">
  	<!-- Only if the root of the document is HTML. -->
 	<xsl:if test="/css:root/css:page-sequence/*:html">
 		<xsl:attribute name="xml:lang" select="."/>
    </xsl:if>
  </xsl:template>
  
  
  
  <!-- 
    Gets the first xml:lang that was defined on root of the original XML document.
    
    This attribute should be also set on the fo:root element, so it will apply to the 
    entire FO document, including metadata.
    
    The other xml:lang attributes set on other elements are copied.
        
    @param doc The context document. We need it to search the property in it
    @return a string with the value of the xml:lang.
    -->
  <xsl:function name="oxy:get-xml-lang-from-root" as="xs:string">
    <xsl:param name="doc"/>
    
    
    <!-- Use XML lang -->
    <xsl:variable name="xml-lang" select="$doc/css:root/css:page-sequence[1]/*/@xml:lang"/>
    <!-- Or if the document is HTML, the lang attribute. -->
    <xsl:variable name="xml-lang" select="if ($xml-lang) then $xml-lang else $doc/css:root/css:page-sequence[1]/*:html/@lang"/>
    
    <xsl:value-of select="if ($xml-lang) then $xml-lang else 'dflt'"/>
  </xsl:function>
  
</xsl:stylesheet>