<?xml version="1.0" encoding="UTF-8"?>
<!--
    Stylesheet for hyphenation.  
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:chfox="http://www.oxygenxml.com/chemistry/extensions/fop" 
    xmlns:css="http://www.w3.org/1998/CSS"
    xmlns:fo="http://www.w3.org/1999/XSL/Format" 
    xmlns:oxy="http://www.oxygenxml.com/css2fo"
    
    exclude-result-prefixes="xs oxy"
    version="2.0">
    
    <!-- Hyphenation. -->
    <xsl:template match="@css:hyphens[.='manual']" priority="2">
    	<!-- False means 'manual' for FOP. -->
    	<xsl:attribute name="hyphenate" select="'false'"/>
    </xsl:template>
    <xsl:template match="@css:hyphens[.='auto']" priority="2">
    	<xsl:attribute name="hyphenate" select="'true'"/>
      
        <!-- When turning on hyphenation, turn off the overflow-wrap, if set on one of the parents.-->
        <xsl:if test="ancestor::*[@css:overflow-wrap]">
          <xsl:attribute name="chfox:overflow-wrap" select="'normal'"/>
        </xsl:if>
        
    </xsl:template>
    <xsl:template match="@css:hyphens[.='none']" priority="2">
        <xsl:message>WARNING 'none' hyphenation is not supported, using 'manual' instead.</xsl:message>
    	<xsl:attribute name="hyphenate" select="'false'"/>
    </xsl:template>
    <xsl:template match="@css:oxy-hyphenation-character" >
      <xsl:attribute name="hyphenation-character" select="."/>
    </xsl:template>    
    <xsl:template match="@css:oxy-hyphenation-remain-character-count" >
      <xsl:attribute name="hyphenation-remain-character-count" select="."/>
    </xsl:template>    
    <xsl:template match="@css:oxy-hyphenation-push-character-count" >
      <xsl:attribute name="hyphenation-push-character-count" select="."/>
    </xsl:template>
    
    <xsl:template match="@css:oxy-avoid-breaking-line-at-hyphens" >
      <xsl:choose>
        <xsl:when test=".='yes'">
          <xsl:attribute name="avoid-breaking-line-at-hyphens" select="'true'"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="avoid-breaking-line-at-hyphens" select="'false'"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:template>
    
    <xsl:template match="@css:oxy-break-line-at-hyphens" >
      <xsl:attribute name="break-line-at-hyphens" select="."/>
    </xsl:template>
    
</xsl:stylesheet>