<?xml version="1.0" encoding="UTF-8"?>
<!-- 
    Deals with the font-variant property. For small-caps, it wraps the text into 
    inlines with a different font size and converts the lower case to upper case letters. 
            
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fo="http://www.w3.org/1999/XSL/Format"
    xmlns:oxy="http://www.oxygenxml.com/css2fo" xmlns:css="http://www.w3.org/1998/CSS"
    exclude-result-prefixes="xs oxy css" version="2.0">

    <!-- Do not pass it to the FO, we are using wrappers. -->
    <xsl:template match="@css:font-variant" priority="2"/>

    <!-- 
      
      Matches the text that has an ancestor with a font-variant property.
      
    -->
    <xsl:template match="text()[ancestor::*[@css:font-variant][1]/@css:font-variant = 'small-caps']" priority="4">
        <xsl:call-template name="wrap-in-small-caps">
          <xsl:with-param name="text" select="."/>
        </xsl:call-template>
    </xsl:template>

    <!-- 
      The upper case letters are left as they are, the lowercase are converted 
      to uppercase and set a smaller font size on them.
      
      @param text The text to be wrapped.
     -->
    <xsl:template name="wrap-in-small-caps">
      <xsl:param name="text"/>
      
      <xsl:variable name="char" select="substring($text,1,1)"/>
      <xsl:variable name="upper-case" select="upper-case($char)"/>
      <xsl:choose>
        <xsl:when test="$char = $upper-case">
            <!-- Uppercase, leave it as it is. -->
            <xsl:value-of select="$upper-case"/>
        </xsl:when>
        <xsl:otherwise>
          <fo:inline font-size="70%">
            <!-- 
              Normal, make it uppercase, but smaller. This rapport makes 
              the Times font normal small letters equal in height with the small-caps ones.
              
              72% is used by Firefox.
            -->            
            <xsl:value-of select="$upper-case"/>
          </fo:inline>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:if test="string-length($text) &gt; 1">
        <xsl:call-template name="wrap-in-small-caps">
          <xsl:with-param name="text" select="substring($text, 2)"/>
        </xsl:call-template>
      </xsl:if>
    </xsl:template>
    

</xsl:stylesheet>
