<?xml version="1.0" encoding="UTF-8"?>
<!-- 
    Deals with floated elements.    
-->
<xsl:stylesheet 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:xs="http://www.w3.org/2001/XMLSchema" 
    xmlns:fo="http://www.w3.org/1999/XSL/Format" 
    xmlns:oxy="http://www.oxygenxml.com/css2fo" 
    xmlns:css="http://www.w3.org/1998/CSS" 
    
    exclude-result-prefixes="xs oxy css" 
    version="2.0">

	<xsl:template match="@css:float"/>

    <!-- 
        Template matching the elements with a float property. Translates this property to a fo:float element.        
    -->
    <xsl:template match="*[@css:display = 'block' or @css:display = 'table'][@css:float][@css:float = 'left' or @css:float = 'right' or @css:float = 'top']" priority="7">
       <fo:float>
           <xsl:attribute name="float">
               <xsl:choose>
                   <xsl:when test="@css:float = 'left'">left</xsl:when>
                   <xsl:when test="@css:float = 'right'">right</xsl:when>
                   <xsl:when test="@css:float = 'top'">before</xsl:when>
               </xsl:choose>
           </xsl:attribute>
           <fo:block>
           <xsl:next-match/>
           </fo:block>
       </fo:float>
    </xsl:template>
        
</xsl:stylesheet>
